#ifndef WCE_PEER_H_INCLUDED
#define WCE_PEER_H_INCLUDED

#include <windows.h>
#include <jni.h>
#include <assert.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * RGB565DIB쐬ۂɎgp\
 * BITMAPINFOɃLXgCreateDIBSection()ɓn
 */

typedef struct BITMAPINFO_RGB565_t {
	BITMAPINFOHEADER bmiHeader;
	DWORD dwRedMask;
	DWORD dwGreenMask;
	DWORD dwBlueMask;
} BITMAPINFO_RGB565;

/**
 * P̃j[o[ɑ݂ł郁j[ő吔
 */
#define	MAX_MENUS	128

/**
 * VXeEChENX
 */
extern const _TCHAR* g_system_window_class_name;

/**
 * FramepEChENX
 */
extern const _TCHAR* g_frame_class_name;

/**
 * Color.getRGB()ԂlACOLORREFɕϊ
 */
#define TO_COLORREF(rgb) ((((rgb) >> 16) & 0xff) | ((rgb) & 0xff00) | (((rgb) << 16) & 0xff0000))

void init(JNIEnv* env);
void initialize_system_window(JNIEnv* env, jobject toolkit);

/**
 * ButtonɑΉlCeBuR|[lg쐬
 */
HWND create_native_button(jobject peer, HWND hwndParent, int x, int y, int width, int height);

/**
 * CanvasɑΉlCeBuR|[lg쐬
 */
HWND create_native_canvas(jobject peer, HWND hwndParent, int x, int y, int width, int height);

/**
 * CheckboxɑΉlCeBuR|[lg쐬
 */
HWND create_native_checkbox(jobject peer, HWND hwndParent, int x, int y, int width, int height, jobject checkBoxGroup);

/**
 * ChoiceɑΉlCeBuR|[lg쐬
 */
HWND create_native_choice(jobject peer, HWND hwndParent, int x, int y, int width, int height);

/**
 * DialogɑΉlCeBuR|[lg쐬
 */
HWND create_native_dialog(jobject peer, HWND hwndParent, jint x, jint y, jint width, jint height, jboolean undecorated);

/**
 * FileDialogɑΉlCeBuR|[lg쐬
 */
HWND create_native_file_dialog(jobject peer, HWND hwndParent, int x, int y, int width, int height);

/**
 * FrameɑΉlCeBuR|[lg쐬
 */
HWND create_native_frame(jobject peer, HWND hwndParent, jint x, jint y, jint width, jint height, jboolean undecorated);

/**
 * LabelɑΉlCeBuR|[lg쐬
 */
HWND create_native_label(jobject peer, HWND hwndParent, int x, int y, int width, int height);

/**
 * ListɑΉlCeBuR|[lg쐬
 */
HWND create_native_list(jobject peer, HWND hwndParent, int x, int y, int width, int height, BOOL multi);

/**
 * PanelɑΉlCeBuR|[lg쐬
 */
HWND create_native_panel(jobject peer, HWND hwndParent, int x, int y, int width, int height);

/**
 * ScrollbarɑΉlCeBuR|[lg쐬
 */
HWND create_native_scrollbar(jobject peer, HWND hwndParent, int x, int y, int width, int height, int orientation);

/**
 * ScrollpaneɑΉlCeBuR|[lg쐬
 */
HWND create_native_scroll_pane(jobject peer, HWND hwndParent, int x, int y, int width, int height, int policy);

/**
 * TextFieldɑΉlCeBuR|[lg쐬
 */
HWND create_native_text_field(jobject peer, HWND hwndParent, int x, int y, int width, int height);

/**
 * TextAreaɑΉlCeBuR|[lg쐬
 */
HWND create_native_text_area(jobject peer, HWND hwndParent, int x, int y, int width, int height, int scrollbarVisibility);

/**
 * WindowɑΉlCeBuR|[lg쐬
 */
HWND create_native_window(jobject peer, HWND hwndParent, int x, int y, int width, int height);

/**
 * w肳ꂽR|[lg̕\ԂύX
 */
void set_visible(JNIEnv* env, HWND hwnd, BOOL visible);

/**
 * w肳ꂽEChEŔwʂɈړ
 */
void to_back(JNIEnv* env, HWND hwnd);

/**
 * w肳ꂽEChEőOʂɈړ
 */
void to_front(JNIEnv* env, HWND hwnd);

/**
 * EChE̗L^؂ւ
 */
void set_enabled(JNIEnv* env, HWND hwnd, BOOL enabled);

/**
 * EChẼTCYύX
 */
void set_bounds(JNIEnv* env, HWND hwnd, int x, int y, int width, int height);

// ݖgp
void get_bounds(JNIEnv* env, HWND hwnd, int* px, int* y, int* width, int* height);

/* !!!! Mod PeteC 2006-06-20 */
void set_focus(HWND hwnd);
/* !!!! End Mod PeteC 2006-06-20 */

HWND get_focus();

/**
 * EChEj
 */
void dispose(JNIEnv* env, jobject peer_obj, HWND hwnd);

/**
 * EChẺʏɂWԂ
 */
jobject get_location_on_screen(JNIEnv* env, HWND hwnd);

/**
 * wiFݒ肷
 */
void set_background(JNIEnv* env, jobject peer_obj, HWND hWnd, jint rgb);

/**
 * OʐFݒ肷
 */
void set_foreground(JNIEnv* env, jobject peer_obj, HWND hWnd, jint rgb);

/**
 * OSbZ[W
 */
void handle_native_message(JNIEnv* env, HWND hWnd, UINT msg, WPARAM wp, LPARAM lp);

/**
 * j[ACeɕt^郆j[NȃR}hID쐬
 */
WORD create_menu_item_id(HMENU hmenuParent);

/**
 * j[ACẽR}hIDėp\ɂ
 */
void delete_menu_item_id(WORD id);

/**
 * w肳ꂽHWNDɑΉ郁j[o[̃EChEnhԂ
 * j[o[ȂꍇNULLԂB
 */
HWND get_menu_bar_of(HWND hwnd);

/**
 * |bvAbvj[\
 */
void show_popup_menu(JNIEnv* env, jobject peer_obj, HWND hwnd, HMENU hmenu, int x, int y);

/**
 * w肳ꂽCheckboxɑ΂āACheckboxGroupݒ肷
 */
void set_checkbox_group(HWND windowHandle, jobject checkboxGroup);


/**
 * jstring̓e_TCHAR*ɕϊ
 * ̊֐̖߂l malloc() ŊmۂĂ̂ŁAsvɂȂ_free()gp
 * Kv
 */
_TCHAR* get_string_chars(JNIEnv* env, jstring str);

/**
 * XN[o[̍sݒ肷
 */
void set_scrollbar_line_increment(HWND hwndScroll, int inc);

/**
 * XN[o[̃y[Wݒ肷
 */
void set_scrollbar_page_increment(HWND hwndScroll, int inc);

/**
 * w肳ꂽfoCXReLXg
 */
void init_DC(HDC hdc);

/**
 * ScrollPanẽXN[o[Ɋւp[^ݒ肷
 */
void set_scroll_pane_scrollbar_parameters(HWND hwnd, int scrollbarType, int maximum, int visibleAmount);

/**
 * ScrollPanẽXN[ʒuݒ肷
 */
void set_scroll_pane_scroll_position(HWND hwnd, int oldX, int oldY, int newX, int newY);

/**
 * Dialog̕\^\؂ւ
 */
void set_dialog_visible(HWND hwnd, BOOL visible, BOOL modal);

/**
 * Component̃J[\ݒ肷
 */
void set_cursor(HWND hwnd, int type);

/**
 * Component̃tHgݒ肷
 */
void set_font(HWND hwnd, HFONT hFont);

/**
 * w肳ꂽeLXg̃TCYԂ
 */
void get_text_extent_point(HWND hwnd, const _TCHAR* text, SIZE* psize);

/**
 * Window.setBoundsCallback()Ăяo
 */
void call_Window_setBoundsCallback(JNIEnv* env, jobject window, jint x, jint y, jint width, jint height);

/**
 * AWTErrorthrow
 */
void throw_AWTError(JNIEnv* env, const char* message);

/**
 * w肳ꂽEChEɑΉ郁j[o[̕\^\؂ւ
 * w肳ꂽEChEj[o[Ȃꍇɂ͉Ȃ
 */
void set_menu_bar_visible(HWND hwndFrame, BOOL visible);

#ifdef __cplusplus
}
#endif

#endif
