/* WCESecureRandomSpi.java 
   Copyright (C) 2009 Mysaifu.com

This file is part of Mysaifu JVM.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with Mysaifu JVM; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package com.mysaifu.jvm.java.security.provider;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;

public class WCESecureRandomSpi extends SecureRandomSpi
{
  static
  {
    WCESecurity.loadLibraries();
  }
  
  private int nativePointer;
  
  public WCESecureRandomSpi()
  {
    this.nativePointer = openNative();
  }
  
  private native int openNative();

  private void close()
  {
    closeNative(this.nativePointer);
    this.nativePointer = 0;
  }
  
  private native void closeNative(int nativePointer);
  
  @Override
  protected void engineSetSeed(byte[] seed)
  {
    engineNativeSetSeed(this.nativePointer, seed);
  }
  
  private native void engineNativeSetSeed(int nativePointer, byte[] seed);
  
  @Override
  protected void engineNextBytes(byte[] bytes)
  {
    engineNativeNextBytes(this.nativePointer, bytes);
  }
  
  private native void engineNativeNextBytes(int nativePointer, byte[] bytes);
  
  @Override
  protected byte[] engineGenerateSeed(int numBytes)
  {
    return engineNativeGenerateSeed(this.nativePointer, numBytes);
  }
  
  private native byte[] engineNativeGenerateSeed(int nativePointer, int numBytes);

  /**
   * ftHgSecureRandomCX^XԂ
   */
  static SecureRandom getDefaultSecureRandom() throws NoSuchAlgorithmException
  {
    return SecureRandom.getInstance(WCESecurity.DEFAULT_SECURE_RANDOM_ALGOLITHM);
  }
  
  @Override
  protected void finalize()
  {
    close();
  }

}