/* WCECertificate.java -- implementation of X509Certificate
   Copyright (C) 2009 Mysaifu.com

This file is a part of Mysaifu JVM.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with Mysaifu JVM; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301
USA

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version.  */


package com.mysaifu.jvm.java.security.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;

public class WCECertificate
    extends gnu.java.security.x509.X509Certificate
{

  /**
   * ؖ̌،ʂNX
   */
  public static class TrustStatus
  {
    private final int errorStatus;

    private final int infoStatus;

    public TrustStatus(int error, int info)
    {
      this.errorStatus = error;
      this.infoStatus = info;
    }

    public int getErrorStatus()
    {
      return this.errorStatus;
    }

    public int getInfoStatus()
    {
      return this.infoStatus;
    }
  }

  /**
   * ؖ`F[
   */
  public static class Chain
  {
    WCEKeyStoreSpi keyStoreSpi;

    final String alias;

    final byte[][] encodedCertificates;

    final int chainErrorStatus;

    final int chainInfoStatus;

    /**
     * w肳ꂽɊÂAؖ`F[쐬B
     * 
     * @param keyStoreSpi
     *          ؖi[ĂWCEKeyStoreSpiBWCEKeyStoreSpiɊi[ĂȂؖ̏ꍇ
     *          <code>null</code>B
     * @param alias ̏ؖ`F[̕ʖBʖ݂Ȃꍇ<code>null</code>B
     * @param encodedCertificates ؖDERGR[hf[^
     * @param chainErrorStatus ؖ`F[،ʁB
     * @param chainInfoStatus ؖ`F[،ʂ̕tB
     */
    public Chain(WCEKeyStoreSpi keyStoreSpi, String alias,
                 byte[][] encodedCertificates, int chainErrorStatus,
                 int chainInfoStatus)
    {
      this.keyStoreSpi = keyStoreSpi;
      this.alias = alias;
      this.encodedCertificates = encodedCertificates;
      this.chainErrorStatus = chainErrorStatus;
      this.chainInfoStatus = chainInfoStatus;
    }

    /**
     * ؖ`F[ WCECertificate̔zƂĕԂB
     * 
     * @return ؖ`F[B
     */
    public WCECertificate[] getCertificates() throws CertificateException,
        IOException
    {
      WCECertificate[] result = null;
      if (encodedCertificates != null)
        {
          // GR[hꂽX509ؖAWCECertificateɕϊ
          result = new WCECertificate[encodedCertificates.length];
          for (int i = 0; i < encodedCertificates.length; ++i)
            {
              byte[] encoded = encodedCertificates[i];
              WCECertificate.TrustStatus ts = null;
              if (i == 0)
                {
                  ts = new WCECertificate.TrustStatus(chainErrorStatus,
                                                      chainInfoStatus);
                }
              result[i] = new WCECertificate(keyStoreSpi, alias, encoded, ts);
            }
        }
      return result;
    }
  }

  /**
   * ̏ؖ𐶐KeyStoreSpi. KeyStoreSpiȊOꍇɂnull.
   */
  private final WCEKeyStoreSpi keyStoreSpi;

  private final String alias;

  /**
   * ؖ`F[Ŝ̌، null̏ꍇAؖ`F[̌،ʂ͕słB
   */
  private final TrustStatus chainTrustStatus;

  /**
   * CX^X쐬
   * 
   * @param keyStoreSpi ̃CX^X𐶐KeyStoreB݂Ȃꍇ<code>null</code>
   * @param alias KeyStoreł̃GCAXBGCAX݂Ȃꍇ<code>null</code>
   * @param encoded DERGR[hꂽؖf[^
   * @param chainStatus ̏ؖ_Ƃꍇ́Aؖ`F[،ʁBsȏꍇ<code>null</code>
   */
  WCECertificate(WCEKeyStoreSpi keyStoreSpi, String alias, byte[] encoded,
                 TrustStatus chainStatus) throws CertificateException,
      IOException
  {
    super(new ByteArrayInputStream(encoded));
    this.alias = alias;
    this.keyStoreSpi = keyStoreSpi;
    this.chainTrustStatus = chainStatus;
  }

  WCECertificate(byte[] encoded) throws CertificateException, IOException
  {
    this(null, null, encoded, null);
  }
  /**
   * ̏ؖ_Ƃꍇ́Aؖ`F[،ʂԂB_ŕsȏꍇ<code>null</code>B
   */
  public TrustStatus getChainTrustStatus()
  {
    return this.chainTrustStatus;
  }

  /**
   * ̏ؖ̌ƂȂCERT_CONTEXT\̂ւ̃|C^ԂB sȏꍇ0ԂB
   */
  int getCertContext() throws CertificateException
  {
    if (this.keyStoreSpi != null)
      {
        return this.keyStoreSpi.getCertContextOf(this);
      }
    return 0;
  }

  /**
   * ̏ؖKeyStoreɂʖԂ ʖ݂Ȃꍇnull
   */
  String getAlias()
  {
    return this.alias;
  }
  
  /**
   * ̏ؖKeyStoreSpiԂB
   */
  WCEKeyStoreSpi getKeyStoreSpi()
  {
    return this.keyStoreSpi;
  }
}
