/* WCEImage.java
   Copyright (C) 2005-2009 Free Software Foundation, Inc.

This file is part of GNU Classpath.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with Mysaifu JVM; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package gnu.java.awt.peer.wce;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/**
 * Base class of Image.
 */
public abstract class WCEImage extends Image
{
  /**
   * use BitBlt() to draw the image.
   */
  public static final int BIT_BLT = 0;
	
  /**
   * use TransparentBlt() to draw the image.
   */
  public static final int TRANSPARENT_BLT = 1;
	
  /**
   * use AlphaBlend() to draw the image.
   */
  public static final int ALPHA_BLEND = 2;

  /**
   * width of this image.
   */
  private int width = -1;
	
  /**
   * height of this image.
   */
  private int height = -1;
	
  /**
   * status flag of this image.
   */
  private int flags;
	
  /**
   * property of this image.
   */
  private Hashtable props;
	
  /**
   * ImageObserver
   */
  private Set imageObservers = new HashSet();
	
  /**
   * a native bitmap handle associated with this image.
   */
  protected int bitmapHandle;
	
  /**
   * ImageProducer
   */
  protected ImageProducer source;
	
  /**
   * C[W̕ƃTCYݒ肷
   */
  protected void setDimension(int width, int height)
  {
    synchronized (this)
    {
      this.width = width;
      this.height = height;
      // tOݒ肷
      setFlags(getFlags() | ImageObserver.WIDTH | ImageObserver.HEIGHT);
    }
    
    // e ImageObserver ɒʒm
    notifyImageObservers(ImageObserver.WIDTH | ImageObserver.HEIGHT, 0, 0, width, height);
  }
	
  /**
   * C[W̕ԂB
   */
  public int getWidth()
  {
    return this.width;
  }
	
  /**
   * C[W̕ԂB
   */
  public int getWidth(ImageObserver observer)
  {
    addImageObserver(observer);
    return getWidth();
  }
	
  /**
   * C[W̍Ԃ
   */
  public int getHeight()
  {
    return this.height;
  }

  /**
   * C[W̍Ԃ
   */
  public int getHeight(ImageObserver observer)
  {
    addImageObserver(observer);
    return getHeight();
  }

  /**
   * add specified <code>ImageObserver</code>.
   */
  protected void addImageObserver(ImageObserver io)
  {
    if (io != null)
    {
      synchronized (this.imageObservers)
      {
        this.imageObservers.add(io);
      }
    }
  }

  public Object getProperty(String name, ImageObserver observer) {
    if (this.props == null)
    {
      return UndefinedProperty;
    }
    else
    {
      return props.get(name);
    }
  }

  /**
   * returns status of this image.
   */
  int checkImage(ImageObserver observer)
  {
    addImageObserver(observer);
    return this.flags;
  }
	
  protected void finalize()
  {
    flush();
  }

  /**
   * ImageɊ֘AtꂽEChEnhԂB
   */
  protected int getWindowHandle()
  {
    return 0;	// HWND == NULL (XN[S)
  }
	
  /**
   * ImageɊ֘Atꂽrbg}bvnhԂB
   */
  public int getBitmapHandle()
  {
    if (this.bitmapHandle == 0)
    {
      this.bitmapHandle = createBitmapHandle(getWindowHandle());
    }
    return this.bitmapHandle;
  }
	
  /**
   * rbg}bv쐬B
   *
   * @param	windowHandle			EChEnh
   * @return	rbg}bvnhB쐬łȂꍇ0
   *
   */
  protected abstract int createBitmapHandle(int windowHandle);
	
  public ImageProducer getSource()
  {
    if (this.source == null)
    {
      this.source = new WCEImageProducer(this);
    }
    return this.source;
  }
	
  public Graphics getGraphics()
  {
    // ̃NXGraphicsԂȂ
    return null;
  }
	
  /**
   * ̃CX^XɊ֘AtꂽlCeBu\[X폜
   */
  public void flush()
  {
    deleteNativeBitmapHandle(this.bitmapHandle);
  }
	
  /**
   * rbg}bv폜
   *
   * @param	bitmapHandle			폜ΏۂƂȂrbg}bvnh
   * @return	폜ɐꍇtrueB
   */
  protected native boolean deleteNativeBitmapHandle(int bitmapHandle);
	
  /**
   * w肳ꂽtO̐ݒ^s
   * Őݒ肵l checkImage() \bh̕ԂlɂȂB
   *
   * @param
   */
  protected void setFlags(int flag)
  {
    this.flags = flag;
  }

  protected int getFlags()
  {  
    return this.flags;
  }

	/**
	 * o^ꂽImageObserverɒʒm
	 */
  protected void notifyImageObservers(int flags, int x, int y, int width, int height)
  {
//System.err.println("WCEImage.notifyImageObservers() called. flags=" + flags);
    
    // fbhbN邽߁Asynchronized ubNO imageUpdate()Ăяo
    List removeList = new ArrayList();
    ImageObserver[] observers = null;
    synchronized (this.imageObservers)
    {
      observers = (ImageObserver[]) this.imageObservers.toArray(new ImageObserver[0]);
    }
    if (observers != null)
    {
      for (int i = 0; i < observers.length; ++i)
      {
        ImageObserver observer = observers[i];
        if (observer != null)
        {
          if (! observer.imageUpdate(this, flags, x, y, width, height))
          {
            // ʒm͕sv
            removeList.add(observer);
          }
        }
      }
    }
  
    // ʒmsvɂȂImageObserver폜
    synchronized (this.imageObservers)
    {
      for (int i = 0; i < removeList.size(); ++i)
      {
        this.imageObservers.remove(removeList.get(i));
      }
    }
//System.err.println("\tWCEImage.notifyImageObservers() return.");
  }
	
  /**
   * `APIԂ
   */
  public int getPreferredBltAPI()
  {
    // ftHg BitBlt()
    return BIT_BLT;
  }
	
  /**
   * FԂB
   * ԂꂽĺAWindows APICOLORREF^ (0x00BBGGRR)ƂȂB
   * {@link #getPreferredBltAPI()}{@link BIT_BLT}Ԃꍇɂ݈̂Ӗ̂lԂB
   */
  public int getTransparentColor()
  {
    // ftHgł͈Ӗ̂lԂȂB
    return 0;
  }
}
