/* WCESSLServerSocket.java -- 
   Copyright (C) 2009 Mysaifu.com

This file is part of Mysaifu JVM.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with Mysaifu JVM; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


package com.mysaifu.jvm.java.security.provider;

import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLServerSocket;

/**
 * SSLServerSocket implementation for Windows CE device.
 */
public class WCESSLServerSocket
    extends SSLServerSocket
{
  private final WCESSLContextSpi contextSpi;

  private String[] supportedCipherSuites = WCESSLEngine.getDefaultCipherSuites();

  private String[] enabledCipherSuites = WCESSLEngine.getDefaultCipherSuites();

  private String[] supportedProtocols = WCESSLEngine.SUPPORTED_PROTOCOLS;

  private String[] enabledProtocols = WCESSLEngine.SUPPORTED_PROTOCOLS;

  private boolean clientMode;

  private boolean needAuth;

  private boolean wantAuth;

  public WCESSLServerSocket(WCESSLContextSpi contextSpi) throws IOException
  {
    super();
    this.contextSpi = contextSpi;
    clientMode = false;
  }

  @Override
  public boolean getEnableSessionCreation()
  {
    return true;
  }

  @Override
  public String[] getEnabledCipherSuites()
  {
    return (String[]) this.enabledCipherSuites.clone();
  }

  @Override
  public String[] getEnabledProtocols()
  {
    return (String[]) this.enabledProtocols;
  }

  @Override
  public boolean getNeedClientAuth()
  {
    return this.needAuth;
  }

  @Override
  public String[] getSupportedCipherSuites()
  {
    return (String[]) this.supportedCipherSuites.clone();
  }

  @Override
  public String[] getSupportedProtocols()
  {
    return (String[]) this.supportedProtocols.clone();
  }

  @Override
  public boolean getUseClientMode()
  {
    return this.clientMode;
  }

  @Override
  public boolean getWantClientAuth()
  {
    return this.wantAuth;
  }

  @Override
  public void setEnableSessionCreation(final boolean enabled)
  {
    // Do nothing.
  }

  @Override
  public void setEnabledCipherSuites(final String[] suites)
  {
    // ToDo: implement
    // Do nothing.
  }

  @Override
  public void setEnabledProtocols(final String[] protocols)
  {
    if (protocols == null)
      {
        throw new IllegalArgumentException("protocols==null");
      }
    for (int i = 0; i < protocols.length; ++i)
      {
        String p = protocols[i];
        boolean valid = false;
        for (int j = 0; j < this.supportedProtocols.length; ++j)
          {
            String s = this.supportedProtocols[j];
            if (s.equals(p))
              {
                valid = true;
                break;
              }
          }
        if (! valid)
          {
            throw new IllegalArgumentException("Protocol " + p
                                               + " not supported");
          }
      }
    enabledProtocols = (String[]) protocols.clone();
  }

  @Override
  public void setNeedClientAuth(final boolean needAuth)
  {
    this.needAuth = needAuth;
    if (needAuth)
      {
        this.wantAuth = false;
      }
  }

  @Override
  public void setUseClientMode(final boolean clientMode)
  {
    this.clientMode = clientMode;
  }

  @Override
  public void setWantClientAuth(final boolean wantAuth)
  {
    this.wantAuth = wantAuth;
    if (wantAuth)
      {
        this.needAuth = false;
      }
  }

  @Override
  public Socket accept() throws IOException
  {
    WCESSLSocket socket = new WCESSLSocket(contextSpi, null, - 1);
    implAccept(socket.underlyingSocket);

    socket.setEnabledProtocols(enabledProtocols);
    socket.setEnabledCipherSuites(enabledCipherSuites);
    socket.setUseClientMode(clientMode);
    if (getNeedClientAuth())
      {
        socket.setNeedClientAuth(true);
      }
    else if (getWantClientAuth())
      {
        socket.setWantClientAuth(true);
      }
    return socket;
  }
}