#pragma once

#include <security.h>
#include <wincrypt.h>
#include <jni.h>

struct KeyStoreElement
{
  /**
   * GCAX
   */
  _TCHAR* alias;

  /**
   * CERT_CONTEXT
   */
  PCCERT_CONTEXT certContext;
};

/**
 * L[XgAǗ\
 */
class KeyStore
{
  HCERTSTORE hCertStore;

  int elementCount;
  KeyStoreElement* elements;

  int loadAllCertificates();
  void freeAllCertificates();

public:
  KeyStore(HCERTSTORE hCertStore);
  ~KeyStore();

  inline int getElementCount() const
  {
    return this->elementCount;
  }

  inline const _TCHAR* getAlias(int index) const
  {
    return this->elements[index].alias;
  }

  inline PCCERT_CONTEXT getCertContext(int index) const
  {
    return this->elements[index].certContext;
  }

  /**
   * w肳ꂽGCAXPCCERT_CONTEXTԂ
   */
  inline PCCERT_CONTEXT getCertContext(const _TCHAR* alias) const
  {
    if (alias)
    {
      for (int i = 0; i < getElementCount(); ++i)
      {
        if (_tcscmp(alias, this->elements[i].alias) == 0)
        {
          return this->elements[i].certContext;
        }
      }
    }
    return NULL;
  }
};


/**
 * GR[hꂽؖ`F[쐬
 */
jobjectArray
createEncodedCertificates(JNIEnv* env, PCCERT_CHAIN_CONTEXT chain);
