#include "stdafx.h"
#include "KeyStore.h"
#include "wcesecurity.h"
#include <jni.h>

static
_TCHAR* createAlias(PCCERT_CONTEXT pContext)
{
  // GCAX
  // CERT_NAME_FRIENDLY_DISPLAY_TYPE + " [SerialNumber:" + VAԍ + "]\0" Ƃ
  // VAԍǉ̂́AXgAɓO݂ؖꍇɂ
  // j[NɂKv邽
  DWORD name_count = ::CertGetNameString(pContext,
                                         CERT_NAME_FRIENDLY_DISPLAY_TYPE,
                                         0,
                                         NULL,
                                         NULL,
                                         0);
  int total_count = name_count // O̒  NULL
                    + (pContext->pCertInfo->SerialNumber.cbData * 2) // VAԍ (1oCgɂ2j
                    + 2        // E
                    + 13       // SerialNumber:
                    + 1;       // OƃVAԍƂ̊Ԃ̃Xy[X
  _TCHAR* alias = (_TCHAR*) ::malloc(sizeof(_TCHAR) * total_count);

  ::CertGetNameString(pContext,
                      CERT_NAME_FRIENDLY_DISPLAY_TYPE,
                      0,
                      NULL,
                      alias,
                      name_count);
  _tcscat(alias, _T(" [SerialNumber:"));

  // VAԍǉĂ
  // ilittle endianŊi[Ă̂ŁAʃoCgʃoCgɌďo͂j
  _TCHAR* work = alias + _tcslen(alias);
  for (int i = static_cast<int>(pContext->pCertInfo->SerialNumber.cbData) - 1; i >= 0 ; --i)
  {
    _stprintf(work, _T("%02x"), pContext->pCertInfo->SerialNumber.pbData[i]);
    work += 2;
  }
  _tcscat(work, _T("]"));
  assert(_tcslen(alias) == total_count - 1);

  return alias;
}

/**
 * RXgN^
 */
KeyStore::KeyStore(HCERTSTORE hCert) : hCertStore(hCert),
                             elementCount(0),
                             elements(NULL)
{
  loadAllCertificates();
}

/**
 * fXgN^
 */
KeyStore::~KeyStore()
{
  freeAllCertificates();
  BOOL closed = ::CertCloseStore(this->hCertStore, CERT_CLOSE_STORE_CHECK_FLAG);
  if (! closed)
  {
#ifdef DEBUG
    DWORD lastError = GetLastError();
    OutputDebugString(_T("Failed to close store"));
#endif
  }
}


/**
 * Sؖ[h
 */
int
KeyStore::loadAllCertificates()
{
  if (! this->hCertStore)
  {
    return 0;
  }

  int size = 16;
  const int size_inc = 16;
  this->elementCount = 0;
  this->elements = reinterpret_cast<KeyStoreElement*>(::malloc(sizeof(KeyStoreElement) * size));
  if (! this->elements)
  {
    return -1;
  }

  int count = 0;
  PCCERT_CONTEXT pContext = NULL;
  while ((pContext = ::CertEnumCertificatesInStore(this->hCertStore, pContext)) != NULL)
  {
    if (count >= size)
    {
      size += size_inc;
      KeyStoreElement* tmp = reinterpret_cast<KeyStoreElement*>(::realloc(this->elements, sizeof(KeyStoreElement) * size));
      if (! tmp)
      {
        // ŏI
        break;
      }
      this->elements = tmp;
    }

    // GCAX肷
    this->elements[count].alias = createAlias(pContext);

    // 쐬
    // (CertEnumCertificatesInStore()͑2ƂēnCERT_CONTEXT邽߁j
    this->elements[count].certContext = ::CertDuplicateCertificateContext(pContext);
    assert(this->elements[count].certContext);

    count++;
  }

  // 擾ؖ̐ݒ肵ă^[
  this->elementCount = count;
  return count;
}

/**
 * Sؖ
 */
void
KeyStore::freeAllCertificates()
{
  if (! this->hCertStore)
  {
    return;
  }
  for (int i = 0; i < this->elementCount; ++i)
  {
    assert(this->elements);
    ::free(this->elements[i].alias);
    ::CertFreeCertificateContext(this->elements[i].certContext);
  }
  ::free(this->elements);
  this->elementCount = 0;
  this->elements = NULL;
}

/**
 * w肳ꂽؖ`F[̓eɊÂAbyte[][] 쐬
 */
jobjectArray
createEncodedCertificates(JNIEnv* env, PCCERT_CHAIN_CONTEXT chain)
{
  // ŏ̃`F[݂̂
  PCERT_SIMPLE_CHAIN simple_chain = chain->rgpChain[0];
  const DWORD cElement = simple_chain->cElement;
      
  jobjectArray encodedCerts = env->NewObjectArray(static_cast<jsize>(cElement), env->FindClass("[B"), NULL);

  // GR[hꂽؖ擾āAbyte[][] Ɋi[Ă
  for (DWORD i = 0; i < cElement; ++i)
  {
    PCERT_CHAIN_ELEMENT elem = simple_chain->rgpElement[i];
    PCCERT_CONTEXT cert_context = elem->pCertContext;
    
    jbyteArray encoded = env->NewByteArray(static_cast<jsize>(cert_context->cbCertEncoded));
    if (encoded)
    {
      jbyte* p = static_cast<jbyte*>(env->GetPrimitiveArrayCritical(encoded, NULL));
      if (p)
      {
        memcpy(p, cert_context->pbCertEncoded, cert_context->cbCertEncoded);
      }
      env->ReleasePrimitiveArrayCritical(encoded, p, 0);

      env->SetObjectArrayElement(encodedCerts, static_cast<jsize>(i), encoded);
    }
  }
  return encodedCerts;
}
