/* java_thread.h
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of Mysaifu JVM

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.
*/

#ifndef JAVA_THREAD_INCLUDED
#define JAVA_THREAD_INCLUDED

#include "ClassFile.h"

/**
 * XbhJñp[^
 */
struct thread_start_parameter {
	jobject vmthread_reference;	// VMThreadIuWFNgւ̎Q
	jobject thread_reference;	// ThreadIuWFNgւ̎Q
	bool daemon;				// DaemonXbh̏ꍇtrue
};

/**
 * Xbh֘Aϐ
 */
void init_thread_settings(DWORD thread_stack_size);

/**
 * w肳ꂽ\bhVXbhŎs
 */
DWORD WINAPI thread_start(LPVOID pvarg);

/**
 * VlCeBuXbh쐬
 */
bool create_native_thread(LPTHREAD_START_ROUTINE thread_start, thread_start_parameter* param);

/**
 * JgXbhȊÕXbhׂăTXyh
 */
bool suspend_all_other_threads();

/**
 * JgXbhȊÕXbhׂčĊJ
 */
bool resume_all_other_threads();

HANDLE get_terminate_handle();

/**
 * w肳ꂽXbhIDɑΉ interrupt() pCxgIuWFNgԂB
 */
HANDLE get_interrupt_event(DWORD thread_id);

/**
 * w肳ꂽXbhIDɑΉ銄荞݃tOݒ肷
 */
void set_interrupted(DWORD thread_id, bool flag);

/**
 * w肳ꂽXbhIDɑΉ銄荞݃tOԂ
 */
bool is_interrupted(jobject vmThread);

/**
 * w肳ꂽXbhIDɑΉXbhɊ荞ށB
 * 荞݃tOtrueɐݒ肳B
 */
void interrupt(jobject vmThread);

/**
 * w肳ꂽVMThreadIuWFNg̃CX^XɑΉAlCeBuXbh̃XbhnhԂ
 */
HANDLE get_thread_handle(jobject vmthread);

/**
 * JgXbhɑΉ Thread ̎QƂԂ
 */
jobject current_Thread();

/**
 * w肳ꂽXbhIDɑΉjava.lang.ThreadIuWFNgԂ
 */
jobject get_thread_object_of(DWORD thread_id);

/**
 * JVMTI_THREAD_STATE_XXX tO Thread.State \ɕϊ
 */
const _TCHAR* get_thread_state_from_jvmti_bits(int jvmti_thread_state_bits);

/**
 * O[oϐɃANZXۂɎgpCRITICAL_SECTION
 */
extern CRITICAL_SECTION g_global_critical_section;

/**
 * O[oNeBJZNVɓۂɎgp}N
 */
#define LOCK_GLOBAL()     EnterCriticalSection(&g_global_critical_section)
#define UNLOCK_GLOBAL()   LeaveCriticalSection(&g_global_critical_section)

#endif