/* frame.h
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of Mysaifu JVM

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.
*/

#ifndef FRAME_H_INCLUDED
#define FRAME_H_INCLUDED

#include "types.h"
#include "ClassFile.h"
#include <jvmti.h>

/**
 * t[̖{́B
 * 1XbhɂP쐬B
 */
struct frame_body
{
	/**
	 * t[̗vfi32rbgPʁj
	 */
  unsigned int count;

	/**
	 * t[̃~bg
	 */
  unsigned int limit_count;

	/**
	 * t[̃f[^{
	 */
  __int32 *data;

	/**
	 * Qƒl̈
	 */
  __int32 *references;

	/**
	 * Jgt[
	 */
  frame *current_frame;

	/**
	 * OɎsinstanceofZq̍
	 */
  ClassFile *instanceof_lvalue;

	/**
	 * OɎsꂽinstanceofZq̉E
	 */
  const java_utf8 *instanceof_rvalue;

	/**
	 * OɎsꂽinstanceofZq̌
	 */
  int instanceof_result;

	/**
	 * JgXbh
	 */
  jobject current_thread;

	/**
	 * JNIEnv
	 */
  JNIEnv *env;

	/**
	 * [JQ
	 */
  frame *local_references_frame;

	/**
	 * OB
	 */
  jthrowable current_exception;

  /**
   * Xbh̃Xe[^X
   * JVMTIŒ`ꂽ萔 (JVMTI_THREAD_STATE_XXX)
   */
  int thread_state;
};


struct synchronized_info
{
  struct synchronized_info* next;
  jobject obj;
};

/**
 * t[\
 * \bhĂяoPʂō쐬
 */
struct frame
{
	/**
	 * X^bNt[̖{
	 */
  frame_body *body;

	/**
	 * PÕt[
	 */
  frame *previous_frame;

	/**
	 * JgNX
	 */
  ClassFile *current_class_file;

	/**
	 * Jg\bh
	 */
  method_info *current_method_info;

	/**
	 * JgvOEJE^
	 */
  u2 current_pc;

	/**
	 * [Jϐ̐擪AhX
	 */
  __int32 *local_variables;

	/**
	 * [Jϐ̎QƒltO
	 */
  __int32 *local_variables_references;

	/**
	 * IyhEX^bN̐擪AhX
	 */
  __int32 *operand_stack;

	/**
	 * IyhEX^bN̎QƒltO
	 */
  __int32 *operand_stack_references;

	/**
	 * IyhEX^bŇ݈ʒu
	 */
  unsigned int operand_stack_position;

	/**
	 * synchronized\bh̏ꍇlockIuWFNg
	 */
  jobject lock;

  /**
   * \bhŖI synchronized() ĂIuWFNg̏
   */
  synchronized_info* synchronized_objects;

};

/**
 * istore/fstore
 * iIɎj
 */
#define FAST_STORE(stack_base, pposition, local_base, index) \
{ \
  (*pposition)--; \
  local_base[(index)] = stack_base[*pposition]; \
}

/**
 * store
 */
#define STORE(stack, index) \
{ \
	const unsigned int stack_position = (stack)->operand_stack_position - 1; \
	(stack)->local_variables[(index)] = (stack)->operand_stack[stack_position]; \
	(stack)->operand_stack_position = stack_position; \
}

#define STORE2(stack, index) \
{ \
	const unsigned int stack_position = (stack)->operand_stack_position - 2; \
	*((__int64*) (&(stack)->local_variables[index])) \
			= *((__int64*) &(stack)->operand_stack[stack_position]); \
	(stack)->operand_stack_position = stack_position; \
}

/**
 * astore
 */
#define ASTORE_N(stack, index) \
{ \
	const unsigned int stack_position = (stack)->operand_stack_position - 1; \
	(stack)->local_variables_references[(index)] = \
	    (stack)->local_variables[(index)] = \
		    (stack)->operand_stack[stack_position]; \
	(stack)->operand_stack_position = stack_position; \
}

/**
 * iload,fload 
 * iIɎj
 */
#define FAST_LOAD(stack_base, pposition, local_base, index) \
{ \
  stack_base[*pposition] = local_base[(index)]; \
  (*pposition)++; \
}

 /**
 * load 
 */
#define LOAD(stack, index) \
{ \
	const unsigned int stack_position = (stack)->operand_stack_position; \
	(stack)->operand_stack[stack_position] = (stack)->local_variables[(index)]; \
	(stack)->operand_stack_position++; \
}

#define LOAD2(stack, index) \
{ \
	const unsigned int stack_position = (stack)->operand_stack_position; \
	*((__int64*) (&(stack)->operand_stack[stack_position])) \
			= *((__int64*) &(stack)->local_variables[index]); \
	(stack)->operand_stack_position += 2; \
}

/**
 * aload 
 */
#define ALOAD_N(stack, index) \
{ \
  const unsigned int stack_position = (stack)->operand_stack_position; \
  (stack)->operand_stack_references[stack_position] = (stack)->operand_stack[stack_position] = (stack)->local_variables[(index)]; \
  (stack)->operand_stack_position++; \
}

#define	POP_DISCARD(stack) \
{ \
  (stack)->operand_stack_position--; \
}

#define POP2_DISCARD(stack) \
{ \
  (stack)->operand_stack_position -= 2; \
}

#define FAST_POP_DISCARD_N(pposition, n) \
{ \
  *pposition -= n; \
}

#define POP_DISCARD_N(stack, n) \
{ \
  (stack)->operand_stack_position -= n; \
}

/**
 * PUSH_INT
 * (IɎ)
 */
#define	FAST_PUSH_INT(stack_base, pposition, value) \
{ \
  stack_base[*pposition] = (value); \
  (*pposition)++; \
}

#define	PUSH_INT(stack, value) \
{ \
    const unsigned int position = (stack)->operand_stack_position; \
    (stack)->operand_stack[position] = (value); \
	(stack)->operand_stack_position++; \
}

#define	PUSH_LONG(stack, value) \
{ \
	*((__int64*) &(stack)->operand_stack[(stack)->operand_stack_position]) = (value); \
	(stack)->operand_stack_position += 2; \
}

/**
 * PUSH_FLOAT
 * (IɎ)
 */
#define	FAST_PUSH_FLOAT(stack_base, pposition, value) \
{ \
    *((float*) &stack_base[*pposition]) = (value); \
	(*pposition)++; \
}

#define PUSH_FLOAT(stack, value) \
{ \
	*((float*) &(stack)->operand_stack[(stack)->operand_stack_position]) = (value); \
	(stack)->operand_stack_position++; \
}

#define PUSH_DOUBLE(stack, value) \
{ \
	*((double*) &(stack)->operand_stack[(stack)->operand_stack_position]) = (value); \
	(stack)->operand_stack_position += 2; \
}

#define PUSH_OBJECT(stack, value) \
{ \
	const unsigned int position = (stack)->operand_stack_position; \
	(stack)->operand_stack_references[position] = \
		(stack)->operand_stack[position] = (__int32) (value); \
    (stack)->operand_stack_position++; \
}

/**
 * POP_INT
 * (IɎj
 */
#define FAST_POP_INT(stack_base, pposition, value) \
{ \
	(*pposition)--; \
	value = stack_base[*pposition]; \
}

#define POP_INT(stack, value) \
{ \
	(stack)->operand_stack_position--; \
	value = (stack)->operand_stack[(stack)->operand_stack_position]; \
}

#define POP_LONG(stack, value) \
{ \
	(stack)->operand_stack_position -= 2; \
	value = *((__int64*) &(stack)->operand_stack[(stack)->operand_stack_position]); \
}

/**
 * POP_FLOAT
 * iIɎj
 */
#define FAST_POP_FLOAT(stack_base, pposition, value) \
{ \
	(*pposition)--; \
	value = *((float*) &stack_base[(*pposition)]); \
}

#define POP_FLOAT(stack, value) \
{ \
	(stack)->operand_stack_position--; \
	value = *((float*) &(stack)->operand_stack[(stack)->operand_stack_position]); \
}

#define POP_DOUBLE(stack, value) \
{ \
	(stack)->operand_stack_position -= 2; \
	value = *((double*) &(stack)->operand_stack[(stack)->operand_stack_position]); \
}

#define POP_OBJECT(stack, value) \
{ \
	(stack)->operand_stack_position--; \
	value = *((jobject*) &(stack)->operand_stack[(stack)->operand_stack_position]); \
}

/**
 * iinc
 */
#define	FAST_IINC_LOCAL(local_base, index, count) \
{ \
  local_base[(index)] += (count); \
}

#define IINC_LOCAL(stack, index, count) \
{ \
  (stack)->local_variables[(index)] += count; \
}

/**
 * IyhEX^bNɑ΂ "dup" ߂s
 */
#define DUP_STACK(stack) \
{ \
	const unsigned int position = (stack)->operand_stack_position; \
	/* references̃Rs[͕svȂiRs[̃tO邽߁j */ \
	(stack)->operand_stack_references[position] = \
	    (stack)->operand_stack_references[position - 1]; \
	(stack)->operand_stack[position] = \
		  (stack)->operand_stack[position - 1]; \
	(stack)->operand_stack_position++; \
}

/**
 * IyhX^bNɑ΂ ADD ߂s(JeSPj
 */
#define ADD_STACK(stack, type) \
{ \
  /* AhXvZo菭Ȃ */ \
  type * pdata = (type*) &stack->operand_stack[stack->operand_stack_position];  \
  *(pdata - 2) += *(pdata - 1);  \
  POP_DISCARD(stack);  \
}

#define FAST_ADD_STACK(stack_base, pposition, type) \
{ \
  *((type*) &stack_base[*pposition - 2]) += *(type*) &stack_base[*pposition - 1]; \
  FAST_POP_DISCARD_N(pposition, 1); \
}

/**
 * IyhX^bNɑ΂ ADD ߂s(JeSQj
 */
#define ADD2_STACK(stack, type) \
{ \
	/* AhXvZo菭Ȃ */ \
	type * pdata = (type*) &stack->operand_stack[stack->operand_stack_position]; \
	*(pdata - 2) += *(pdata - 1); \
	POP2_DISCARD(stack); \
}

/**
 * IyhX^bNɑ΂ SUB ߂s(JeSPj
 */
#define SUB_STACK(stack, type) \
{ \
	/* AhXvZo菭Ȃ */ \
	type * pdata = (type*) &stack->operand_stack[stack->operand_stack_position]; \
	*(pdata - 2) -= *(pdata - 1); \
	POP_DISCARD(stack); \
}

/**
 * IyhX^bNɑ΂ SUB ߂s(JeSQj
 */
#define SUB2_STACK(stack, type) \
{ \
	/* AhXvZo菭Ȃ */ \
	type * pdata = (type*) &stack->operand_stack[stack->operand_stack_position]; \
	*(pdata - 2) -= *(pdata - 1); \
	POP2_DISCARD(stack); \
}

/**
 * IyhX^bNɑ΂ MUL ߂s(JeSPj
 */
#define MUL_STACK(stack, type) \
{ \
	/* AhXvZo菭Ȃ */ \
	type * pdata = (type*) &stack->operand_stack[stack->operand_stack_position]; \
	*(pdata - 2) *= *(pdata - 1); \
	POP_DISCARD(stack); \
}

/**
 * IyhX^bNɑ΂ MUL ߂s(JeSQj
 */
#define MUL2_STACK(stack, type) \
{ \
	/* AhXvZo菭Ȃ */ \
	type * pdata = (type*) &stack->operand_stack[stack->operand_stack_position]; \
	*(pdata - 2) *= *(pdata - 1); \
	POP2_DISCARD(stack); \
}

/**
 * IyhX^bNɑ΂ iand ߂s
 */
#define IAND_STACK(stack) \
{ \
	jint* pvalue = &stack->operand_stack[stack->operand_stack_position - 1]; \
	*(pvalue - 1) &= *pvalue; \
	POP_DISCARD(stack); \
}

/**
 * IyhX^bNɑ΂ ior ߂s
 */
#define IOR_STACK(stack) \
{ \
	jint* pvalue = &stack->operand_stack[stack->operand_stack_position - 1]; \
	*(pvalue - 1) |= *pvalue; \
	POP_DISCARD(stack); \
}

/**
 * IyhX^bNɑ΂ ixor ߂s
 */
#define IXOR_STACK(stack) \
{ \
	jint* pvalue = &stack->operand_stack[stack->operand_stack_position - 1]; \
	*(pvalue - 1) ^= *pvalue; \
	POP_DISCARD(stack); \
}

/**
 * IyhX^bNɑ΂ iand ߂s
 */
#define LAND_STACK(stack) \
{ \
	jlong* pvalue = (jlong*) &stack->operand_stack[stack->operand_stack_position - 2]; \
	*(pvalue - 1) &= *pvalue; \
	POP2_DISCARD(stack); \
}

/**
 * IyhX^bNɑ΂ lor ߂s
 */
#define LOR_STACK(stack) \
{ \
	jlong* pvalue = (jlong*) &stack->operand_stack[stack->operand_stack_position - 2]; \
	*(pvalue - 1) |= *pvalue; \
	POP2_DISCARD(stack); \
}

/**
 * IyhX^bNɑ΂ lxor ߂s
 */
#define LXOR_STACK(stack) \
{ \
	jlong* pvalue = (jlong*) &stack->operand_stack[stack->operand_stack_position - 2]; \
	*(pvalue - 1) ^= *pvalue; \
	POP2_DISCARD(stack); \
}

/**
 * IyhX^bNɑ΂ ishl ߂s
 */
#define ISHL_STACK(stack) \
{ \
	jint* pvalue = &stack->operand_stack[stack->operand_stack_position - 1]; \
	/* Vtg񐔂0x1fŃ}XN */ \
	*(pvalue - 1) <<= (*pvalue & 0x1f); \
	POP_DISCARD(stack); \
}

/**
 * IyhX^bNɑ΂ ishr ߂s
 */
#define ISHR_STACK(stack) \
{ \
	jint* pvalue = &stack->operand_stack[stack->operand_stack_position - 1]; \
	/* Vtg񐔂0x1fŃ}XN */ \
	*(pvalue - 1) >>= (*pvalue & 0x1f); \
	POP_DISCARD(stack); \
}

/**
 * IyhX^bNɑ΂ ishr ߂s
 */
#define IUSHR_STACK(stack) \
{ \
	jint* pvalue = &stack->operand_stack[stack->operand_stack_position - 1]; \
	/* Vtg񐔂0x1fŃ}XN */ \
	*((unsigned __int32*) pvalue - 1) >>= (*pvalue & 0x1f); \
	POP_DISCARD(stack); \
}

/**
 * IyhX^bNɑ΂ f2i ߂s
 */
#define I2F_STACK(stack) \
{ \
    jint* pdata = (jint*) &stack->operand_stack[stack->operand_stack_position - 1]; \
	*((jfloat*) pdata) = (jfloat) *pdata; \
}

/**
 * IyhX^bNɑ΂ l2i ߂s
 */
#define L2I_STACK(stack) \
{ \
    jlong* pdata = (jlong*) &stack->operand_stack[stack->operand_stack_position - 2]; \
	*((jint*) pdata) = (jint) *pdata; \
	POP_DISCARD(stack); \
}

/**
 * IyhX^bNɑ΂ l2f ߂s
 */
#define L2F_STACK(stack) \
{ \
    jlong* pdata = (jlong*) &stack->operand_stack[stack->operand_stack_position - 2]; \
	*((jfloat*) pdata) = (jfloat) *pdata; \
	POP_DISCARD(stack); \
}

/**
 * IyhX^bNɑ΂ l2d ߂s
 */
#define L2D_STACK(stack) \
{ \
    jlong* pdata = (jlong*) &stack->operand_stack[stack->operand_stack_position - 2]; \
	*((jdouble*) pdata) = (jdouble) *pdata; \
}

/**
 * IyhEX^bN̔Cӂ̈ʒũf[^擾
 *
 * @param	stack	X^bNEt[B
 * @param	offset	X^bNgbvOƂ΃AhXw肷
 * @param	pvalue	擾f[^i[AhXB
 */
#define PEEK_STACK_DATA(stack, offset, type, value) \
{ \
  value = *(type*) &(stack)->operand_stack[(stack)->operand_stack_position - offset - 1]; \
}

/**
 * IyhEX^bN̔Cӂ̈ʒũf[^擾iŁj
 *
 * @param	stack_base
 * @param	pposition	X^bN|C^
 * @param	offset		X^bNgbvOƂ΃AhXw肷
 * @param	type		ǂݎf[^̃^Cv
 * @param	pvalue		擾f[^i[AhXB
 */
#define FAST_PEEK_STACK_DATA(stack_base, pposition, offset, type, value) \
{ \
  value = *(type*) &stack_base[*pposition - offset - 1]; \
}

/**
 * frame֘A̕ϐ
 */
void init_frame_settings (unsigned int java_stack_size);

/**
 * Ԑ擪̃t[ZbgAbv
 * Xbh̍ŏ̃\bhĂяoOɁÅ֐gpčŏ̃X^bNt[
 * 쐬
 */
frame *alloc_root_frame (ClassFile * current_class_file);
frame *alloc_root_frame (ClassFile * current_class_file,
			 unsigned int max_count);

/**
 * Ԑ擪ij̃t[J
 * Xbh̏IÅ֐ĂяoăJ
 */
void free_root_frame (frame * root_frame);

/**
 * JVMɑ݂郋[gt[̐Ԃ
 *
 * @return	[gt[
 */
unsigned int get_root_frame_count ();

/**
 * w肳ꂽCfbNXɑΉ郋[gX^bNt[Ԃ
 *
 * @param	index	CfbNX
 * @return	[gX^bNt[ւ̃|C^
 */
frame *get_root_frame (unsigned int index);

/**
 * w肳ꂽ[gt[̏ԂB
 *
 * @param	root_frame	[gt[
 * @param	pdata		t[f[^ւ̃|C^ԂB
 * @param	prefflags	QƒltÕ|C^ԂB
 * @param	pcount		t[̗Lf[^ԂB
 * @param	pcurrent_exception	Jg̗OԂB
 * @return	Ƀf[^擾łꍇtrue
 */
bool get_root_frame_info (frame * root_frame, __int32 ** pdata,
			  __int32 ** preferences, unsigned int *pcount,
			  jobject * pcurrent_exception);

/**
 * \bhĂяoOɃt[B
 * \bhĂяosOɂ̊֐ĂяoAt[쐬B
 */
frame *enter_method (frame * caller_frame, ClassFile * target_class_file,
		     method_info * target_method_info);

/**
 * \bh痣B
 * \bhIۂɂ̊֐ĂяoAt[j
 */
frame *leave_method (frame * current_frame);

/**
 * "dup_x1"߂s
 */
void dup_x1 (frame * stack);

/**
 * "dup_x2"߂s
 */
void dup_x2 (frame * stack);


/**
 * "dup2"߂s
 */
void dup2 (frame * stack);

/**
 * "dup2_x1"߂s
 */
void dup2_x1 (frame * stack);

/**
 * "dup2_x2"߂s
 */
void dup2_x2 (frame * stack);

/**
 * "swap"߂s
 */
void swap (frame * stack);

/**
 * IyhEX^bN̔Cӂ̈ʒũf[^擾
 *
 * @param	stack	t[B
 * @param	offset	X^bNgbvOƂ΃AhXw肷
 * @param	pvalue	擾f[^i[AhXB
 */
inline void
get_stack_data (frame * stack, unsigned int offset, __int32 * pvalue)
{
  unsigned int pos = stack->operand_stack_position - 1 - offset;
  *pvalue = stack->operand_stack[pos];
}

/**
 * w肳ꂽCfbNXɑΉ郍[Jϐ̒lԂ
 */
inline __int32
get_int (frame * frame, int index)
{
  return (int) frame->local_variables[index];
}

/**
 * V[JQƂ쐬it[Ɋi[AKx[WRNgȂ悤ɂj
 */
jobject new_local_reference (frame * current_frame, jobject ref);

/**
 * w肳ꂽ[JQƂ폜iKx[WRNgΏۂƂj
 */
void delete_local_reference (frame * current_frame, jobject ref);

/**
 * VO[oQƂ쐬iKx[WRNgȂ悤ɂj
 */
jobject new_global_reference (jobject ref);

/**
 * w肳ꂽO[oQƂ폜iKx[WRNgΏۂƂj
 */
void delete_global_reference (jobject ref);

/**
 * w肳ꂽt[ɑΉXbh̃Jgt[ԂB
 */
frame *get_current_frame (frame * frm);

/**
 * instanceof̌ʂLbVɓ
 */
void update_instanceof_cache (frame * frm, ClassFile * lvalue,
			      const java_utf8 * rvalue, int result);

/**
 * instanceof̌ʂLbV擾
 * Aꍇɂ̓LbVɃqbg݂ȂƂB
 */
int get_instanceof_cache (frame * frm, ClassFile * lvalue,
			  const java_utf8 * rvalue);

/**
 * w肳ꂽ frame ̃JgXbhw肷
 * PframeɂÅ֐1񂵂ĂяoȂBi2ڈȍ~̌Ăяo͖j
 */
void set_current_thread (frame * frm, jobject thread);

/**
 * w肳ꂽ frame ̃JgXbhԂ
 */
jobject get_current_thread (frame * frm);

/**
 * w肳ꂽThreadIuWFNgɑΉframeIuWFNgԂ
 * Ήframe݂ȂꍇNULLԂB
 */
frame *get_current_frame_of (jobject thread);

bool ensure_stack_capacity (frame * frm);

/**
 * JNIEnv* 擾
 */
JNIEnv *get_JNIEnv (frame * frm);

/**
 * JNIEnv* ݒ肷
 */
void set_JNIEnv (frame * frm, JNIEnv * env);

/**
 * [JQƗpframepush
 */
int push_local_frame (frame * current_frame, frame * new_frame, int capacity);

/**
 * [JQƗp frame  pop 
 */
jobject pop_local_frame (frame * current_frame, jobject ref);

/**
 * synchronized() ubN̊JnL^
 */
bool enter_synchronized_block(frame* frm, jobject obj);

/**
 * synchronized() ubN̏IL^
 */
bool leave_synchronized_block(frame* frm, jobject obj);

/**
 * synchronized() Ăobject擾
 * ̃\bh́A frm ̏LXbhĂяoł邩A
 * ܂ frm ̏LXbhTXyhĂȂ΂ȂȂ
 */
unsigned int get_synchronized_object_count(frame* frm);

/**
 * synchronized() Ăobject擾
 * ̃\bh́A frm ̏LXbhĂяoł邩A
 * ܂ frm ̏LXbhTXyhĂȂ΂ȂȂ
 * @param buff  ʂi[obt@
 */
unsigned int get_synchronized_objects(frame* frm, jobject* buff, unsigned int buffcount);


/**
 * Return thread state flags
 */
inline int get_thread_state_bits(frame_body* fb)
{
  return fb->thread_state;
}

/**
 * Update thread state flags.
 */
inline void update_thread_state_bits(frame_body* fb, int flags_to_set, int flags_to_clear)
{
  int flags = get_thread_state_bits(fb);
  flags |= flags_to_set;
  flags &= ~flags_to_clear;
  fb->thread_state = flags;
}

#endif
