/* WCEFileDialogPeer.java
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package gnu.java.awt.peer.wce;

import java.awt.Container;
import java.awt.FileDialog;
import java.awt.peer.ComponentPeer;
import java.awt.peer.FileDialogPeer;
import java.io.File;
import java.io.FilenameFilter;


public class WCEFileDialogPeer extends WCEDialogPeer implements FileDialogPeer {
	private String file;
	private String directory;
	
	public WCEFileDialogPeer(FileDialog dialog) {
		super(dialog);
	}
	
	protected native int createNative(int hParentWnd,
									  int x,
									  int y,
									  int width,
									  int height);
	
	/**
	 * Show or hide this dialog.
	 */
	public void setVisible(boolean visible) {
		if (visible) {
			final FileDialog dialog = (FileDialog) getComponent();
			Container c = dialog.getParent();
			ComponentPeer peer = c.getPeer();
			final int ownerWindowHandle;
			if (peer instanceof WCEComponentPeer) {
				ownerWindowHandle = ((WCEComponentPeer) peer).getWindowHandle();
			} else {
				ownerWindowHandle = 0;
			}
			
			// ʃXbh쐬AlCeBũ_CAO\
			new Thread(new Runnable() {
				public void run() {
					String filename
						= nativeGetFileName(ownerWindowHandle,
											dialog.getMode(),
											dialog.getTitle(),
											directory,
											dialog.getFile());
					if (filename == null) {
						dialog.setDirectory(null);
						dialog.setFile(null);
					} else {
						// t@CƃfBNgƂɕ
						int lastsep = filename.lastIndexOf(File.separator);
						File file = new File(filename);
						dialog.setDirectory(filename.substring(0, lastsep));
						dialog.setFile(file.getName());
					}
					
					// _CAO̓Ԃ\ɕύX
					dialog.setVisible(false);
				}
			}).start();
		}
	}
	
	public void setFile(String file) {
		this.file = file;
	}

	public void setDirectory(String dir) {
		this.directory = directory;
	}

	public void setFilenameFilter (FilenameFilter ff) {
		// T|[gĂȂ
	}
	
	/**
	 * lCeBu_CAO\
	 * [U_CAO܂ŁÃ\bh̓ubN
	 */
	private native String nativeGetFileName(int ownerWindowHandle,
											int mode,
											String title,
											String directory,
											String file);


}
