/* WCESSLSocketFactory.java -- 
   Copyright (C) 2009 Mysaifu.com

This file is a part of Mysaifu JVM.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with Mysaifu JVM; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301
USA

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


package com.mysaifu.jvm.java.security.provider;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;

import javax.net.ssl.SSLSocketFactory;

public class WCESSLSocketFactory
    extends SSLSocketFactory
{
  private final WCESSLContextSpi contextSpi;

  public WCESSLSocketFactory(WCESSLContextSpi spi)
  {
    this.contextSpi = spi;
  }

  @Override
  public Socket createSocket(Socket socket, String host, int port,
                             boolean autoClose) throws IOException
  {
    if (socket == null)
      {
        socket = new Socket();
      }
    return new WCESSLSocket(contextSpi, host, port, socket, autoClose);
  }

  @Override
  public String[] getDefaultCipherSuites()
  {
    throw new UnsupportedOperationException("Not implemented");
  }

  @Override
  public String[] getSupportedCipherSuites()
  {
    throw new UnsupportedOperationException("Not implemented");
  }

  @Override
  public Socket createSocket(InetAddress host, int port) throws IOException
  {
    return createSocket(host, port, null, 0);
  }

  @Override
  public Socket createSocket(InetAddress host, int port, InetAddress localHost,
                             int localPort) throws IOException
  {
    WCESSLSocket socket = new WCESSLSocket(contextSpi,
                                           host.getCanonicalHostName(), port);
    socket.bind(new InetSocketAddress(localHost, localPort));
    socket.connect(new InetSocketAddress(host, port));
    return socket;
  }

  @Override
  public Socket createSocket(String host, int port) throws IOException,
      UnknownHostException
  {
    return createSocket(host, port, null, 0);
  }

  @Override
  public Socket createSocket(String host, int port, InetAddress localHost,
                             int localPort) throws IOException,
      UnknownHostException
  {
    WCESSLSocket socket = new WCESSLSocket(contextSpi, host, port);
    InetSocketAddress endpoint = new InetSocketAddress(host, port);
    socket.bind(new InetSocketAddress(localHost, localPort));
    socket.connect(endpoint);
    return socket;
  }

  @Override
  public Socket createSocket() throws IOException
  {
    return new WCESSLSocket(contextSpi, null, - 1, new Socket(), true);
  }
}
