#include <windows.h>
#include <jni.h>
#include <assert.h>
#include "gnu_javax_sound_sampled_wce_WCECallbackWindowThread.h"
#include "gnu_javax_sound_sampled_wce_WCESourceDataLine.h"
#include "gnu_javax_sound_sampled_wce_WCETargetDataLine.h"
#include "wcesound.h"

#define AudioSystem_NOT_SPECIFIED -1L

/**
 * R[obNEChẼEChENX
 */
#define	CALLBACK_WINDOW_CLASS_NAME	_T("WCE sound callback")

/**
 * ɃI[vłHWAVEIN̍ő吔
 */
#define MAX_WAVEIN_COUNT	16

/**
 * ɃI[vłHWAVEOUT̍ő吔
 */
#define MAX_WAVEOUT_COUNT	16

/**
 * o̓obt@
 */
#define WAVEHDR_COUNT	2

// ̓obt@͓ǂݍ݉\
#define READABLE_FLAG	(1 << 31)

// ̓obt@̐擪tO
#define READ_HEAD_FLAG	(1 << 30)

/**
 * obt@̎cf[^TCY擾邽߂̃}XN
 * dwUser & READ_REMAINS_MASK Ƃ邱ƂŁAlpData̎cf[^ʂ
 * 擾邱ƂłB
 * ȉ̎ lpData ̃f[^JnItZbg擾łB
 * hdr->dwBytesRecorded - (hdr->dwUser & READ_REMAINS_MASK)
 */
#define READ_REMAINS_MASK 0x1FFFFFFF

/**
 * ǂݍ݃obt@̍őTCY
 * READ_OFFSET_MASKɎ܂lɂȂ΂ȂȂ
 */
#define READ_MAX_BUFFER_SIZE (READ_REMAINS_MASK - 1)

// READ_REMAINS
#define SET_READ_REMAINS(dwUser, remains) \
{ \
	assert((remains) < READ_MAX_BUFFER_SIZE); \
	(dwUser) &= ~READ_REMAINS_MASK; \
	(dwUser) |= ((remains) & READ_REMAINS_MASK); \
}

// GET_REMAINS
#define GET_READ_REMAINS(dwUser) ((dwUser) & READ_REMAINS_MASK)

// o̓obt@͏݉\
#define WRITABLE_FLAG	1

/**
 * o͏p\
 */
typedef struct
{
  struct
  {
    /**
     * ̍\͎̂gp
     */
    int in_use : 1;

    /**
     * Zbg
     */
    int reset : 1;
  
    /**
     * ~
     */
    int stopped : 1;


    /**
     * N[Y
      */
    int closing : 1;
  };

  /**
   * NeBJZNV
   * ̍\̃o̓ǂݏɎgpB
   */
  CRITICAL_SECTION lock;

  /**
   * WAVEHDRp\ɂȂ_
   * VOiԂɂȂCxg
   */
  HANDLE hHeaderEvent;

  /**
   * őobt@TCY
   */
  int max_buffer_size;

  /**
   * WAVEFORMATEX
   */
  WAVEFORMATEX	waveformat;

  union
  {
    /**
     * WAVEo̓foCXnh
     */ 
    HWAVEOUT hWaveOut;

    /**
     * WAVE̓foCXnh
     */
    HWAVEIN hWaveIn;
  };
	
  /**
   * WAVEHDR\
   */
  WAVEHDR headers[WAVEHDR_COUNT];

  /**
   * WCESourceDataLine/WCETargetDataLinẽCX^X
   */
  jobject instance;

} wave_data;

typedef wave_data	wavein_data;
typedef wave_data	waveout_data;

/**
 * WAVE̓foCX
 */
static wavein_data g_wavein_data_array[MAX_WAVEIN_COUNT];

/**
 * WAVEo
 */
static waveout_data g_waveout_data_array[MAX_WAVEOUT_COUNT];

// R[obNEChEnh
HWND g_hwndCallback;

// O[obN
static CRITICAL_SECTION g_lock;

// WCEEventQueue
static jobject g_eventQueue;

// WCEEventQueue.postEvent()
static jmethodID g_postEvent_id;

// LineEvent.Type
static jobject g_LineEvent_Type_OPEN;
static jobject g_LineEvent_Type_CLOSE;
static jobject g_LineEvent_Type_START;
static jobject g_LineEvent_Type_STOP;

LRESULT CALLBACK CallbackWndProc(HWND, UINT, WPARAM, LPARAM); 

static BOOL prepare_references(JNIEnv* env, jobject instance, jobject eventQueue);
static void unprepare_references(JNIEnv* env, jobject instance, jobject eventQueue);
static BOOL create_callback_window(JNIEnv* env);
static wavein_data* get_wavein_data(HWAVEIN hWaveIn);
static waveout_data* get_waveout_data(HWAVEOUT hWaveOut);
static void close_wavein_data(waveout_data* data);
static void close_waveout_data(waveout_data* data);
static void post_LineEvent(JNIEnv* env, jobject line, jobject eventType, jlong position);
static BOOL is_wavein_active(wavein_data* data);
static BOOL is_waveout_active(waveout_data* data);
static int lock_readable_header(wavein_data* data);
static void unlock_readable_header(wavein_data* data, int index, DWORD remains);
static int lock_writable_header(waveout_data* data);
static int get_writable_header_count(waveout_data* data);

static void init_waveformat(LPWAVEFORMATEX pwfe,
							int sampleRate,
							int sampleSizeInBits,
							int channels,
							int frameSize,
							int frameRate);
static int adjust_max_buffer_size(int bufferSize, WAVEFORMATEX* wfe);
static BOOL alloc_header_data(int buffer_size, WAVEHDR* headers);
static void free_header_data(WAVEHDR* headers);

/**
 * DLLMain
 */
BOOL APIENTRY DllMain(HANDLE hinstDLL,  // DLL W[̃nh
                    DWORD fdwReason,     // ֐ĂяoR
                    LPVOID lpvReserved   // \ς
					)
{
  switch (fdwReason)
  {
  case DLL_PROCESS_ATTACH:
    {
      // Xbh̃A^b`^f^b`ɂ͋ȂƂ`
      DisableThreadLibraryCalls((HMODULE) hinstDLL);
      // NeBJZNV
      InitializeCriticalSection(&g_lock);

    }
    return TRUE;

  case DLL_PROCESS_DETACH:
    {
      int i;
      // NeBJZNV폜
      DeleteCriticalSection(&g_lock);
      // gp̃foCXnhׂăN[Y(svHj
      for (i = 0; i < MAX_WAVEIN_COUNT; ++i)
      {
        wavein_data* data = &g_wavein_data_array[i];
	if (data->in_use)
        {
	  int j;
	  waveInReset(data->hWaveIn);
	  for (j = 0; j < WAVEHDR_COUNT; ++j)
          {
	    waveInUnprepareHeader(data->hWaveIn, &data->headers[j], sizeof(WAVEHDR));
	  }
	  waveInClose(data->hWaveIn);
	}
      }
      for (i = 0; i < MAX_WAVEOUT_COUNT; ++i)
      {
        waveout_data* data = &g_waveout_data_array[i];
	if (data->in_use)
        {
          int j;
          waveOutReset(data->hWaveOut);
          for (j = 0; j < WAVEHDR_COUNT; ++j)
          {
            waveOutUnprepareHeader(data->hWaveOut, &data->headers[j], sizeof(WAVEHDR));
          }
          waveOutClose(data->hWaveOut);
        }
      }
    }
    return TRUE;
  }
  return FALSE;
}

/**
 * JavaIuWFNg̎QƂ
 */
static BOOL prepare_references(JNIEnv* env, jobject instance, jobject eventQueue)
{
  jfieldID open_id, close_id, start_id, stop_id;

  jclass clazz = env->FindClass("javax/sound/sampled/LineEvent$Type");
  if (! clazz)
  {
    throw_RuntimeException(env, "Failed to get LineEvent.Type");
    return FALSE;
  }
  // \bhID擾Ă
  g_postEvent_id = env->GetMethodID(env->GetObjectClass(eventQueue),
    				 "postEvent",
				 "(Ljavax/sound/sampled/Line;Ljavax/sound/sampled/LineEvent$Type;J)V");
  if (! g_postEvent_id)
  {
    throw_RuntimeException(env, "Failed to get methodID");
    return FALSE;
  }
	
  // LineEvent.TypestaticϐێĂ
  open_id = env->GetStaticFieldID(clazz, "OPEN", "Ljavax/sound/sampled/LineEvent$Type;");
  close_id = env->GetStaticFieldID(clazz, "CLOSE", "Ljavax/sound/sampled/LineEvent$Type;");
  start_id = env->GetStaticFieldID(clazz, "START", "Ljavax/sound/sampled/LineEvent$Type;");
  stop_id = env->GetStaticFieldID(clazz, "STOP", "Ljavax/sound/sampled/LineEvent$Type;");
  g_LineEvent_Type_OPEN = env->GetStaticObjectField(clazz, open_id);
  g_LineEvent_Type_CLOSE = env->GetStaticObjectField(clazz, close_id);
  g_LineEvent_Type_START = env->GetStaticObjectField(clazz, start_id);
  g_LineEvent_Type_STOP = env->GetStaticObjectField(clazz, stop_id);
	
  if (env->ExceptionOccurred())
  {
    return FALSE;
  }

  // O[oQƂƂēo^Ă
  g_eventQueue = env->NewGlobalRef(eventQueue);	
  g_LineEvent_Type_OPEN = env->NewGlobalRef(g_LineEvent_Type_OPEN);
  g_LineEvent_Type_CLOSE = env->NewGlobalRef(g_LineEvent_Type_CLOSE);
  g_LineEvent_Type_START = env->NewGlobalRef(g_LineEvent_Type_START);
  g_LineEvent_Type_STOP = env->NewGlobalRef(g_LineEvent_Type_STOP);

  return TRUE;
}

/**
 * JavaIuWFNg̎QƂ
 */
static void unprepare_references(JNIEnv* env, jobject instance, jobject eventQueue)
{
  // O[oQƂ
  env->DeleteGlobalRef(g_eventQueue);
  env->DeleteGlobalRef(g_LineEvent_Type_OPEN);
  env->DeleteGlobalRef(g_LineEvent_Type_CLOSE);
  env->DeleteGlobalRef(g_LineEvent_Type_START);
  env->DeleteGlobalRef(g_LineEvent_Type_STOP);
}

/**
 * R[obNEChE쐬
 */
static BOOL create_callback_window(JNIEnv* env)
{
  HINSTANCE hInst = GetModuleHandle(NULL);
  WNDCLASS wndclass = {0};

  // R[obNEChE쐬
  wndclass.lpfnWndProc = CallbackWndProc;
  wndclass.hInstance = hInst;
  wndclass.lpszClassName = CALLBACK_WINDOW_CLASS_NAME;

  if (! RegisterClass(&wndclass))
  {
    throw_RuntimeException(env, "RegisterClass() failed");
    return FALSE;
  }

  g_hwndCallback = CreateWindow(CALLBACK_WINDOW_CLASS_NAME,
				NULL,
				WS_DISABLED,
				0,
				0,
				0,
				0,
				NULL,
				NULL,
				hInst,
				NULL);
  if (! g_hwndCallback)
  {
    throw_RuntimeException(env, "CreateWindow() failed");
    return FALSE;
  }

  // JNIEnv o^Ă
  SetWindowLong(g_hwndCallback, GWL_USERDATA, (LONG) env);

  return TRUE;
}

/*
 * Class:     gnu_javax_sound_sampled_wce_WCECallbackWindowThread
 * Method:    messageLoop
 * Signature: (Lgnu/javax/sound/sampled/wce/WCEEventQueue;)V
 */
JNIEXPORT void JNICALL Java_gnu_javax_sound_sampled_wce_WCECallbackWindowThread_messageLoop
(JNIEnv *env, jobject instance, jobject eventQueue)
{
  // IuWFNg֘Ȁs
  if (! prepare_references(env, instance, eventQueue))
  {
    return;
  }
	
  // R[obNEChE쐬
  if (! create_callback_window(env))
  {
    return;
  }


  // IƂʒm
  {
    jmethodID mid = env->GetMethodID(env->GetObjectClass(instance),
      				"nativeWindowInitialized",
				"()V");
    if (! mid)
    {
      throw_RuntimeException(env, "Failed to get methodID");
      return;
    }
    env->CallVoidMethod(instance, mid);
  }

  // bZ[W[vJn
  {
    MSG msg;
    while (GetMessage(&msg, g_hwndCallback, 0, 0) > 0)
    {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
    }
  }

  // QƂ
  unprepare_references(env, instance, eventQueue);
}

/**
 * R[obNEChEvV[W
 */
LRESULT CALLBACK CallbackWndProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
  switch (uMsg)
  {
  case MM_WIM_OPEN:
    // ̓foCXI[vꂽ
    {
      // JNIEnv擾Ă
      JNIEnv* env = (JNIEnv*) GetWindowLong(hwnd, GWL_USERDATA);
      HWAVEIN hWaveIn = (HWAVEIN) wParam;
      wavein_data* data = get_wavein_data(hWaveIn);
      if (data)
      {
	// bZ[Wʒm
	post_LineEvent(env,
        	 data->instance,
		 g_LineEvent_Type_OPEN,
		 AudioSystem_NOT_SPECIFIED);
      }
    }
    break;

  case MM_WIM_CLOSE:
    // ̓foCXN[Yꂽ
    {
      // JNIEnv擾Ă
      JNIEnv* env = (JNIEnv*) GetWindowLong(hwnd, GWL_USERDATA);
      HWAVEIN hWaveIn = (HWAVEIN) wParam;
      waveout_data* data = get_wavein_data(hWaveIn);
      if (data)
      {
        // CLOSEbZ[Wʒm
	post_LineEvent(env,
          	   data->instance,
		   g_LineEvent_Type_CLOSE,
		   AudioSystem_NOT_SPECIFIED);
	// wavein_data
	close_wavein_data(data);
      }
    }
    break;

  case MM_WIM_DATA:
    // ̓obt@tɂȂ
    {
      // JNIEnv擾Ă
      JNIEnv* env = (JNIEnv*) GetWindowLong(hwnd, GWL_USERDATA);
      HWAVEIN hWaveIn = (HWAVEIN) wParam;
      wavein_data* data = get_wavein_data(hWaveIn);
      if (data)
      {
        int i;
        // NeBJZNVɓ
        EnterCriticalSection(&data->lock);
        if (data->reset)
        {
          // Zbgꂽꍇ
          data->reset = FALSE;
          for (i = 0; i < WAVEHDR_COUNT; ++i)
          {
            WAVEHDR* hdr = (WAVEHDR*) lParam;
            if (data->closing)
            {
              // N[Y
              // ǂݎ\tO𗧂Ăiǂݏo\oCg͂Oj
              SET_READ_REMAINS(hdr->dwUser, 0);
              hdr->dwUser |= READABLE_FLAG;
            }
            else
            {
              MMRESULT mmresult;
              // ǂݍ݉\tONA
              hdr->dwUser &= ~READABLE_FLAG;
              // ēxL[ɓ
              mmresult = waveInAddBuffer(data->hWaveIn,
                hdr,
                sizeof(WAVEHDR));
              if (mmresult != MMSYSERR_NOERROR)
              {
                throw_MMRESULT_Exception(env, mmresult);
              }
            }
          }
        }
        else
        {
          // obt@tɂȂꍇAȉ̏s
          // o obt@́ucoCgvdwBytesRecordedɐݒ肷
          // o uǂݎ\vtO𗧂Ă
          WAVEHDR* hdr = (WAVEHDR*) lParam;
          SET_READ_REMAINS(hdr->dwUser, hdr->dwBytesRecorded);
          // ǂݎ\tO𗧂Ă
          hdr->dwUser |= READABLE_FLAG;
        }
        // Cxgʒm
        if (! SetEvent(data->hHeaderEvent))
        {
          throw_RuntimeException(env, "SetEvent() failed");
        }
        // ANeBuǂ𒲂ׂ
        if (! is_wavein_active(data))
        {
          // ANeBuԂłȂȂꍇ́A
          // STOPCxgʒm
          post_LineEvent(env,
            data->instance,
            g_LineEvent_Type_STOP,
            AudioSystem_NOT_SPECIFIED);
        }
        // NeBJZNV甲
        LeaveCriticalSection(&data->lock);
      }
    }
    break;
    
  case MM_WOM_OPEN:
    {
      // JNIEnv擾Ă
      JNIEnv* env = (JNIEnv*) GetWindowLong(hwnd, GWL_USERDATA);
      HWAVEOUT hWaveOut = (HWAVEOUT) wParam;
      waveout_data* data = get_waveout_data(hWaveOut);
      if (data) {
        // bZ[Wʒm
        post_LineEvent(env,
          data->instance,
          g_LineEvent_Type_OPEN,
          AudioSystem_NOT_SPECIFIED);
      }
    }
    break;
  case MM_WOM_CLOSE:
    {
      // JNIEnv擾Ă
      JNIEnv* env = (JNIEnv*) GetWindowLong(hwnd, GWL_USERDATA);
      HWAVEOUT hWaveOut = (HWAVEOUT) wParam;
      waveout_data* data = get_waveout_data(hWaveOut);
      if (data) {
        // bZ[Wʒm
        post_LineEvent(env,
          data->instance,
          g_LineEvent_Type_CLOSE,
          AudioSystem_NOT_SPECIFIED);
        // waveout_data
        close_waveout_data(data);
      }
    }
    break;
  case MM_WOM_DONE:
    {
      // JNIEnv擾Ă
      JNIEnv* env = (JNIEnv*) GetWindowLong(hwnd, GWL_USERDATA);
      HWAVEOUT hWaveOut = (HWAVEOUT) wParam;
      waveout_data* data = get_waveout_data(hWaveOut);
      if (data) {
        int i;
        WAVEHDR* whdr = (WAVEHDR*) lParam;
        // NeBJZNVɓ
        EnterCriticalSection(&data->lock);
        if (data->reset) {
          // Zbgꂽꍇ
          data->reset = FALSE;
          // ׂẴwb_̏ԂXV
          for (i = 0; i < WAVEHDR_COUNT; ++i) {
            if (! (whdr->dwUser & WRITABLE_FLAG)) {
              // ݉\tO𗧂Ă
              whdr->dwUser |= WRITABLE_FLAG;
            }
          }
        } else {
          // obt@̍ĐɊꍇ
          // ݉\rbg𗧂Ă
          whdr->dwUser |= WRITABLE_FLAG;
        }
	// Cxgʒm
        if (! SetEvent(data->hHeaderEvent)) {
          throw_RuntimeException(env, "SetEvent() failed");
        }
        // ANeBuǂ𒲂ׂ
        if (! is_waveout_active(data)) {
          // ANeBuԂłȂȂꍇ́A
          // STOPCxgʒm
          post_LineEvent(env,
            data->instance,
            g_LineEvent_Type_STOP,
            AudioSystem_NOT_SPECIFIED);
        }
        // NeBJZNV甲
        LeaveCriticalSection(&data->lock);
      }
    }
    break;
  default:
    return DefWindowProc(hwnd, uMsg, wParam, lParam);
  }
  return 0;
}

/**
 * w肳ꂽHWAVEINɑΉ wavein_data\̂ւ̃|C^ԂB
 * NULLw肳ꂽꍇAVwavein_data\̂ւ̃|C^ԂB
 */
static wavein_data* get_wavein_data(HWAVEIN hWaveIn)
{
  int i;
  wavein_data* result = NULL;
  EnterCriticalSection(&g_lock);
  if (! hWaveIn)
  {
    for (i = 0; i < MAX_WAVEIN_COUNT; ++i)
    {
      if (! g_wavein_data_array[i].in_use)
      {
        // 󂫃Xbg
	result = &g_wavein_data_array[i];
        // gp~Ԃɐݒ肷
	result->in_use = TRUE;
	result->stopped = TRUE;
	break;
      }
    }
  }
  else
  {
    for (i = 0; i < MAX_WAVEIN_COUNT; ++i)
    {
      if (g_wavein_data_array[i].hWaveIn == hWaveIn
          && g_wavein_data_array[i].in_use)
      {
        result = &g_wavein_data_array[i];
        break;
      }
    }
  }
  LeaveCriticalSection(&g_lock);

  return result;
}

/**
 * w肳ꂽHWAVEOUTɑΉ waveout_data\̂ւ̃|C^ԂB
 * NULLw肳ꂽꍇAVwaveout_data\̂ւ̃|C^ԂB
 */
static waveout_data* get_waveout_data(HWAVEOUT hWaveOut) {
	int i;
	waveout_data* result = NULL;
	EnterCriticalSection(&g_lock);
	if (! hWaveOut) {
		for (i = 0; i < MAX_WAVEOUT_COUNT; ++i) {
			if (! g_waveout_data_array[i].in_use) {
				// 󂫃Xbg
				result = &g_waveout_data_array[i];
				// gp~Ԃɐݒ肷
				result->in_use = TRUE;
				result->stopped = TRUE;
				break;
			}
		}
	} else {
		for (i = 0; i < MAX_WAVEOUT_COUNT; ++i) {
			if (g_waveout_data_array[i].hWaveOut == hWaveOut
					&& g_waveout_data_array[i].in_use) {
				result = &g_waveout_data_array[i];
				break;
			}
		}
	}
	LeaveCriticalSection(&g_lock);

	return result;
}

/**
 * w肳ꂽwavein_data\̂N[YB
 */
static void close_wavein_data(wavein_data* data) {
	int i;
	if (! data) {
		return;
	}
	EnterCriticalSection(&g_lock);
	for (i = 0; i < MAX_WAVEIN_COUNT; ++i) {
		if (&g_wavein_data_array[i] == data) {
			// 蓖Ăꂽ\[XׂĊJ
			DeleteCriticalSection(&data->lock);
			CloseHandle(data->hHeaderEvent);
			free_header_data(data->headers);

			// e0NAĂ
			memset(data, 0, sizeof(wavein_data));
			break;
		}
	}
	LeaveCriticalSection(&g_lock);
}

/**
 * w肳ꂽwaveout_data\̂N[YB
 */
static void close_waveout_data(waveout_data* data) {
	int i;

	if (! data) {
		return;
	}

	EnterCriticalSection(&g_lock);
	for (i = 0; i < MAX_WAVEOUT_COUNT; ++i) {
		if (&g_waveout_data_array[i] == data) {
			// 蓖Ăꂽ\[XׂĊJ
			DeleteCriticalSection(&data->lock);
			CloseHandle(data->hHeaderEvent);
			free_header_data(data->headers);

			// e0NAĂ
			memset(data, 0, sizeof(waveout_data));
			break;
		}
	}
	LeaveCriticalSection(&g_lock);
}

/**
 * Cxgpost
 */
static void post_LineEvent(JNIEnv* env, jobject line, jobject eventType, jlong position) {
	env->CallVoidMethod(
          g_eventQueue,
          g_postEvent_id,
          line,
          eventType,
          position);
}

/**
 * TargetDataLineANeBu𒲂ׂ
 */
static BOOL is_wavein_active(wavein_data* data) {
	int i;
	BOOL active = FALSE;
	EnterCriticalSection(&data->lock);
	for (i = 0; i < WAVEHDR_COUNT; ++i) {
		if ((! data->stopped) && (! (data->headers[i].dwUser & READABLE_FLAG))) {
			// ǂݍݕs\ȃobt@
			// ANeBuԂɂƔf
			active = TRUE;
			break;
		}
	}
	LeaveCriticalSection(&data->lock);
	return active;
}

/**
 * SourceDataLineANeBu𒲂ׂ
 */
static BOOL is_waveout_active(waveout_data* data) {
	int i;
	BOOL active = FALSE;
	EnterCriticalSection(&data->lock);
	for (i = 0; i < WAVEHDR_COUNT; ++i) {
		if (! (data->headers[i].dwUser & WRITABLE_FLAG)) {
			// ݕs\ȃobt@
			// ANeBuԂɂƔf
			active = TRUE;
			break;
		}
	}
	LeaveCriticalSection(&data->lock);
	return active;
}

/**
 * ǂݏopɃobt@bNÃCfbNXlԂB
 * bNłȂꍇɂ͕ԂB
 */
static int lock_readable_header(wavein_data* data) {
	int result = -1;
	int i;
	EnterCriticalSection(&data->lock);
	for (i = 0; i < WAVEHDR_COUNT; ++i) {
		// ȉ̏𖞂WAVEHDRT
		// o ǂݏo\ł
		// o ɓǂݏoׂobt@ł
		DWORD dwUser = data->headers[i].dwUser;
		if ((dwUser & READABLE_FLAG) && (dwUser & READ_HEAD_FLAG)) {
			// READABLE_FLAGNA
			dwUser &= ~READABLE_FLAG;
			data->headers[i].dwUser = dwUser;
			result = i;
			break;
		}
	}
	LeaveCriticalSection(&data->lock);
	return result;
}

/**
 * w肳ꂽCfbNXʒũobt@AbNB
 * ̍ۂɁucoCgvw肳ꂽlɍXVB
 * coCg0ɂȂꍇAREAD_HEAD_FLAG̓NAAWAVEHDR
 * READ_HEAD_FLAGĂB
 */
static void unlock_readable_header(wavein_data* data,
			     int index,
			     DWORD remains) {
	WAVEHDR* hdr = &data->headers[index];

	// NeBJZNVɓ
	EnterCriticalSection(&data->lock);

	// fobOp
	assert(! (hdr->dwUser & READABLE_FLAG));
	assert(hdr->dwUser & READ_HEAD_FLAG);
	assert(remains <= READ_MAX_BUFFER_SIZE);

	// remainsʃrbgɓ
	SET_READ_REMAINS(hdr->dwUser, remains);
	if (! remains) {
		// obt@̎c肪ȂȂꍇAREAD_HEAD_FLAGNAāA
		// WAVEHDRREAD_HEAD_FLAG𗧂Ă
		int next_index = (index + 1) >= WAVEHDR_COUNT
				? 0
				: index + 1;
		data->headers[next_index].dwUser |= READ_HEAD_FLAG;
		hdr->dwUser &= ~READ_HEAD_FLAG;

	} else {
		// ܂obt@Ɏc肪ꍇ́A
		// READABLE_FLAGēxĂ
		hdr->dwUser |= READABLE_FLAG;
	}
	
	// NeBJZNV甲
	LeaveCriticalSection(&data->lock);
}


/**
 * ݉\obt@bNACfbNXԂB
 */
static int lock_writable_header(waveout_data* data) {
	int i, result = -1;
	EnterCriticalSection(&data->lock);
	for (i = 0; i < WAVEHDR_COUNT; ++i) {
		if (data->headers[i].dwUser & WRITABLE_FLAG) {
			data->headers[i].dwUser &= ~WRITABLE_FLAG;
			result = i;
			break;
		}
	}
	LeaveCriticalSection(&data->lock);
	return result;
}

/**
 * ݉\obt@Ԃ
 */
static int get_writable_header_count(waveout_data* data) {
	int i, result = 0;
	EnterCriticalSection(&data->lock);
	for (i = 0; i < WAVEHDR_COUNT; ++i) {
		if (data->headers[i].dwUser & WRITABLE_FLAG) {
			result++;
		}
	}
	LeaveCriticalSection(&data->lock);
	return result;
}

/**
 * WAVEFORMATEX\̂
 */
static void init_waveformat(LPWAVEFORMATEX pwfe,
							int sampleRate,
							int sampleSizeInBits,
							int channels,
							int frameSize,
							int frameRate) {
	pwfe->wFormatTag = WAVE_FORMAT_PCM;
	pwfe->nChannels = (WORD) channels;
	pwfe->wBitsPerSample = (WORD) sampleSizeInBits;
	pwfe->nSamplesPerSec = (DWORD) sampleRate;
	pwfe->nBlockAlign = (WORD) frameSize;
	pwfe->nAvgBytesPerSec = (DWORD) (frameSize * frameRate);
}

/**
 * őobt@TCY𒲐A̒lԂB
 */
static int adjust_max_buffer_size(int bufferSize, WAVEFORMATEX* wfe) {
	int max_buffer_size = 0;

	// obt@TCY肷
	if (bufferSize && (bufferSize % wfe->nBlockAlign) == 0) {
		// obt@TCYubNAC̔{ɂȂĂꍇ
		// ̃obt@TCYgp
		max_buffer_size = bufferSize;
	} else {
		// w肳ꂽubNTCYubNACɂ킹
		int n = bufferSize / wfe->nBlockAlign;
		if (! n) {
			n = wfe->nBlockAlign;
		}
		max_buffer_size = wfe->nSamplesPerSec * n;
	}
	return max_buffer_size;
}

/**
 * WAVEHDR.lpDataɃ蓖Ă
 */
static BOOL alloc_header_data(int max_buffer_size, WAVEHDR* headers) {
	int i;
	BOOL result = TRUE;
	for (i = 0; i < WAVEHDR_COUNT; ++i) {
		LPSTR buff = (LPSTR) malloc(max_buffer_size);
		if (! buff) {
			// s
			int j;
			for (j = i - 1; j >= 0; --j) {
				// ܂łɊ蓖ĂJ
				free(headers[j].lpData);
			}
			result = FALSE;
			break;
		}
		headers[i].lpData = buff;
		headers[i].dwBufferLength = max_buffer_size;
	}
	return result;
}

/**
 * WAVEHDR.lpDataɊ蓖ĂꂽJ
 */
static void free_header_data(WAVEHDR* headers) {
	int i;
	for (i = 0; i < WAVEHDR_COUNT; ++i) {
		free(headers[i].lpData);
	}
}

/**
 * RuntimeExceptionthrow
 */
void throw_RuntimeException(JNIEnv* env, const char* msg) {
	jclass clazz = env->FindClass("java/lang/RuntimeException");
	if (clazz) {
		env->ThrowNew(clazz, msg);
	}
}

void throw_LineUnavailableException(JNIEnv* env, const char* msg) {
	jclass clazz = env->FindClass("javax/sound/sampled/LineUnavailableException");
	if (clazz) {
		env->ThrowNew(clazz, msg);
	}
}

void throw_MMRESULT_Exception(JNIEnv* env, MMRESULT mmresult) {
	jclass clazz;
	jstring msg;
	_TCHAR buff[256];
	
	// bZ[W擾
	waveOutGetErrorText(mmresult, buff, sizeof(buff) / sizeof(buff[0]));

	// bZ[Ww肵āAOthrowB
	msg = env->NewString((const jchar*) buff, _tcslen(buff));
	if (msg) {
		clazz = env->FindClass("javax/sound/sampled/LineUnavailableException");
		if (clazz) {
			jmethodID mid = env->GetMethodID(clazz, "<init>", "(Ljava/lang/String;)V");
			jthrowable t = (jthrowable) env->NewObject(clazz, mid, msg);
			env->Throw(t);
		}
	}
}

//----------------------------------------------------
//--- ȍ~ SourceDataLine ----------------------
//----------------------------------------------------

/*
 * Class:     gnu_javax_sound_sampled_wce_WCESourceDataLine
 * Method:    openNative
 * Signature: (ILjavax/sound/sampled/AudioFormat$Encoding;FIIIFZ)I
 */
JNIEXPORT jint JNICALL Java_gnu_javax_sound_sampled_wce_WCESourceDataLine_openNative
						(JNIEnv *env,
						 jobject instance,
						 jint bufferSize,
						 jfloat sampleRate,
						 jint sampleSizeInBits,
						 jint channels,
						 jint frameSize,
						 jfloat frameRate,
						 jboolean bigEndian) {
	int i;
	MMRESULT mmresult;
	
	// waveout_datamۂ
	waveout_data* data = get_waveout_data(NULL);
	if (! data) {
		throw_LineUnavailableException(env, "Too many waveout_data");
		return 0;
	}
	
	// mۂ\̂̓e
	InitializeCriticalSection(&data->lock);
	data->hHeaderEvent = CreateEvent(NULL,
									     FALSE,
										 FALSE,
										 NULL);
	data->instance = instance;

	// tH[}bg̓eAWAVEFORMATEX\̂
	init_waveformat(&data->waveformat,
					(int) sampleRate,
					sampleSizeInBits,
					channels,
					frameSize,
					(int) frameRate);

	// obt@TCY肷
	data->max_buffer_size = adjust_max_buffer_size(bufferSize, &data->waveformat);

	// obt@mۂ
	// obt@mۂ
	if (! alloc_header_data(data->max_buffer_size, data->headers)) {
		close_waveout_data(data);
		throw_LineUnavailableException(env, "Not enough memory");
		return 0;
	}

	// o̓foCXI[v
	mmresult = waveOutOpen(&data->hWaveOut,
						   WAVE_MAPPER,
						   &data->waveformat,
						   (DWORD) g_hwndCallback,
						   0,
						   CALLBACK_WINDOW);
	if (mmresult != MMSYSERR_NOERROR) {
		// G[
		close_waveout_data(data);
		throw_MMRESULT_Exception(env, mmresult);
		return 0;
	}

	{
		// {[擾eXg
		DWORD volume;
		waveOutGetVolume(data->hWaveOut, &volume);
		volume = volume;
	}

	// WAVEHDRԂɂ
	for (i = 0; i < WAVEHDR_COUNT; ++i) {
		data->headers[i].dwLoops = 1;

		mmresult = waveOutPrepareHeader(data->hWaveOut,
						&data->headers[i],
						sizeof(WAVEHDR));
		if (mmresult != MMSYSERR_NOERROR) {
			waveOutClose(data->hWaveOut);
			close_waveout_data(data);
			throw_MMRESULT_Exception(env, mmresult);
			return 0;
		}
		// ݉\tO𗧂ĂĂ
		data->headers[i].dwUser |= WRITABLE_FLAG;
	}

	return (jint) data;
}

/*
 * Class:     gnu_javax_sound_sampled_wce_WCESourceDataLine
 * Method:    writeNative
 * Signature: (I[BII)I
 */
JNIEXPORT jint JNICALL Java_gnu_javax_sound_sampled_wce_WCESourceDataLine_writeNative
(JNIEnv *env, jobject instance, jint nativeData, jbyteArray b, jint off, jint len) {
	char* buff;
	int bytes_left;
	char* p;

	// waveout_data\̂̃|C^𓾂
	waveout_data* data = (waveout_data*) nativeData;
	if (! data) {
		return 0;
	}

	// w肳ꂽoCgAobt@̃ACɍ킹
	len -= (len % data->waveformat.nBlockAlign);
	if (len <= 0) {
		return 0;
	}

	// obt@̃|C^𓾂
	buff = (char*) env->GetByteArrayElements(b, NULL);
	bytes_left = len;
	p = buff + off;

	// ׂẴoCgނ܂ňȉ̏JԂ
	while (bytes_left > 0) {
		// ANeBuԂ𒲂ׂĂ
		BOOL active = is_waveout_active(data);
		WAVEHDR* hdr = NULL;
		int write_count, writable_header_index;

		// ݉\wb_擾
		while ((writable_header_index = lock_writable_header(data)) < 0) {
			// Cxgʒm҂
			if (WaitForSingleObject(data->hHeaderEvent, INFINITE) != WAIT_OBJECT_0) {
				// G[
				// throw_RuntimeException(env,  "WaitForSingleObject() failed");
				goto END;
			}
			// ̎_/stop()̂ꂩĂяoĂ
			// Ƀ^[
			// ToDo: flush()ł^[悤ɂ
			if (data->stopped) {
				break;
			}
		}
		if (data->stopped) {
			goto END;
		}

		if (writable_header_index < 0) {
			// 炩̌ŃbNłȂꍇ̓^[
			goto END;
		}

		// NeBJZNVɓ
		EnterCriticalSection(&data->lock);

		// ރobt@肷
		hdr = &data->headers[writable_header_index];
		// ނׂoCgvZAobt@ɃRs[
		write_count = (bytes_left <= data->max_buffer_size)
						? bytes_left
						: data->max_buffer_size;
		memcpy(hdr->lpData, p, write_count);
		hdr->dwBufferLength = write_count;

		// NeBJZNV甲
		LeaveCriticalSection(&data->lock);

		// ĐL[ɓ
		if (waveOutWrite(data->hWaveOut, hdr, sizeof(WAVEHDR))
				== MMSYSERR_NOERROR) {
			if (! active) {
				// ANeBuԂωꍇ
				// STARTCxg𑗐M
				post_LineEvent(env,
						 data->instance,
						 g_LineEvent_Type_START,
						 AudioSystem_NOT_SPECIFIED);
			}
		} else {
			throw_RuntimeException(env, "waveOutWrite() failed");
			break;
		}

		// JE^ƃ|C^XV
		p += write_count;
		bytes_left -= write_count;

	}

END:
	env->ReleaseByteArrayElements(b, (jbyte*) buff, 0);
	// L[ɓꂽoCgԂ
	return len - bytes_left;
}

/*
 * Class:     gnu_javax_sound_sampled_wce_WCESourceDataLine
 * Method:    nativeClose
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_javax_sound_sampled_wce_WCESourceDataLine_nativeClose
(JNIEnv *env, jobject instance, jint nativeData)
{
  waveout_data* data = (waveout_data*) nativeData;
  int i;
  MMRESULT mmresult;

  if (! data)
  {
    return;
  }

  // ̊֐ĂяoĎ_ŁAłwaveOutReset()ĂяoĂ
  // wb_N[Abv
  for (i = 0; i < WAVEHDR_COUNT; ++i)
  {
    mmresult = waveOutUnprepareHeader(data->hWaveOut, &data->headers[i], sizeof(WAVEHDR));
    if (mmresult != MMSYSERR_NOERROR)
    {
      throw_MMRESULT_Exception(env, mmresult);
      break;
    }
  }

  mmresult = waveOutClose(data->hWaveOut);
  if (mmresult != MMSYSERR_NOERROR)
  {
    throw_MMRESULT_Exception(env, mmresult);
  }
}


/*
 * Class:     gnu_javax_sound_sampled_wce_WCESourceDataLine
 * Method:    drainNative
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_javax_sound_sampled_wce_WCESourceDataLine_drainNative
(JNIEnv *env, jobject instance, jint nativeData)
{
  // waveout_data\̂̃|C^𓾂
  waveout_data* data = (waveout_data*) nativeData;
  if (! data)
  {
    return;
  }

  // ׂẴwb_݉\ɂȂ܂ő҂
  while (get_writable_header_count(data) < WAVEHDR_COUNT)
  {
    if (WaitForSingleObject(data->hHeaderEvent, INFINITE) != WAIT_OBJECT_0)
    {
      // Othrow
      env->ThrowNew(env->FindClass("java/lang/RuntimeException"), "WaitForSingleObject() failed");
      break;
    }
  }
}

/*
 * Class:     gnu_javax_sound_sampled_wce_WCESourceDataLine
 * Method:    flushNative
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_javax_sound_sampled_wce_WCESourceDataLine_flushNative
(JNIEnv *env, jobject instance, jint nativeData)
{
  // waveout_data\̂̃|C^𓾂
  waveout_data* data = (waveout_data*) nativeData;
  if (! data)
  {
    return;
  }

  // ZbgtOݒ肵Ă
  EnterCriticalSection(&data->lock);
  data->reset = TRUE;
  LeaveCriticalSection(&data->lock);

  // Zbg
  if (waveOutReset(data->hWaveOut) != MMSYSERR_NOERROR)
  {
    env->ThrowNew(env->FindClass("java/lang/RuntimeError"), "waveOutReset() failed");
    return;
  }
}


/*
 * Class:     gnu_javax_sound_sampled_wce_WCESourceDataLine
 * Method:    isNativeActive
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_gnu_javax_sound_sampled_wce_WCESourceDataLine_isNativeActive
(JNIEnv *env, jobject instance, jint nativeData) {
	if (! nativeData) {
		return JNI_FALSE;
	}

	return is_waveout_active((waveout_data*) nativeData) ? JNI_TRUE : JNI_FALSE;
}

/*
 * Class:     gnu_javax_sound_sampled_wce_WCESourceDataLine
 * Method:    getNativeBufferSize
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_gnu_javax_sound_sampled_wce_WCESourceDataLine_getNativeBufferSize
(JNIEnv *env, jobject instance, jint nativeData) {
	// obt@TCYԂ
	if (! nativeData) {
		return AudioSystem_NOT_SPECIFIED;
	}

	return (jint) (((waveout_data*) nativeData)->max_buffer_size);
}

/*
 * Class:     gnu_javax_sound_sampled_wce_WCESourceDataLine
 * Method:    availableNative
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_gnu_javax_sound_sampled_wce_WCESourceDataLine_availableNative
(JNIEnv *env, jobject instance, jint nativeData) {
	int i;
	waveout_data* data = (waveout_data*) nativeData;
	jint result = 0;
	if (! data) {
		return 0;
	}

	EnterCriticalSection(&data->lock);
	for (i = 0; i < WAVEHDR_COUNT; ++i) {
		// obt@PĂꍇÃTCYԂ
		if (data->headers[i].dwUser & WRITABLE_FLAG) {
			result = data->max_buffer_size;
			break;
		}
	}
	LeaveCriticalSection(&data->lock);
	return result;
}

/*
 * Class:     gnu_javax_sound_sampled_wce_WCESourceDataLine
 * Method:    startNative
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_javax_sound_sampled_wce_WCESourceDataLine_startNative
(JNIEnv *env, jobject instance, jint nativeData)
{
  // waveout_data\̂̃|C^𓾂
  waveout_data* data = (waveout_data*) nativeData;
  if (! data) {
    return;
  }

  if (waveOutRestart(data->hWaveOut) != MMSYSERR_NOERROR)
  {
    env->ThrowNew(env->FindClass("java/lang/RuntimeException"), "waveOutRestart() failed");
    return;
  }

  EnterCriticalSection(&data->lock);
  data->stopped = FALSE;
  LeaveCriticalSection(&data->lock);

  // Đ̃obt@݂ꍇASTARTCxg𑗐M
  if (is_waveout_active(data))
  {
    post_LineEvent(env,
      data->instance,
      g_LineEvent_Type_START,
      AudioSystem_NOT_SPECIFIED);
  }
}

/*
 * Class:     gnu_javax_sound_sampled_wce_WCESourceDataLine
 * Method:    stopNative
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_javax_sound_sampled_wce_WCESourceDataLine_stopNative
(JNIEnv *env, jobject instance, jint nativeData) {
	// waveout_data\̂̃|C^𓾂
	waveout_data* data = (waveout_data*) nativeData;
	if (! data) {
		return;
	}

	// stoppedtOݒ肷
	EnterCriticalSection(&data->lock);
	data->stopped = TRUE;
	LeaveCriticalSection(&data->lock);

	if (waveOutPause(data->hWaveOut) != MMSYSERR_NOERROR) {
		env->ThrowNew(env->FindClass("java/lang/RuntimeException"), "waveOutPause() failed");
		return;
	}

	// STOPCxg𑗐M
	post_LineEvent(env,
			 data->instance,
			 g_LineEvent_Type_STOP,
			 AudioSystem_NOT_SPECIFIED);
	return;
}

//----------------------------------------------------
//--- ܂ł SourceDataLine ----------------------
//----------------------------------------------------


//----------------------------------------------------
//--- ȍ~ TargetDataLine ----------------------
//----------------------------------------------------

/*
 * Class:     gnu_javax_sound_sampled_wce_WCETargetDataLine
 * Method:    openNative
 * Signature: (IFIIIFZ)I
 */
JNIEXPORT jint JNICALL Java_gnu_javax_sound_sampled_wce_WCETargetDataLine_openNative
						(JNIEnv *env,
						 jobject instance,
						 jint bufferSize,
						 jfloat sampleRate,
						 jint sampleSizeInBits,
						 jint channels,
						 jint frameSize,
						 jfloat frameRate,
						 jboolean bigEndian) {
	int i;
	MMRESULT mmresult;

	// wavein_datamۂ
	wavein_data* data = get_wavein_data(NULL);
	if (! data) {
		throw_LineUnavailableException(env, "Too many wavein_data");
		return 0;
	}
	
	// mۂ\̂̓e
	InitializeCriticalSection(&data->lock);
	data->hHeaderEvent = CreateEvent(NULL,
									 FALSE,
									 FALSE,
									 NULL);
	data->instance = instance;

	// tH[}bg̓eAWAVEFORMATEX\̂
	// tH[}bg̓eAWAVEFORMATEX\̂
	init_waveformat(&data->waveformat,
					(int) sampleRate,
					sampleSizeInBits,
					channels,
					frameSize,
					(int) frameRate);

	// obt@TCY肷
	data->max_buffer_size = adjust_max_buffer_size(bufferSize, &data->waveformat);

	// obt@mۂ
	if (! alloc_header_data(data->max_buffer_size, data->headers)) {
		close_waveout_data(data);
		throw_LineUnavailableException(env, "Not enough memory");
		return 0;
	}

	// ̓foCXI[v
	mmresult = waveInOpen(&data->hWaveIn,
						   WAVE_MAPPER,
						   &data->waveformat,
						   (DWORD) g_hwndCallback,
						   0,
						   CALLBACK_WINDOW);
	if (mmresult != MMSYSERR_NOERROR) {
		// G[
		close_wavein_data(data);
		throw_MMRESULT_Exception(env, mmresult);
		return 0;
	}

	// WAVEHDRԂɂ
	for (i = 0; i < WAVEHDR_COUNT; ++i) {
		mmresult = waveInPrepareHeader(data->hWaveIn,
						&data->headers[i],
						sizeof(WAVEHDR));
		if (mmresult != MMSYSERR_NOERROR) {
			waveInClose(data->hWaveIn);
			close_wavein_data(data);
			throw_MMRESULT_Exception(env, mmresult);
			return 0;
		}
	}

	// 擪̃wb_Ƀ}[N
	data->headers[0].dwUser |= READ_HEAD_FLAG;

	// VXeL[ɓ
	for (i = 0; i < WAVEHDR_COUNT; ++i) {
		mmresult = waveInAddBuffer(data->hWaveIn,
								   &data->headers[i],
								   sizeof(WAVEHDR));
		if (mmresult != MMSYSERR_NOERROR) {
			waveInClose(data->hWaveIn);
			close_wavein_data(data);
			throw_MMRESULT_Exception(env, mmresult);
			return 0;
		}
	}

	return (jint) data;
}

/*
 * Class:     gnu_javax_sound_sampled_wce_WCETargetDataLine
 * Method:    readNative
 * Signature: (I[BII)I
 */
JNIEXPORT jint JNICALL Java_gnu_javax_sound_sampled_wce_WCETargetDataLine_readNative
(JNIEnv *env, jobject instance, jint nativeData, jbyteArray b, jint off, jint len) {
	wavein_data* data = (wavein_data*) nativeData;
	int buff_left;
	char* p;
	char* org_p;
	char* end_p;

	if (! data) {
		return 0;
	}

	// w肳ꂽoCgAobt@̃ACɍ킹
	len -= (len % data->waveformat.nBlockAlign);
	if (len <= 0) {
		return 0;
	}
	buff_left = len;
	p = (char*) env->GetByteArrayElements(b, NULL);
	if (! p) {
		return 0;
	}
	org_p = p;
	end_p = p + len;

	// Rs[Jnʒu
	p += off;

	// w肳ꂽoCgRs[܂ŁAJԂ
	while (p < end_p) {
		int index;
		DWORD bytes_remains;
		WAVEHDR* hdr;
		DWORD copy_len;
		MMRESULT mmresult;
		BOOL active;

		while ((index = lock_readable_header(data)) < 0) {
			// wb_̃f[^ǂݎ\ɂȂ܂őҋ@

			if (WaitForSingleObject(data->hHeaderEvent, INFINITE) != WAIT_OBJECT_0) {
				// ҋ@ɃG[
				// throw_RuntimeException(env, "WaitForSingleObject() failed");
				goto END;
			}

			if (data->stopped || data->closing) {
				// ҋ@stop()ꂽ
				// ToDo: flush()ꂽꍇɂɃ^[悤ɏC
				break;
			}
		}
		if (data->stopped || data->closing) {
			// ~ꂽꍇ͂Ƀ^[
			// ToDo: flush()ꂽꍇɂɃ^[悤ɏC
			goto END;
		}

		assert (0 <= index && index < WAVEHDR_COUNT);
		
		// ̎_ŃANeBu𒲂ׂ
		active = is_wavein_active(data);

		// ǂݏo\WAVEHDR𓾂
		hdr = &data->headers[index];

		// f[^obt@ɃRs[
		bytes_remains = GET_READ_REMAINS(hdr->dwUser);
		assert(bytes_remains <= hdr->dwBytesRecorded);
		copy_len = (p + bytes_remains >= end_p)
				? (end_p - p)
				: bytes_remains;
		memcpy(p,
		       hdr->lpData + (hdr->dwBytesRecorded - bytes_remains),
		       copy_len);

		
		// ǂݏoobt@AbN
		bytes_remains -= copy_len;
		unlock_readable_header(data,
				       index,
				       bytes_remains);
		if ((bytes_remains <= 0)
				&& (! data->closing)) {
			// SẴf[^ǂݍ񂾏ꍇ́A
			// ēx̓L[ɓȂ
			mmresult = waveInAddBuffer(data->hWaveIn, hdr, sizeof(WAVEHDR));
			if (mmresult != MMSYSERR_NOERROR) {
				// G[
				throw_MMRESULT_Exception(env, mmresult);
				goto END;
			}
		}
		
		// ANeBuԂɈڍsꍇASTARTCxg𑗂
		if (! active) {
			post_LineEvent(env,
					 data->instance,
					 g_LineEvent_Type_START,
					 AudioSystem_NOT_SPECIFIED);
		}

		// Rs[ʒuXV
		p += copy_len;
	}
END:
	env->ReleaseByteArrayElements(b, (jbyte*) org_p, 0);
	// obt@ɃRs[oCgԂ
	return p - org_p;
}

/*
 * Class:     gnu_javax_sound_sampled_wce_WCETargetDataLine
 * Method:    closeNative
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_javax_sound_sampled_wce_WCETargetDataLine_closeNative
(JNIEnv *env, jobject instance, jint nativeData) {
	int i;
	MMRESULT mmresult;
	wavein_data* data = (wavein_data*) nativeData;
	if (! data) {
		return;
	}

	EnterCriticalSection(&data->lock);
	data->closing = TRUE;
	LeaveCriticalSection(&data->lock);
	
	// waveInReset(), waveInUnprepareHeader(), waveInClose()̏ɌĂяo
	mmresult = waveInReset(data->hWaveIn);
	SetEvent(data->hHeaderEvent);

	if (mmresult == MMSYSERR_NOERROR) {
		for (i = 0; i < WAVEHDR_COUNT; ++i) {
			mmresult = waveInUnprepareHeader(data->hWaveIn, &data->headers[i], sizeof(WAVEHDR));
		}
		mmresult = waveInClose(data->hWaveIn);
	}

	if (mmresult != MMSYSERR_NOERROR) {
		throw_MMRESULT_Exception(env, mmresult);
	}
}
/*
 * Class:     gnu_javax_sound_sampled_wce_WCETargetDataLine
 * Method:    drainNative
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_javax_sound_sampled_wce_WCETargetDataLine_drainNative
(JNIEnv *env, jobject instance, jint nativeData) {
	wavein_data* data = (wavein_data*) nativeData;
	if (! data) {
		return;
	}

	// PȏWAVEHDRǂݏo\ɂȂ܂łƑ҂
	for (;;) {
		int i;
		BOOL readable_buffer_exists = FALSE;

		EnterCriticalSection(&data->lock);
		for (i = 0; i < WAVEHDR_COUNT; ++i) {
			// ǂݏo\ȃobt@邩ׂ
			if (data->headers[i].dwUser & READABLE_FLAG) {
				readable_buffer_exists = TRUE;
				break;
			}
		}
		LeaveCriticalSection(&data->lock);

		if (readable_buffer_exists) {
			// ǂݏo\ȃobt@1ȏ゠
			break;
		}

		// Cxg܂őҋ@
		if (WaitForSingleObject(data->hHeaderEvent, INFINITE) != WAIT_OBJECT_0) {
			// ҋ@ɃG[
			throw_RuntimeException(env, "WaitForSingleObject() failed.");
			break;
		}
	}
}

/*
 * Class:     gnu_javax_sound_sampled_wce_WCETargetDataLine
 * Method:    flushNative
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_javax_sound_sampled_wce_WCETargetDataLine_flushNative
(JNIEnv *env, jobject instance, jint nativeData) {
	wavein_data* data = (wavein_data*) nativeData;
	if (! data) {
		return;
	}

	// ZbgtO𗧂Ă
	EnterCriticalSection(&data->lock);
	data->reset = TRUE;
	LeaveCriticalSection(&data->lock);

	// VXeɃobt@̃Zbgw
	waveInReset(data->hWaveIn);

	// ̌A񓯊MM_WIM_DATA bZ[W
}

/*
 * Class:     gnu_javax_sound_sampled_wce_WCETargetDataLine
 * Method:    isNativeActive
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_gnu_javax_sound_sampled_wce_WCETargetDataLine_isNativeActive
(JNIEnv *env, jobject instance, jint nativeData) {
	wavein_data* data = (wavein_data*) nativeData;
	if (! data) {
		return JNI_FALSE;
	}

	return (jboolean) is_wavein_active(data);
}

/*
 * Class:     gnu_javax_sound_sampled_wce_WCETargetDataLine
 * Method:    getNativeBufferSize
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_gnu_javax_sound_sampled_wce_WCETargetDataLine_getNativeBufferSize
(JNIEnv *env, jobject instance, jint nativeData) {
	wavein_data* data = (wavein_data*) nativeData;
	if (! data) {
		return AudioSystem_NOT_SPECIFIED;
	}
	return (jint) data->max_buffer_size;
}

/*
 * Class:     gnu_javax_sound_sampled_wce_WCETargetDataLine
 * Method:    availableNative
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_gnu_javax_sound_sampled_wce_WCETargetDataLine_availableNative
(JNIEnv *env, jobject instance, jint nativeData) {
	wavein_data* data = (wavein_data*) nativeData;
	int i;
	jint size = 0;
	if (! data) {
		return 0;
	}

	EnterCriticalSection(&data->lock);
	for (i = 0; i < WAVEHDR_COUNT; ++i) {
		DWORD dwUser = data->headers[i].dwUser;
		if (dwUser & (READABLE_FLAG | READ_HEAD_FLAG)) {
			size = GET_READ_REMAINS(data->headers[i].dwUser);
			break;
		}
	}
	return size;
}

/*
 * Class:     gnu_javax_sound_sampled_wce_WCETargetDataLine
 * Method:    startNative
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_javax_sound_sampled_wce_WCETargetDataLine_startNative
(JNIEnv *env, jobject instance, jint nativeData) {
	wavein_data* data = (wavein_data*) nativeData;
	if (! data) {
		return;
	}

	EnterCriticalSection(&data->lock);
	data->stopped = FALSE;
	data->reset = FALSE;;
	LeaveCriticalSection(&data->lock);

	// ͂Jn
	waveInStart(data->hWaveIn);

	// Đ̃obt@݂ꍇASTARTCxg𑗐M
	if (is_wavein_active(data)) {
		post_LineEvent(env,
				 data->instance,
				 g_LineEvent_Type_START,
				 AudioSystem_NOT_SPECIFIED);
	}
}

/*
 * Class:     gnu_javax_sound_sampled_wce_WCETargetDataLine
 * Method:    stopNative
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_javax_sound_sampled_wce_WCETargetDataLine_stopNative
(JNIEnv *env, jobject instance, jint nativeData)
{
  wavein_data* data = (wavein_data*) nativeData;
  if (! data)
  {
    return;
  }

  EnterCriticalSection(&data->lock);
  data->stopped = TRUE;
  data->reset = FALSE;
  LeaveCriticalSection(&data->lock);

  // ͂Xgbv
  waveInStop(data->hWaveIn);

  // ҋ@ĂXbh邩Ȃ̂ŁA
  // Cxgʒm
  SetEvent(data->hHeaderEvent);

  // STOPCxg𑗐M
  post_LineEvent(env,
		 data->instance,
		 g_LineEvent_Type_STOP,
		 AudioSystem_NOT_SPECIFIED);
}
