#include <windows.h>
#include <jni.h>
#include "wce-peer.h"
#include <gnu_java_awt_peer_wce_WCEDialogPeer.h>

/*
 * Class:     gnu_java_awt_peer_wce_WCEDialogPeer
 * Method:    createNativeDialog
 * Signature: (IIIIIZ)I
 */
JNIEXPORT jint JNICALL Java_gnu_java_awt_peer_wce_WCEDialogPeer_createNativeDialog(JNIEnv *env, jobject peer_obj, jint parentWindowHandle, jint x, jint y, jint width, jint height, jboolean undecorated) {
	peer_obj = (*env)->NewGlobalRef(env, peer_obj);
	if (! peer_obj) {
		throw_AWTError(env, "NewGlobalRef() failed.");
		return 0;
	}
	return (jint) create_native_dialog(peer_obj, (HWND) parentWindowHandle, x, y, width, height, undecorated);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEDialogPeer
 * Method:    setNativeVisible
 * Signature: (IZZ)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEDialogPeer_setNativeVisible(JNIEnv *env, jobject peer_obj, jint windowHandle, jboolean visible, jboolean modal) {
	set_dialog_visible((HWND) windowHandle, visible, modal);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEDialogPeer
 * Method:    setNativeResizable
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEDialogPeer_setNativeResizable(JNIEnv *env, jobject peer_obj, jint frameWindowHandle, jboolean resizable) {
	LONG lStyle = GetWindowLong((HWND) frameWindowHandle, GWL_STYLE);
	if (resizable) {
		lStyle |= WS_THICKFRAME;
	} else {
		lStyle &= ~WS_THICKFRAME;
	}
	SetWindowLong((HWND) frameWindowHandle, GWL_STYLE, lStyle);
	SetWindowPos((HWND) frameWindowHandle,
                  0,
				  0, 0, 0, 0,
				  SWP_NOSIZE |  SWP_NOMOVE | SWP_NOZORDER | SWP_DRAWFRAME);

}
