/* java_thread.cpp
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of Mysaifu JVM

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.
*/


#include "StdAfx.h"
#include <Tlhelp32.h>
#include "java_thread.h"
#include "instruction.h"
#include "frame.h"
#include "common_funcs.h"
#include "resource.h"
#include "jni_funcs.h"
#include <xalloc.h>
#include <jvmti.h>

/**
 * Xbh̏
 */
struct thread_info
{
  HANDLE hThread;		// Xbhnh
  DWORD thread_id;		// XbhID(Windows CEł̓Xbhnh=XbhIDƂȂ邽ߕsvHj
  bool daemon;			// f[Xbh̏ꍇtrue
  jobject vmthread;		// java.lang.VMThreadIuWFNg̎Q
  jobject thread;		// java.lang.ThreadIuWFNg̎Q
  HANDLE hInterrupt;		// Thread.interrupt()gpCxgIuWFNg
  bool interrupted;		// VMThread.isInterrupted()ԂtO
};

/**
 * Xbhobt@̃TCY
 */
static int g_threads_count;

/**
 * Xbhobt@
 */
static thread_info **g_thread_infos;

/**
 * h~p
 */
CRITICAL_SECTION g_global_critical_section;

/**
 * s̃XbhAׂăf[XbhɂȂꍇɃVOiԂƂȂ
 * nhB
 */
HANDLE g_hTerminate;

/**
 * Xbh̃X^bNTCY
 */
static DWORD g_thread_stack_size;

/**
 * X^eBbN֐̐錾
 */
static bool add_thread_info (HANDLE hThread, DWORD thread_id, bool daemon,
			     jobject vmthread, jobject thread);
static void remove_current_thread_info ();
static bool non_daemon_thread_exists ();
static void dump_message (const _TCHAR * filename,
			  void *address,
			  DWORD code,
			  const _TCHAR * detail, CONTEXT * context);
static DWORD get_thread_id (jobject vmthread);

/**
 * R[obN֐
 */
LRESULT CALLBACK ExceptionDialogProc (HWND hDlg, UINT message, WPARAM wParam,
				      LPARAM lParam);

/**
 * Xbh֘A̐ݒ
 */
void
init_thread_settings (DWORD thread_stack_size)
{
  g_hTerminate = CreateEvent (NULL, TRUE,	// }jAZbg
			      FALSE, NULL);

  InitializeCriticalSection (&g_global_critical_section);

  g_thread_stack_size = thread_stack_size;
}

/**
 * Onh
 */
static int
filter (LPEXCEPTION_POINTERS pointers)
{
  CONTEXT *context = pointers->ContextRecord;
  EXCEPTION_RECORD *record = pointers->ExceptionRecord;

  if ((record->ExceptionFlags & 0x10) == 0x10)
    {
      // tB^֐łɗOĂ܂
      assert (false);
      OutputDebugString (_T
			 ("FATAL: Nested exception occurred in exception filter."));
      return EXCEPTION_EXECUTE_HANDLER;
    }

  _TCHAR *detail = NULL;
  int retcode = EXCEPTION_EXECUTE_HANDLER;
  _TCHAR buff[256];

  switch (record->ExceptionCode)
    {
    case EXCEPTION_ACCESS_VIOLATION:
      _stprintf (buff, _T ("Access violation. Attempted to %s address %x"),
		 (record->ExceptionInformation[0] ==
		  0 ? _T ("read") : _T ("write")),
		 record->ExceptionInformation[1]);
      detail = buff;
      break;

    case EXCEPTION_ARRAY_BOUNDS_EXCEEDED:
      detail = _T ("Array bounds exceeded");
      break;

    case EXCEPTION_DATATYPE_MISALIGNMENT:
      detail = _T ("Data misalignment");
      break;

    case EXCEPTION_FLT_DIVIDE_BY_ZERO:
    case EXCEPTION_INT_DIVIDE_BY_ZERO:
      detail = _T ("Divide by zero");
      break;

    case EXCEPTION_IN_PAGE_ERROR:
      detail = _T ("Page error");
      break;

    case EXCEPTION_STACK_OVERFLOW:
      detail = _T ("Stack overflow");
      break;

    case EXCEPTION_ILLEGAL_INSTRUCTION:
      detail = _T ("Illegal instruction");
      break;

    case EXCEPTION_IN_KMMALLOC:
      detail = _T ("kmmalloc detects heap error");
      break;

    default:
      // LȊO̗O͏Ȃ
      retcode = EXCEPTION_CONTINUE_SEARCH;
      break;
    }

  if (retcode != EXCEPTION_CONTINUE_SEARCH)
    {
      // Oo͂t@C߂
      _TCHAR destdir[MAX_PATH + 1];
      GetModuleFileName (GetModuleHandle (NULL), destdir,
			 sizeof (destdir) / sizeof (*destdir));
      int sepcount = 0;
      for (int i = _tcslen (destdir) - 1; i >= 0; --i)
	{
	  if (destdir[i] == _T ('\\'))
	    {
	      sepcount++;
	      if (sepcount >= 3)
		{
		  destdir[i] = _T ('\0');
		  break;
		}
	    }
	}
      _tcscat (destdir, _T ("\\errors"));
      CreateDirectory (destdir, NULL);

      _TCHAR reportfile[MAX_PATH + 1];
      GetTempFileName (destdir, _T ("err"), 0, reportfile);
      // t@CɃ_vbZ[Wo͂
      dump_message (reportfile,
		    record->ExceptionAddress,
		    record->ExceptionCode, detail, context);

      // _CAO{bNX\
      DialogBoxParam (GetModuleHandle (NULL),
		      MAKEINTRESOURCE (IDD_NATIVE_EXCEPTION),
		      NULL,
		      (DLGPROC) ExceptionDialogProc, (LPARAM) & reportfile);


    }
  return retcode;
}

/**
 * w肳ꂽ\bhs
 * ̊֐ CreateThread() ̈Ƃēn邱ƂOɂĂ
 */
DWORD WINAPI
thread_start (LPVOID pvarg)
{
  static method_info *run_minfo;
  static ClassFile* vmthread_cfile;
  static jfieldID vmthread_nativePointer_fid;

  __try
  {
    thread_start_parameter *param = (thread_start_parameter *) pvarg;

    if (! vmthread_cfile)
    {
      vmthread_cfile = get_ClassFile (param->vmthread_reference);
      assert(vmthread_cfile);
      
      vmthread_nativePointer_fid = get_field_id(vmthread_cfile, intern_utf8("nativePointer"), intern_utf8("I"));
      assert(vmthread_nativePointer_fid);
    }

    frame *newframe = alloc_root_frame (vmthread_cfile);

    // VMThreadIuWFNgpushiKx[WRNgȂ悤Ɂj
    PUSH_OBJECT (newframe, param->vmthread_reference);

    // JgXbhݒ肷
    set_current_thread (newframe, param->thread_reference);

    // Xbh̃Xe[^Xݒ肷
    newframe->body->thread_state = (JVMTI_THREAD_STATE_ALIVE | JVMTI_THREAD_STATE_RUNNABLE);

    // VMThread.nativePointerݒ肷
    PUSH_OBJECT(newframe, param->vmthread_reference);
    PUSH_INT(newframe, (jint) (newframe->body));
    put_field(newframe, vmthread_cfile, vmthread_nativePointer_fid);
    assert(! newframe->body->current_exception);


    // VMThread.run()Ăяo
    if (!run_minfo)
      {
	jmethodID mid =
	  get_method_id (vmthread_cfile, intern_utf8 ("run"),
			 intern_utf8 ("()V"));
	if (mid)
	  {
	    run_minfo = get_method_info (vmthread_cfile, mid);
	  }
      }
    assert(run_minfo);
    invoke_method (newframe, param->vmthread_reference, vmthread_cfile,
		       run_minfo);

    // Xbh̃Xe[^Xݒ肷
    update_thread_state_bits(newframe->body,
                            JVMTI_THREAD_STATE_TERMINATED,
                            JVMTI_THREAD_STATE_ALIVE | JVMTI_THREAD_STATE_RUNNABLE);

    // VMThread.nativePointerݒ肷
    PUSH_OBJECT(newframe, param->vmthread_reference);
    PUSH_INT(newframe, 0);
    put_field(newframe, vmthread_cfile, vmthread_nativePointer_fid);
    assert(! newframe->body->current_exception);


    // t[j
    free_root_frame (newframe);

    // p[^J
    free (param);

    // Xbh폜
    remove_current_thread_info ();

  }
  __except (filter (GetExceptionInformation ()))
  {
    // ̃Xbĥ݂I
    // A̎_ŃX^bÑ͊JĂ炸A
    // ܂j^JĂȂ߁ÂȂ
    // iOAj^JĂHj
  }
  return 0;
}

/**
 * WindowslCeBuXbh쐬
 */
bool
create_native_thread (LPTHREAD_START_ROUTINE func, thread_start_parameter* param)
{
  DWORD thread_id;
  HANDLE hThread = CreateThread (NULL,	// ZLeBLqq
				 g_thread_stack_size,	// X^bNTCY
				 func,	// s֐̃|C^
				 param,	// s֐ɓnp[^
				 STACK_SIZE_PARAM_IS_A_RESERVATION,	// Xbh쐬tO
				 &thread_id);	// XbhIDi[|C^
  bool result = false;
  if (hThread != NULL)
    {
      result = add_thread_info (hThread,
				thread_id,
				param->daemon,
				param->vmthread_reference,
				param->thread_reference);
    }

  return result;
}

/**
 * w肳ꂽo^
 */
static bool
add_thread_info (HANDLE hThread, DWORD thread_id, bool daemon,
		 jobject vmthread, jobject thread)
{
  // NeBJZNVɓ
  EnterCriticalSection (&g_global_critical_section);

  // thread_info\̂蓖ĂB
  thread_info *info = (thread_info *) malloc (sizeof (thread_info));
  if (info == NULL)
    {
      // NeBJZNV甲
      LeaveCriticalSection (&g_global_critical_section);
      fatal_error (FATAL_ERROR_NO_MEMORY);
    }

  // thread_info\̂̓e
  info->hThread = hThread;
  info->thread_id = thread_id;
  info->daemon = daemon;
  info->vmthread = vmthread;
  info->thread = thread;
  info->hInterrupt = CreateEvent (NULL,	// ZLeBLqqȂiCEł̓T|[gĂȂj
				  FALSE,	// Zbg
				  FALSE,	// Ԃł͔VOi
				  NULL);	// 
  info->interrupted = false;

  // 󂫃Xbgɓ
  bool result = false;
  for (int i = 0; i < g_threads_count; ++i)
    {
      if (g_thread_infos[i] == NULL)
	{
	  g_thread_infos[i] = info;
	  result = true;
	  break;
	}
    }
  if (!result)
    {
      // 󂫃XbgꍇAobt@g
      g_threads_count++;
      g_thread_infos =
	(thread_info **) realloc (g_thread_infos,
				  sizeof (thread_info *) * g_threads_count);
      if (g_thread_infos != NULL)
	{
	  g_thread_infos[g_threads_count - 1] = info;
	  result = true;
	}
      else
	{
	  free (info);
	  result = false;
	}
    }

  // NeBJZNV甲
  LeaveCriticalSection (&g_global_critical_section);
  return result;
}

/**
 * JgXbh폜
 */
static void
remove_current_thread_info ()
{
  EnterCriticalSection (&g_global_critical_section);
  DWORD thread_id = GetCurrentThreadId ();
  for (int i = 0; i < g_threads_count; ++i)
    {
      thread_info *info = g_thread_infos[i];
      if (info != NULL && info->thread_id == thread_id)
	{
	  CloseHandle (info->hThread);
	  CloseHandle (info->hInterrupt);
	  free (info);
	  g_thread_infos[i] = NULL;
	  break;
	}
    }
  if (!non_daemon_thread_exists ())
    {
      // f[XbhȊÕXbh݂ȂꍇACxgʒm
      SetEvent (g_hTerminate);
    }
  else
    {
      ResetEvent (g_hTerminate);
    }

  LeaveCriticalSection (&g_global_critical_section);
}


/**
 * JgXbhȊÕXbhׂăTXyh
 */
bool
suspend_all_other_threads ()
{
  EnterCriticalSection (&g_global_critical_section);

  bool result = true;
  DWORD currentThreadId = GetCurrentThreadId ();
  for (int i = 0; i < g_threads_count; ++i)
    {
      thread_info *info = g_thread_infos[i];
      if (info != NULL)
	{
	  DWORD threadId = info->thread_id;
	  if (threadId != currentThreadId)
	    {
	      if (SuspendThread (info->hThread) == -1)
		{
		  DWORD exitcode;
		  if (GetExitCodeThread (info->hThread, &exitcode) ==
		      STILL_ACTIVE)
		    {
		      int error = GetLastError ();
		      result = false;
		      break;
		    }
		}
	    }
	}
    }
  LeaveCriticalSection (&g_global_critical_section);

  return result;
}

/**
 * JgXbhȊÕXbhׂčĊJ
 */
bool
resume_all_other_threads ()
{
  EnterCriticalSection (&g_global_critical_section);

  bool result = true;
  DWORD currentThreadId = GetCurrentThreadId ();
  for (int i = 0; i < g_threads_count; ++i)
    {
      thread_info *info = g_thread_infos[i];
      if (info != NULL)
	{
	  if (info->thread_id != currentThreadId)
	    {
	      if (ResumeThread (info->hThread) == -1)
		{
		  result = false;
		  break;
		}
	    }
	}
    }
  LeaveCriticalSection (&g_global_critical_section);

  return result;
}

/**
 * f[ȊÕXbh݂Ă邩ׂ
 */
static bool
non_daemon_thread_exists ()
{
  EnterCriticalSection (&g_global_critical_section);
  bool result = false;
  for (int i = 0; i < g_threads_count; ++i)
    {
      thread_info *info = g_thread_infos[i];
      if (info != NULL && !info->daemon)
	{
	  result = true;
	  break;
	}
    }
  LeaveCriticalSection (&g_global_critical_section);
  return result;
}

/**
 * s̃Xbhׂăf[XbhɂȂꍇɃVOiԂɂȂ
 * nhԂ
 */
HANDLE
get_terminate_handle ()
{
  return g_hTerminate;
}

/**
 * JgXbhɑΉ Thread ̎QƂԂ
 */
jobject
current_Thread ()
{
  DWORD thread_id = GetCurrentThreadId ();
  EnterCriticalSection (&g_global_critical_section);
  jobject thread = NULL;
  for (int i = 0; i < g_threads_count; ++i)
    {
      thread_info *info = g_thread_infos[i];
      if (info != NULL)
	{
	  if (info->thread_id == thread_id)
	    {
	      thread = info->thread;
	      break;
	    }
	}
    }
  LeaveCriticalSection (&g_global_critical_section);
  return thread;
}

/**
 * w肳ꂽXbhIDɑΉ interrupt() pCxgIuWFNgԂB
 */
HANDLE
get_interrupt_event (DWORD thread_id)
{
  // NeBJZNVɓ
  EnterCriticalSection (&g_global_critical_section);

  HANDLE hEvent = NULL;
  for (int i = 0; i < g_threads_count; ++i)
    {
      thread_info *info = g_thread_infos[i];
      if (info != NULL)
	{
	  if (info->thread_id == thread_id)
	    {
	      hEvent = info->hInterrupt;
	      break;
	    }
	}
    }
  assert (hEvent != NULL);

  LeaveCriticalSection (&g_global_critical_section);

  return hEvent;
}

/**
 * w肳ꂽXbhIDɑΉ銄荞݃tOݒ肷
 */
void
set_interrupted (DWORD thread_id, bool flag)
{
  // NeBJZNVɓ
  EnterCriticalSection (&g_global_critical_section);

  for (int i = 0; i < g_threads_count; ++i)
    {
      thread_info *info = g_thread_infos[i];
      if (info != NULL)
	{
	  if (info->thread_id == thread_id)
	    {
	      info->interrupted = flag;
              if (! flag)
              {
                // CxgNA
                ResetEvent(info->hInterrupt);
              }
	      break;
	    }
	}
    }
  LeaveCriticalSection (&g_global_critical_section);
}

/**
 * w肳ꂽXbhIDɑΉ銄荞݃tOԂ
 */
bool
is_interrupted (jobject vmThread)
{
  // NeBJZNVɓ
  EnterCriticalSection (&g_global_critical_section);

  DWORD thread_id;
  if (vmThread)
  {
    thread_id = get_thread_id(vmThread);
  }
  else
  {
    // Thread.interrupted() ɑ
    thread_id = GetCurrentThreadId();
  }

  bool flag = false;
  for (int i = 0; i < g_threads_count; ++i)
    {
      thread_info *info = g_thread_infos[i];
      if (info != NULL)
	{
	  if (info->thread_id == thread_id)
	    {
	      flag = info->interrupted;
	      break;
	    }
	}
    }
  if (flag && ! vmThread)
  {
    // Thread.interrupted() ɑ

    // tONA
    set_interrupted (thread_id, false);	

  }

  LeaveCriticalSection (&g_global_critical_section);

  return flag;
}

/**
 * w肳ꂽXbhIDɑΉXbhɊ荞ށB
 * 荞݃tOtrueɐݒ肳B
 */
void
interrupt (jobject vmthread)
{
  assert(vmthread);
  DWORD thread_id = get_thread_id(vmthread);
  set_interrupted (thread_id, true);

  HANDLE hEvent = get_interrupt_event (thread_id);
  SetEvent (hEvent);
}

/**
 * w肳ꂽVMThreadIuWFNg̃CX^X֘AtꂽXbh
 * XbhIDԂ
 */
static DWORD
get_thread_id (jobject vmthread)
{
  // NeBJZNVɓ
  EnterCriticalSection (&g_global_critical_section);

  DWORD thread_id = (DWORD) - 1;
  for (int i = 0; i < g_threads_count; ++i)
    {
      thread_info *info = g_thread_infos[i];
      if (info != NULL)
	{
	  if (info->vmthread == vmthread)
	    {
	      thread_id = info->thread_id;
	      break;
	    }
	}
    }

  // NeBJZNV甲
  LeaveCriticalSection (&g_global_critical_section);
  return thread_id;
}

/**
 * w肳ꂽVMThreadIuWFNgɑΉ
 * lCeBuXbh̃nhԂ
 */
HANDLE
get_thread_handle (jobject vmthread)
{
  // NeBJZNVɓ
  EnterCriticalSection (&g_global_critical_section);

  HANDLE hThread = INVALID_HANDLE_VALUE;
  for (int i = 0; i < g_threads_count; ++i)
    {
      thread_info *info = g_thread_infos[i];
      if (info != NULL)
	{
	  if (info->vmthread == vmthread)
	    {
	      hThread = info->hThread;
	      break;
	    }
	}
    }

  // NeBJZNV甲
  LeaveCriticalSection (&g_global_critical_section);
  return hThread;
}

/**
 * w肳ꂽXbhIDɑΉjava.lang.ThreadIuWFNgԂ
 */
jobject get_thread_object_of(DWORD thread_id)
{
  LOCK_GLOBAL();
  
  jobject result = NULL;
  for (int i = 0; i < g_threads_count; ++i)
  {
    thread_info* info = g_thread_infos[i];
    if (info)
    {
      if (info->thread_id == thread_id)
      {
        result = info->thread;
        break;
      }
    }
  }
  
  UNLOCK_GLOBAL();

  return result;
}

/**
 * JVMTI_THREAD_STATE_XXX tO Thread.State \ɕϊ
 */
const _TCHAR* get_thread_state_from_jvmti_bits(int jvmti_thread_state_bits)
{
  const static _TCHAR new_str[] = _T("NEW");
  const static _TCHAR runnable_str[] = _T("RUNNABLE");
  const static _TCHAR terminated_str[] = _T("TERMINATED");
  const static _TCHAR blocked_str[] = _T("BLOCKED");
  const static _TCHAR waiting_str[] = _T("WAITING");
  const static _TCHAR timed_waiting_str[] = _T("TIMED_WAITING");

  jvmti_thread_state_bits &= JVMTI_JAVA_LANG_THREAD_STATE_MASK;

  const _TCHAR* stat = NULL;

  // Convert JVMTI_THREAD_STATE_XXX flags to Thread.State
  if (JVMTI_JAVA_LANG_THREAD_STATE_NEW == jvmti_thread_state_bits)
  {
    stat = new_str;
  }
  else if (JVMTI_JAVA_LANG_THREAD_STATE_TERMINATED == jvmti_thread_state_bits)
  {
    stat = terminated_str;
  }
  else if (jvmti_thread_state_bits & JVMTI_THREAD_STATE_ALIVE)
  {
    if (jvmti_thread_state_bits & JVMTI_THREAD_STATE_RUNNABLE)
    {
      stat = runnable_str;
    }
    else if (jvmti_thread_state_bits & JVMTI_THREAD_STATE_BLOCKED_ON_MONITOR_ENTER)
    {
      stat = blocked_str;
    }
    else if (jvmti_thread_state_bits & JVMTI_THREAD_STATE_WAITING)
    {
      if (JVMTI_THREAD_STATE_WAITING_INDEFINITELY & jvmti_thread_state_bits)
      {
        stat = waiting_str;
      }
      else if (JVMTI_THREAD_STATE_WAITING_WITH_TIMEOUT & jvmti_thread_state_bits)
      {
        stat = timed_waiting_str;
      }
      else
      {
        assert(false);
      }
    }
  }

  assert(stat);
  return stat;
}

/**
 * NbV_̏t@Cɏo͂
 * o͂e͈ȉ̂Ƃ
 * 1. JVM̃o[W
 * 2. OS̃o[W
 * 3. NbVAhX
 * 4. G[bZ[W̕
 */
static void
dump_message (const _TCHAR * filename,
	      void *address,
	      DWORD code, const _TCHAR * detail, CONTEXT * context)
{
  FILE *fp = _tfopen (filename, _T ("w"));
  if (fp)
    {
      // JVM̐mȃo[W擾
      LARGE_INTEGER jvm_version = get_jvm_version ();
      // 16rbgƂɋ؂ĕ쐬
      _ftprintf (fp,
		 _T ("JVM Version: %d.%d.%d.%d\n"),
		 HIWORD (jvm_version.HighPart),
		 LOWORD (jvm_version.HighPart),
		 HIWORD (jvm_version.LowPart), LOWORD (jvm_version.LowPart));
      // OS̃o[W擾
      OSVERSIONINFO info = { 0 };
      info.dwOSVersionInfoSize = sizeof (OSVERSIONINFO);
      GetVersionEx (&info);
      _ftprintf (fp,
		 _T ("OS version: %d.%d (Build %d): PlatformId %d : %s\n"),
		 info.dwMajorVersion,
		 info.dwMinorVersion,
		 info.dwBuildNumber, info.dwPlatformId, info.szCSDVersion);

      // gpʂo͂
      MEMORYSTATUS memstat = { 0 };
      memstat.dwLength = sizeof (MEMORYSTATUS);
      GlobalMemoryStatus (&memstat);
      _ftprintf (fp,
		 _T
		 ("Memory: %d%% used, physical %d/%d, page file %d/%d, virtual %d/%d\n"),
		 memstat.dwMemoryLoad, memstat.dwAvailPhys,
		 memstat.dwTotalPhys, memstat.dwAvailPageFile,
		 memstat.dwTotalPageFile, memstat.dwAvailVirtual,
		 memstat.dwTotalVirtual);

      STORE_INFORMATION sinfo = { 0 };
      GetStoreInformation (&sinfo);
      _ftprintf (fp,
		 _T ("Store: %d/%d\n"), sinfo.dwFreeSize, sinfo.dwStoreSize);

      // R[hy[Wo͂
      _ftprintf (fp, _T ("CodePage: %d\n"), GetOEMCP ());

      // argumentso͂
      _fputts (_T ("JVM arguments:"), fp);
      arguments *args = get_current_arguments ();
      arguments_store (args, fp);
      _fputts (_T ("\n"), fp);

      // OAhXo͂
      _ftprintf (fp, _T ("ExceptionAddress:0x%08x\n"), address);

      // OR[ho͂
      _ftprintf (fp, _T ("ExceptionCode: %x\n"), code);

      // ڍ׃bZ[Wo͂
      _ftprintf (fp, _T ("Exception detail:%s\n\n"), detail);

#if defined(ARM)
      // ReLXgo͂
      _fputts (_T ("Context:\n"), fp);
      _ftprintf (fp,
		 _T ("ContextFlags=0x%x\n")
		 _T
		 ("R0=0x%08x R1=0x%08x R2=0x%08x R3=0x%08x R4=0x%08x R5=0x%08x R6=0x%08x\n")
		 _T
		 ("R7=0x%08x R8=0x%08x R9=0x%08x R10=0x%08x R11=0x%08x R12=0x%08x\n")
		 _T ("Sp=0x%08x Lr=0x%08x Pc=0x%08x Psr=0x%08x\n")
		 _T ("Fpscr=0x%08x FpExc=0x%08x\n"), context->ContextFlags,
		 context->R0, context->R1, context->R2, context->R3,
		 context->R4, context->R5, context->R6, context->R7,
		 context->R8, context->R9, context->R10, context->R11,
		 context->R12, context->Sp, context->Lr, context->Pc,
		 context->Psr, context->Fpscr, context->FpExc);
      for (int i = 0; i <= NUM_VFP_REGS; ++i)
	{
	  _ftprintf (fp, _T ("S[%d]=0x%08x "), i, context->S[i]);
	}
      _ftprintf (fp, _T ("\n"));
      for (int i = 0; i < NUM_EXTRA_CONTROL_REGS; ++i)
	{
	  _ftprintf (fp, _T ("FpExtra[%d]=0x%08x "), i, context->FpExtra[i]);
	}
      _ftprintf (fp, _T ("\n\n"));

#endif
      // DLLW[ꗗo͂
      _fputts (_T ("Modules:\n"), fp);
      HANDLE hSnapshot = CreateToolhelp32Snapshot (TH32CS_SNAPMODULE, 0);
      if (hSnapshot != INVALID_HANDLE_VALUE)
	{
	  MODULEENTRY32 me = { 0 };
	  me.dwSize = sizeof (MODULEENTRY32);
	  if (Module32First (hSnapshot, &me))
	    {
	      _fputts (_T
		       ("ModuleID   ProcessID  GlblcntUsg ProccntUsg modBaseAdr-modEndAdr  hModule    szModule   szExePath dwFlags \n"),
		       fp);
	      do
		{
		  _ftprintf (fp,
			     _T
			     ("0x%08x 0x%08x 0x%08x 0x%08x 0x%08x-0x%08x 0x%08x %s %s 0x%08x \n"),
			     me.th32ModuleID, me.th32ProcessID,
			     me.GlblcntUsage, me.ProccntUsage, me.modBaseAddr,
			     (me.modBaseAddr + me.modBaseSize), me.hModule,
			     me.szModule, me.szExePath, me.dwFlags);
		}
	      while (Module32Next (hSnapshot, &me));
	    }
	  CloseToolhelp32Snapshot (hSnapshot);
	}

      // JavaX^bNg[Xo͂
      jobject thread = current_Thread ();
      _fputts (_T ("\nJava stack trace:\n"), fp);
      if (thread)
	{
	  frame *current_frame = get_current_frame_of (thread);
	  while (current_frame)
	    {
	      // ToDo:₷`ɐ`
	      ClassFile *cfile = current_frame->current_class_file;
	      method_info *minfo = current_frame->current_method_info;
	      fprintf (fp, "%s.%s%s : (%s method)\n",
		       (cfile) ? cfile->this_class_name : NULL,
		       (minfo) ? minfo->name : NULL,
		       (minfo) ? minfo->descriptor : NULL,
		       (minfo) ? (is_native (minfo->access_flags) ? "Native" :
				  "Java") : NULL);


	      // j^JA܂蕡GȏsƁAɗOĂ܂\
	      // current_frame = leave_method(current_frame);

	      // 1Oframe𓾂
	      current_frame = current_frame->previous_frame;
	    }
	}
#ifdef DEBUG
// lXgÕeXg
//char*p = NULL;
//*p = 'A';
#endif
      _ftprintf (fp, _T ("\n"));
      _fputts (_T ("End of context dump\n"), fp);

      fclose (fp);
    }
}

/**
 * Win32O_CAÕR[obN֐
 */
LRESULT CALLBACK
ExceptionDialogProc (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
  static const _TCHAR *filename;
  switch (message)
    {
    case WM_INITDIALOG:
      {
	// _CAO{bNXő剻
	SHINITDLGINFO shidi = { 0 };
	shidi.dwMask = SHIDIM_FLAGS;
	shidi.dwFlags =
	  SHIDIF_DONEBUTTON | SHIDIF_SIZEDLGFULLSCREEN | SHIDIF_EMPTYMENU;
	shidi.hDlg = hDlg;
	SHInitDialog (&shidi);

	SetWindowText (hDlg, _T ("Mysaifu JVM Problem"));
	filename = (const _TCHAR *) lParam;

	SetDlgItemText (hDlg, IDC_REPORT_FILE_NAME, filename);
      }
      return TRUE;

    case WM_COMMAND:
      switch (LOWORD (wParam))
	{
	case IDOK:
	  {
	    // [U͓̓e擾
	    _TCHAR buff[512];
	    GetDlgItemText (hDlg,
			    IDC_EXCEPTION_REPORT,
			    buff, sizeof (buff) / sizeof (buff[0]));

	    // t@Cɒǉ
	    FILE *fp = _tfopen (filename, _T ("a"));
	    if (fp)
	      {
		_fputts (_T ("\nAdditional information:\n"), fp);
		_fputts (buff, fp);
		fclose (fp);
	      }

	    // ۑt@C\
	    _sntprintf (buff,
			sizeof (buff) / sizeof (_TCHAR) - 1,
			_T
			("The report file has been created. Filename : %s"),
			filename);
	    buff[sizeof (buff) / sizeof (_TCHAR) - 1] = _T ('\0');
	    MessageBox (hDlg,
			buff, _T ("Notice"), MB_OK | MB_ICONINFORMATION);

	    // _CAOI
	    EndDialog (hDlg, LOWORD (wParam));
	  }
	  return TRUE;
	}
      break;
    }
  return FALSE;
}

