/* java_object.h
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of Mysaifu JVM

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.
*/

#ifndef JAVA_OBJECT_H_INCLUDED
#define JAVA_OBJECT_H_INCLUDED

#include "ClassFile.h"
#include "java_object.h"
#include "frame.h"
#include "monitor.h"

/**
 * t@CiCU
 */
struct finalizer;

/**
 * CX^Xf[^
 */
struct java_object {
	/**
	 * java_objectւ̃|C^
	 */
	java_object* next;

	/**
	 * q[vvf̃TCY
	 */
	unsigned int size;

	/**
	 * Kx[WRN^gptO
	 */
	long flags;

	/**
	 * ̃CX^XɑΉClassFile\
	 */
	ClassFile* class_file;
	
	/**
	 * IuWFNg̃j^
	 */
	monitor* object_monitor;

	/**
	 * f[^JEgB
	 * ʏIuWFNg̏ꍇAf[^̃oCgƂȂB
	 * zIuWFNg̏ꍇAz̒\B
	 *
	 */
	__int32	count;
	
	// f[^{̂́A̍\̂̌ɑĔzu

};

/**
 * q[v
 */
void initialize_heap(unsigned int max_size);

/**
 * Kx[WRN^
 */
bool init_gc();

/**
 * w肳ꂽNXstaticf[^쐬B
 *
 * @param	cfile	ClassFile\̂̃|C^Bloaderɂă[hꂽ̂łȂ΂ȂȂB
 * @return	statictB[h̓eێIuWFNgBmۂłȂꍇNULLB
 */
jobject alloc_static_data(ClassFile* cfile);

/**
 * w肳ꂽNX̔statictB[h̒lێjava_object\̂쐬
 *
 * @param	cfile	ClassFile\̂̃|C^Bloaderɂă[hꂽ̂łȂ΂ȂȂB
 * @param	stack	쐬IuWFNg̎QƂpushX^bNEt[
 * @return	IuWFNg̎QƁBmۂłȂꍇNULLB
 */
jobject alloc_object(ClassFile* cfile, frame* stack);

/**
 * w肳ꂽNXɑΉzIuWFNgpmۂ
 *
 * @param	cfile	ClassFile\̂̃|C^B
 * @param	count	z̗vf
 * @param	stack	쐬z̎QƂpushX^bNEt[B
 * @return	쐬z̎QƁB쐬łȂꍇNULL
 */
jarray alloc_array(ClassFile* cfile, __int32 count, frame* stack);

/**
 * w肳ꂽUTF-8Javachar[]ɕϊ
 * w肳ꂽUTF-8UnicodeɕϊꂽAUnicodeێ
 * charz񂪍쐬
 *
 * @param	cfile	char[]\ClassFile\́B(NX"[C")
 * @param	utf8	UTF-8
 * @param	stack	쐬z̎QƂpushX^bNEt[B
 * @return	쐬z̎QƁB쐬łȂꍇNULL
 */
jcharArray alloc_char_array(ClassFile* cfile, const java_utf8* utf8, frame* stack);
jcharArray alloc_permanent_char_array(ClassFile* cfile, const java_utf8* utf8, frame* stack);

/**
 * w肳ꂽUnicodeJavachar[]ɕϊ
 *
 * @param	cfile	char[]\ClassFile\́B(NX"[C")
 * @param	unicode	Unicode
 * @param	length	Unicode񒆁Azɓ钷
 * @param	stack	쐬z̎QƂpushX^bNEt[B
 * @return	쐬z̎QƁB쐬łȂꍇNULL
 */
jcharArray alloc_char_array(ClassFile* cfile, _TCHAR* unicode, int length, frame* stack);

/**
 * w肳ꂽQƂ̓e𕡐
 */
jobject clone(frame* frm, jobject ref);

/**
 * w肳ꂽtB[h̓eݒ肷
 */
void put_field(frame* frame, ClassFile* cfile, jfieldID fid);

/**
 * w肳ꂽtB[h̓eݒ肷
 */
void put_field_by_position(frame* frm, const CONSTANT_Fieldref_info* fieldref);

/**
 * w肳ꂽstatictB[h̓eݒ肷
 */
void put_static_field(frame* frame, jobject data, jfieldID fid);

/**
 * w肳ꂽstatictB[h̒lԂ
 */
bool get_field(frame* frame, ClassFile* cfile, jfieldID fid);

/**
 * w肳ꂽtB[h̒l擾At[push
 *
 * @param	frame	tB[h̒li[t[
 * @param       fieldref   tB[hQƂĂCONSTANT_Fieldref_infoւ̃|C^
 */
void get_field_by_position(frame* frame, const CONSTANT_Fieldref_info* fieldref);


/**
 * w肳ꂽstatictB[h̒l擾At[push
 *
 */
bool get_static_field(frame* frame, jobject ref, jfieldID fid);

/**
 * w肳ꂽstatictB[h̒lԂ
 *
 * @param	frame      tB[h̒li[t[
 * @param       fieldref   X^eBbNtB[hQƂĂCONSTANT_Fieldref_infoւ̃|C^
 */
void get_static_field_by_position(frame* frame, const CONSTANT_Fieldref_info* fieldref);

/**
 * w肳ꂽstatictB[hɒlݒ肷
 *
 * @param	frame             tB[h̒lݒ肳ꂽframe
 * @param       fieldref   X^eBbNtB[hQƂĂCONSTANT_Fieldref_infoւ̃|C^
 */
void put_static_field_by_position(frame* frame, const CONSTANT_Fieldref_info* fieldref);


/**
 * w肳ꂽz̒Ԃ
 */
inline __int32 get_array_length(jarray arrayref) {
/*
	java_object* obj = lock_address(arrayref);
	__int32 count = obj->count;
	unlock_address(arrayref);
	return count;
*/
	return ((java_object*) arrayref)->count;
}

/**
 * w肳ꂽz̗vf擾
 * 
 * @param	arrayref	zIuWFNgւ̃|C^
 * @param	index		CfbNX
 * @param	pvalue		擾li[
 */
bool load_object_array(jarray arrayref, jint inde, jobject* pref);

/**
 * w肳ꂽz̗vfݒ肷
 *
 * @param	obj	zIuWFNg
 * @param	index	CfbNX
 * @param	value	ݒl
 */
bool store_object_array(jarray arrayref, __int32 index, jobject ref);

/**
 * w肳ꂽQƂClassFileԂ
 */
inline ClassFile* get_ClassFile(jobject ref)
{
  return ((java_object*) ref)->class_file;
}

/**
 * ̃IuWFNg̃j^Ԃ
 *
 */
monitor* get_monitor(jobject ref);

/**
 * ̃IuWFNg̃j^ݒ肷
 *
 */
void set_monitor(jobject ref, monitor* m);

/**
 * IuWFNg{̂ւ̃|C^Ԃ
 */
inline void* get_object_body(jobject ref) {
	java_object* obj = (java_object*) ref;
	return (obj + 1);
}

/**
 * Kx[WRN^N
 */
void gc();

/**
 * IuWFNgf[^{̂Ăʒũ|C^bNB
 * ̊֐Ăяo_ŁAAhXʒubNAKx[WRNV
 * Ώۂł͂ȂȂB
 * lock_pointerĂяôƓ unlock_pointer֐Ăяo܂ŁA
 * bNꂽԂƂȂB
 */
void* pin_object(jobject ref);

/**
 * w肳ꂽ|C^AbNB
 * ̊֐ɓn|C^́Apin_object()֐Ԃꂽ̂
 * gpȂ΂ȂȂB
 */
void unpin_object(void* ptr);

/**
 * t@CiCUXbh
 */
bool init_finalizer();

/**
 * t@CiCUԂ
 */
finalizer* get_finalizer();

/**
 * t@CiCYs
 */
void gc_run_finalizer(frame* frm, finalizer* f);

/**
 * z̃Rs[s
 */
void array_copy(jobject src, unsigned int src_start, jobject dest, unsigned int dest_start, int length);


#define SOFT_REFERENCE		1
#define WEAK_REFERENCE		2
#define PHANTOM_REFERENCE	3

/**
 * QƃIuWFNgł邱ƂKx[WRN^ɒʒmB
 * SoftReference/WeakReference/PhantomReferencẽCX^X́AK̊֐p
 * Kx[WRN^ɓo^ĂKvB
 * Kx[WRN^́Å֐œo^ꂽIuWFNgʈB
 * typeɎw肷鐔l͈ȉ̂ƂB
 */
void set_reference_type(jobject obj, int reference_type);

/**
 * Kx[WRN^Ot@Cݒ肷
 */
void set_loggc_filename(const _TCHAR* filename);

/**
 * 󂫃ʂԂ
 */
unsigned int gc_get_free_memory();

/**
 * q[vŜ̃TCYԂ
 */
unsigned int gc_get_total_memory();

/**
 * ő僁ʂԂ
 */
unsigned int gc_get_max_memory();

/**
 * -verbose:gc IvVݒ肷
 */
void gc_set_verbose(bool verbose);

/**
 * IuWFNgQƂ̃bNJEgP₵AIuWFNg̃AhXԂB
 * ݖB͈ȉ̂悤ȓ\B
 * bNJEg1ȏ̏ꍇAKx[WRN^̓IuWFNg̃AhXړłȂB
 * iIuWFNg̈ړT|[gۂɎj
 */
#define lock_address(ref)	((java_object*) ref)
/**
 * IuWFNgQƂ̃bNJEgP炷B
 * ݖB͈ȉ̂悤ȓ\B
 * 
 * bNJEg1ȏ̏ꍇAKx[WRN^̓IuWFNg̃AhXړłȂB
 */
#define	unlock_address(ref)

/**
 * w肳ꂽjava_objectɑΉ jobject Ԃ
 */
inline jobject make_reference(java_object* obj) {
	// ݂̎ł́Ajobjectjava_object*Ɠ
	return (jobject) obj;
}

/**
 * IuWFNg{̂̃|C^Ԃ
 *
 * @param	obj
 * @return	IuWFNgf[^{̂i[Ă|C^
 */
inline void* get_body_ptr(java_object* obj) {
	return (obj + 1);
}

/**
 * w肳ꂽzNX́AevfTCYԂB
 */
inline unsigned int get_array_component_size(java_utf8* name) {
	// zvf̃TCY𔻒肷
	assert(name[0] == '[');
	switch (name[1]) {
	case 'B':
	case 'Z':
		// byteboolean^1oCg
		return 1;

	case 'C':
	case 'S':
		// charshort2oCg
		return 2;

	case 'D':
	case 'J':
		// doublelong8oCg
		return 8;

	default:
		// ̑̏ꍇ4oCg
		return 4;
	}
}

#endif