/* WCEMixerProvider.java
   Copyright (C) 2006, 2007, 2008, 2009 Mysaifu.com

This file is part of Mysaifu JVM.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; the version 2.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


package gnu.javax.sound.sampled.wce;

import java.security.AccessController;
import java.security.PrivilegedAction;

import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.MixerProvider;

public class WCEMixerProvider
    extends MixerProvider
{
  static
    {
      AccessController.doPrivileged(new PrivilegedAction()
      {
        public Object run()
        {
          System.loadLibrary("wcesound");
          return null;
        }
      });
    }

  /**
   * T|[gĂ~LT[
   */
  static Mixer.Info mixerInfo = new WCEMixerInfo("Windows CE mixer",
                                                 "Mysaifu.com", "", "0.0.1");

  public boolean isMixerSupported(Mixer.Info info)
  {
    return mixerInfo.equals(info);
  }

  public Mixer.Info[] getMixerInfo()
  {
    // ToDo: Ǝ
    return new Mixer.Info[] { mixerInfo };
  }

  public Mixer getMixer(Mixer.Info info)
  {
    if (info == null || mixerInfo.equals(info))
      {
        return new WCEMixer(mixerInfo);
      }
    throw new IllegalArgumentException("Unsupported Mixer.Info:" + info);
  }

  /**
   * Mixer.Info
   */
  static class WCEMixerInfo
      extends Mixer.Info
  {
    WCEMixerInfo(String name, String vendor, String description, String version)
    {
      super(name, vendor, description, version);
    }
  }
}
