#include <windows.h>
#include <jni.h>
#include <assert.h>
#include "wce-peer.h"
#include <gnu_java_awt_peer_wce_WCEScrollPanePeer.h>

/*
 * Class:     gnu_java_awt_peer_wce_WCEScrollPanePeer
 * Method:    createNativeScrollPane
 * Signature: (IIIIII)I
 */
JNIEXPORT jint JNICALL
Java_gnu_java_awt_peer_wce_WCEScrollPanePeer_createNativeScrollPane (JNIEnv *
								     env,
								     jobject
								     peer_obj,
								     jint
								     parentWindowHandle,
								     jint x,
								     jint y,
								     jint
								     width,
								     jint
								     height,
								     jint
								     policy)
{
  peer_obj = (*env)->NewGlobalRef (env, peer_obj);
  return (jint) create_native_scroll_pane (peer_obj,
					   (HWND) parentWindowHandle, x, y,
					   width, height, policy);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEScrollPanePeer
 * Method:    getNativeHScrollbarHeight
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL
Java_gnu_java_awt_peer_wce_WCEScrollPanePeer_getNativeHScrollbarHeight (JNIEnv
									* env,
									jobject
									peer_obj,
									jint
									windowHandle)
{
  return (jint) GetSystemMetrics (SM_CYHSCROLL);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEScrollPanePeer
 * Method:    getNativeVScrollbarWidth
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL
Java_gnu_java_awt_peer_wce_WCEScrollPanePeer_getNativeVScrollbarWidth (JNIEnv
								       * env,
								       jobject
								       peer_obj,
								       jint
								       windowHandle)
{
  return (jint) GetSystemMetrics (SM_CXVSCROLL);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEScrollPanePeer
 * Method:    setNativeScrollPosition
 * Signature: (IIIII)V
 */
JNIEXPORT void JNICALL
Java_gnu_java_awt_peer_wce_WCEScrollPanePeer_setNativeScrollPosition (JNIEnv *
								      env,
								      jobject
								      peer_obj,
								      jint
								      windowHandle,
								      jint
								      oldX,
								      jint
								      oldY,
								      jint
								      newX,
								      jint
								      newY)
{
  set_scroll_pane_scroll_position ((HWND) windowHandle, oldX, oldY, newX,
				   newY);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEScrollPanePeer
 * Method:    setNativeScrollbarParameters
 * Signature: (IIII)V
 */
JNIEXPORT void JNICALL
Java_gnu_java_awt_peer_wce_WCEScrollPanePeer_setNativeScrollbarParameters
  (JNIEnv * env, jobject peer_obj, jint windowHandle, jint scrollbarType,
   jint maximum, jint visibleAmount)
{
  set_scroll_pane_scrollbar_parameters ((HWND) windowHandle, scrollbarType,
					maximum, visibleAmount);
}
