#ifndef FREE_TYPE_GLYPH_PATH_ITERATOR_H_INCLUDED
#define FREE_TYPE_GLYPH_PATH_ITERATOR_H_INCLUDED

#include <ft2build.h>
#include FT_FREETYPE_H 
#include FT_OUTLINE_H 
#include FT_BITMAP_H
#include <windows.h>
#include "FreeTypeGlyphVector.h"

class FreeTypeGlyphPathIterator
{
private:
    FreeTypeGlyphVector* glyphVector;
    FT_Outline* outlines;
    int numOutlines;
    
    int currentOutlineIndex;
    int currentContourIndex;
    int currentPointIndex;

    /**
     * pending SEG_CLOSE flag.
     */
    bool pendingSegClose;

public:
    FreeTypeGlyphPathIterator(FreeTypeGlyphVector* gv, int glyphIndex = -1);
    ~FreeTypeGlyphPathIterator();

    bool isDone() const;
    void next();

    int currentSegment(FT_Pos* coords);
};

#endif