/* monitor.h
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of Mysaifu JVM

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.
*/

#ifndef MONITOR_H_INCLUDED
#define	MONITOR_H_INCLUDED

#include "types.h"

#define	MONITOR_WAIT_NOT_A_OWNER	0
#define	MONITOR_WAIT_NOTIFIED		1
#define	MONITOR_WAIT_TIMEOUT		2
#define	MONITOR_WAIT_INTERRUPTED	3

/**
 * j^̐ݒ
 * j^֘ȀsOɁAK1ĂяoĂKvB
 *
 */
void init_monitor_settings();

/**
 * IuWFNg̃j^擾
 *
 * @param	objref	擾ΏۂƂȂIuWFNg̎Q
 */
bool monitor_enter(jobject objref);

/**
 * IuWFNgj^
 *
 * @param	objref	ΏۂƂȂIuWFNg̎Q
 * @return	ĂяoXbhj^lĂȂꍇfalseB
 *			ɉłꍇtrue
 */
bool monitor_exit(jobject objref);

/**
 * Object.wait()ɑ鏈sB
 *
 * @param	objref	j^擾ς݂̃IuWFNgւ̎Q
 * @param	timeout	^CAEglBOw肵ꍇɂ̓^CAEgȂB
 * @return	̃\bh烊^[RB
 *			0 - ̃\bhĂяoXbhj^擾ĂȂB
 *			1 - notify()/notifyAll()ĂяoÃXbhs\ԂɂȂ
 *			2 - ^CAEg
 *			3 - ̃XbhɂĊ荞܂ꂽ
 */
int monitor_wait(jobject objref, unsigned int timeout);

/**
 * Object.notify()ɑ鏈sB
 *
 * @param	objref	j^擾ς݂̃IuWFNgւ̎Q
 * @param	all		wait()Ԃ̑SXbhɒʒmꍇtruew肷B
 * @return	ɏꍇtrueB
 *			̊֐ĂяoXbhj^擾ĂȂꍇfalseB
 */
bool monitor_notify(jobject objref, bool all);

/**
 * w肳ꂽIuWFNgɊ֘Atꂽj^j
 * Kx[WRN^́AIuWFNgƂɂ̃\bhĂяoA
 * j^֘Ã
 *
 * @param	objref	IuWFNg
 */
void delete_monitor(jobject objref);

/**
 * ݂̃Xbhw肳ꂽIuWFNg̃j^ۗLĂ邩Ԃ
 */
bool is_monitor_owner(jobject objref);

typedef struct monitor_t monitor;

#endif
