/* WCETextComponentPeer.java
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package gnu.java.awt.peer.wce;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.event.TextEvent;
import java.awt.im.InputMethodRequests;
import java.awt.peer.TextComponentPeer;

public abstract class WCETextComponentPeer extends WCEComponentPeer implements TextComponentPeer {
	WCETextComponentPeer(TextComponent textComponent) {
		super(textComponent);
	}
	
	public int getSelectionEnd() {
		return getNativeSelectionEnd(getWindowHandle());
	}
	
	private native int getNativeSelectionEnd(int windowHandle);
	
	public int getSelectionStart() {
		return getNativeSelectionStart(getWindowHandle());
	}
	
	private native int getNativeSelectionStart(int windowHandle);
	
	public String getText() {
		return getNativeText(getWindowHandle());
	}
	
	public void setText(String text) {
		setNativeText(getWindowHandle(), convertNewLine(text));
	}
	
	public void select(int start_pos, int end_pos) {
		selectNative(getWindowHandle(), start_pos, end_pos);
	}
	
	private native void selectNative(int windowHandle, int startPos, int endPos);
	
	public void setEditable(boolean editable) {
		setNativeEditable(getWindowHandle(), editable);
	}
	
	private native void setNativeEditable(int windowHandle, boolean editable);

	public int getCaretPosition() {
		return getNativeCaretPosition(getWindowHandle());
	}
	
	private native int getNativeCaretPosition(int windowHandle);
	
	public void setCaretPosition(int pos) {
		setNativeCaretPosition(getWindowHandle(), pos);
	}
	
	private native void setNativeCaretPosition(int windowHandle, int pos);
	
	public int getIndexAtPoint(int x, int y) {
		return getNativeIndexAtPoint(getWindowHandle(), x, y);
	}
	
	private native int getNativeIndexAtPoint(int windowHandle, int x, int y);
	
	public Rectangle getCharacterBounds(int pos) {
		// return getNativeCharacterBounds(getWindowHandle(), pos);
		throw new UnsupportedOperationException("Not implemented");
	}
	
	private native Rectangle getNativeCharacterBounds(int windowHandle, int pos);
	
	public long filterEvents(long filter) {
		// Ȃ
		return filter;
	}

	protected void postTextEvent(int id) {
		queue.postEvent(new TextEvent(getComponent(), id));
	}

  public InputMethodRequests getInputMethodRequests()
  {
      // FIXME: implement
	throw new UnsupportedOperationException("Not implemented");
  }
  
  
	@Override
	protected void preDispose(Component c) {
		TextComponent tc = (TextComponent) c;
		
		// eLXg̓eTextComponentɕۑ
		tc.setText(getText());
	}

	/**
	 * nꂽɑ΂Ĉȉ̕ϊs
	 *
	 *  \n -> \r\n
	 *  \r -> \r\n
	 *  LO̕ -> ̂܂
	 *
	 * @param	str	ϊΏۂƂȂ镶
	 * @return	ϊ̕B str ̂̂ԂꍇB
	 */
	protected static String convertNewLine(String str) {
		if (str == null) {
			return null;
		}
		StringBuilder sb = null;
		char prev = (char) 0;
		char c;
		final int len = str.length();
		for (int i = 0; i < len; ++i) {
			c = str.charAt(i);
			if (c == '\n' && prev != '\r') {
				if (sb == null) {
					sb = new StringBuilder(str.substring(0, i));
				}
				sb.append("\r\n");
			} else if (sb != null) {
				sb.append(c);
			}
			prev = c;
		}
		
		if (sb != null) {
			return sb.toString();
		} else {
			return str;
		}
	}

}
