/* gnu_java_awt_peer_wce_WCEChoicePeer.c
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of Mysaifu JVM.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with Mysaifu JVM; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

#include <windows.h>
#include <jni.h>
#include "wce-peer.h"
#include <gnu_java_awt_peer_wce_WCEChoicePeer.h>

/*
 * Class:     gnu_java_awt_peer_wce_WCEChoicePeer
 * Method:    createNative
 * Signature: (IIIII)I
 */
JNIEXPORT jint JNICALL Java_gnu_java_awt_peer_wce_WCEChoicePeer_createNative(JNIEnv *env, jobject peer_obj, jint parentWindowHandle, jint x, jint y, jint width, jint height) {
	peer_obj = (*env)->NewGlobalRef(env, peer_obj);
	if (! peer_obj) {
		throw_AWTError(env, "NewGlobalRef() failed.");
		return 0;
	}
	return (jint) create_native_choice(peer_obj, (HWND) parentWindowHandle, x, y, width, height);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEChoicePeer
 * Method:    addNative
 * Signature: (ILjava/lang/String;I)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEChoicePeer_addNative(JNIEnv *env, jobject peer_obj, jint windowHandle, jstring item, jint index) {
	_TCHAR* buff = get_string_chars(env, item);
	if (buff) {
		SendMessage((HWND) windowHandle, CB_INSERTSTRING, (WPARAM) index, (LPARAM) buff);
	}
	free(buff);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEChoicePeer
 * Method:    removeNative
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEChoicePeer_removeNative(JNIEnv *env, jobject peer_obj, jint windowHandle, jint index) {
	SendMessage((HWND) windowHandle, CB_DELETESTRING, (WPARAM) index, 0);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEChoicePeer
 * Method:    removeNativeAll
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEChoicePeer_removeNativeAll(JNIEnv *env, jobject peer_obj, jint windowHandle) {
	SendMessage((HWND) windowHandle, CB_RESETCONTENT, 0, 0);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEChoicePeer
 * Method:    selectNative
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEChoicePeer_selectNative(JNIEnv *env, jobject peer_obj, jint windowHandle, jint index) {
	SendMessage((HWND) windowHandle, CB_SETCURSEL, (WPARAM) index, 0);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEChoicePeer
 * Method:    getNativePreferredSize
 * Signature: (I)Ljava/awt/Dimension;
 */
JNIEXPORT jobject JNICALL Java_gnu_java_awt_peer_wce_WCEChoicePeer_getNativePreferredSize(JNIEnv *env, jobject peer_obj, jint windowHandle) {
	jclass clazz;
	jmethodID constructor_id;
	jobject dim;
	int cx_vscroll, cy_vscroll, width, height;

	// VXe擾
	cx_vscroll = GetSystemMetrics(SM_CXVSCROLL);
	cy_vscroll = GetSystemMetrics(SM_CYVSCROLL);
	
	width = cx_vscroll * 6 + GetSystemMetrics(SM_CXBORDER);	// XN[o[̉*5 + [̋E
	height = cy_vscroll;									// XN[o[̍Ɠ

	clazz = (*env)->FindClass(env, "java/awt/Dimension");
	if (! clazz) {
		throw_AWTError(env, "Failed to load java.awt.Dimension");
		return NULL;
	}
	constructor_id = (*env)->GetMethodID(env, clazz, "<init>", "(II)V");
	if (! constructor_id) {
		throw_AWTError(env, "Failed to get method id of constructor");
		return NULL;
	}
	dim = (*env)->NewObject(env,
							clazz,
							constructor_id,
							width,
							height);
	return dim;
}
