#ifndef FREETYPEGLYPHVECTOR_H_INCLUDED
#define FREETYPEGLYPHVECTOR_H_INCLUDED

#include <ft2build.h>
#include FT_FREETYPE_H 
#include FT_OUTLINE_H 
#include FT_BITMAP_H
#include <windows.h>


class FreeTypeGlyphVector
{
private:
    FT_Library library;
    _TCHAR* text;

    FT_Size_Metrics sizeMetrics;
    FT_Pos x, y, width, height;

    struct Glyph {
	FT_Vector position;
	FT_Vector advance;

	FT_Bitmap bitmap;
	FT_Int bitmapLeft;
	FT_Int bitmapTop;

	FT_Outline outline;
    };

    Glyph* glyphs;
    
    void disposeGlyph(int index);
    void disposeAllGlyphs();

    void updateLogicalBounds();

public:
    FreeTypeGlyphVector(FT_Face face, const _TCHAR* text);
    ~FreeTypeGlyphVector();
    
    /**
     * Assigns default positions to each glyph in this GlyphVector.
     */
    void performDefaultLayout(FT_Face face);
    
    /**
     * Returns the logical bounds of this GlyphVector.
     *
     * @param	x	the logical bounds of this GlyphVector
     * @param	y	the logical bounds of this GlyphVector
     * @param	width	the logical bounds of this GlyphVector
     * @param	height	the logical bounds of this GlyphVector
     */
    void getLogicalBounds(FT_Pos* x, FT_Pos* y, FT_Pos* width, FT_Pos* height) const;

    /**
     * Returns the visual bounds of this GlyphVector.
     *
     * @param	x	the visual bounds of this GlyphVector
     * @param	y	the visual bounds of this GlyphVector
     * @param	width	the visual bounds of this GlyphVector
     * @param	height	the visual bounds of this GlyphVector
     */
    void getVisualBounds(FT_Pos* x, FT_Pos* y, FT_Pos* width, FT_Pos* height) const;

    /**
     * Returns the logical bounds of the specified glyph within this GlyphVector.
     *
     */
    void getGlyphLogicalBounds(int glyphIndex, FT_Vector* p1, FT_Vector* p2, FT_Vector* p3, FT_Vector* p4) const;

    /**
     * Returns the visual bounds of the specified glyph within this GlyphVector.
     *
     */
    void getGlyphVisualBounds(int glyphIndex, FT_Vector* p1, FT_Vector* p2, FT_Vector* p3, FT_Vector* p4) const;

    /**
     * Returns the number of glyphs in this GlyphVector
     *
     * @return	number of glyphs in this GlyphVector.
     */
    inline int getNumGlyphs() const 
    {
	return _tcslen(text);
    }

    /**
     * w肳ꂽCfbNXʒuɂOt̕\ʒuԂ
     */
    inline const FT_Vector& getGlyphPosition(int index) const
    {
	return this->glyphs[index].position;
    }

    /**
     * w肳ꂽCfbNXʒuɂOt̕\ʒuݒ肷
     */
    inline const void setGlyphPosition(int index, FT_Vector& pos)
    {
	this->glyphs[index].position = pos;
    }

    inline const FT_Bitmap& getBitmap(int index) const
    {
	return this->glyphs[index].bitmap;
    }

    inline FT_Int getBitmapLeft(int index) const
    {
	return this->glyphs[index].bitmapLeft;
    }

    inline FT_Int getBitmapTop(int index) const
    {
	return this->glyphs[index].bitmapTop;
    }
    
    /**
     * w肳ꂽʒuFT_OutlineԂ
     */
    FT_Outline& getOutline(int index) const
    {
	return this->glyphs[index].outline;
    }

    inline FT_Library getLibrary() const
    {
	return this->library;
    }

    /**
     * creates a new native bitmap mask to draw this GlyphVector.
     *
     * @param index	glyph index in this GlyphVector
     * @return	a bitmap handle.
     */
    HBITMAP createBitmapMask(int index);

    bool equals(FreeTypeGlyphVector* gv);
};

#endif