/* WCEToolkit.java
   Copyright (C) 2005, 2006 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package gnu.java.awt.peer.wce;

import gnu.classpath.Configuration;
import gnu.java.awt.ClasspathToolkit;
import gnu.java.awt.EmbeddedWindow;
import gnu.java.awt.font.FontFactory;
import gnu.java.awt.peer.ClasspathFontPeer;
import gnu.java.awt.peer.EmbeddedWindowPeer;
import gnu.java.awt.peer.wce.font.WCEFontPeer;
import gnu.java.awt.peer.wce.font.WCEFontMetrics;
import gnu.java.awt.peer.wce.font.FreeTypeFace;
import java.awt.*;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.*;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.im.*;
import java.awt.image.*;
import java.awt.peer.*;
import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class WCEToolkit extends ClasspathToolkit implements Runnable {

    /**
     * ^Cgo[tO̒萔
     * @see	#getFloatingFlags()
     */
    public static final int FRAME_IS_FLOATING	= 1;
    public static final int DIALOG_IS_FLOATING	= 2;

    private static int floatingFlags;
	
    /**
     * ^bvz[h𖳌ɂ
     */
    private static boolean tapAndHoldDisabled;
	
    static {
	if (Configuration.INIT_LOAD_LIBRARY) {
	    System.loadLibrary("wcepeer");
	}
		
	// tOݒ肷
	StringTokenizer st
	    = new StringTokenizer(
			    System.getProperties().getProperty("gnu.java.awt.peer.wce.floating", ""),
			",");
	while (st.hasMoreTokens()) {
		String value = st.nextToken().trim();
		if ("frame".equalsIgnoreCase(value)) {
			floatingFlags |= FRAME_IS_FLOATING;
		} else if ("dialog".equalsIgnoreCase(value)) {
			floatingFlags |= DIALOG_IS_FLOATING;
		}
	}
		
        tapAndHoldDisabled = Boolean.getBoolean("gnu.java.awt.peer.wce.disableTapAndHold");
    }
	
	
    /**
     * VXeCxgL[
     */
    static final EventQueue queue = new EventQueue();
	
    /**
     * tOBlCeBuXV
     */
    private static boolean initialized;
	
    /**
     * VXeJ[LbV
     */
    int[] systemColorsCache;
	

    private class LRUCache extends LinkedHashMap {
	int max_entries;
	public LRUCache(int max) {
	    super(max, 0.75f, true);
	    max_entries = max;
	}
	protected boolean removeEldestEntry(Map.Entry eldest) {
	    return size() > max_entries;
	}
    }

    private LRUCache imageCache = new LRUCache(50);

    private static native void init();
	
    public WCEToolkit() {
	init();
	// OSbZ[WMJn
	new Thread(this).start();
	synchronized (WCEToolkit.class) {
	    while (! initialized) {
		// ̂҂
		try {
		    WCEToolkit.class.wait();
		} catch (InterruptedException ie) {
		    ie.printStackTrace();
		}
	    }
	}
    }

    /**
     * r[v𔭐
     */
    public native void beep();

	public int checkImage (Image image, int width, int height, ImageObserver observer) {
		if (image instanceof WCEImage) {
			// ToDo: width  height l
			return ((WCEImage) image).checkImage(observer);
		} else if (image instanceof BufferedImage) {
			// BufferedImage͏ɕ`\
			return ImageObserver.ALLBITS | ImageObserver.HEIGHT | ImageObserver.WIDTH;
		} else {
			throw new AWTError("Unsupported image:" + image);
		}
	}

	public Image getImage (String filename) {
		try {
			File file = new File(filename);
			return getImage(file.toURL());
		} catch (MalformedURLException muex) {
			throw (IllegalArgumentException) new IllegalArgumentException(filename).initCause(muex);
		}
	}

	public Image getImage (URL url) {
		if (imageCache.containsKey(url)) {
			return (Image) imageCache.get(url);
		} else {
			Image im = createImage(url);
		    imageCache.put(url, im);
			return im;
		}
	}

	public Image createImage(String path) {
		try {
			return createImage(new File(path).toURL());
		} catch (MalformedURLException muex) {
			throw (IllegalArgumentException) new IllegalArgumentException(path).initCause(muex);
		}
	}

	public Image createImage (URL url) {
		return new WCEURLImage(url);
	}
	
	public Image createImage (ImageProducer producer) {
		if (producer instanceof WCEImageProducer) {
			// ɂȂC[W{̂Ԃ
			return ((WCEImageProducer) producer).getImage();
		} else {
			// WCEMemoryImagẽCX^X쐬
			WCEMemoryImage image = new WCEMemoryImage(producer);
			return image;
		}
	}
	
	public Image createImage (byte[] imagedata, int imageoffset, int imagelength) {
		// e|t@CɏoāAWCEURLImage()NXƂēn
		// ToDo:̃f[^̂܂܏ł悤ɂ
		WCEURLImage image = null;
		File file = null;
		try {
			file = File.createTempFile("AWT", null);
			
			OutputStream os = new BufferedOutputStream(new FileOutputStream(file));
			os.write(imagedata, imageoffset, imagelength);
			os.close();
			
			image = new WCEURLImage(file.toURL());
			
			// C[W̃[h҂
			MediaTracker mt = new MediaTracker(new Component() {});
			mt.addImage(image, 0);
			mt.waitForAll();

		} catch (IOException ioe) {
			ioe.printStackTrace();
		} catch (InterruptedException ie) {
			ie.printStackTrace();
		} finally {
			if (file != null) {
				file.delete();
			}
		}
		return image;
	}
	
	public ImageProducer createImageProducer(URL url) {
		throw new UnsupportedOperationException("Not implemented");
	}
  
	public ColorModel getColorModel () {
		return ColorModel.getRGBdefault ();
	}

	public String[] getFontList () {
	    return (new String[] { "Dialog", 
				   "DialogInput", 
				   "Monospaced", 
				   "Serif", 
				   "SansSerif" });
	}

	public FontMetrics getFontMetrics (Font font)  {
		return new WCEFontMetrics(font);
	}
	
	public PrintJob getPrintJob (Frame frame, String jobtitle, Properties props) {
		throw new UnsupportedOperationException("Not implemented");
	}
	
	/**
	 * ʂ̉𑜓xiDPI)ԂB
	 */
	public native int getScreenResolution();
	
	/**
	 * ʂ̃TCYsNZPʂŕԂ
	 */
	public Dimension getScreenSize () {
		Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
		return new Dimension(bounds.width, bounds.height);
	}
	
	/**
	 * VXeNbv{[hԂ
	 */
	public Clipboard getSystemClipboard() {
		return new WCEClipboard();
	}

	public boolean prepareImage (Image image, int width, int height, ImageObserver observer) {
		if (image instanceof WCEImage) {
			// ToDo: width  height l
			WCEImage wimg = (WCEImage) image;
			boolean result = (wimg.getFlags() & ImageObserver.ALLBITS) != 0;
			if (! result) {
				// rbg}bvnh̎擾́AC[WN
				wimg.getBitmapHandle();
			}
			return result;
		} else if (image instanceof BufferedImage) {
			// BufferedImage͏ɕ`\
			return true;
			
		} else {
			// ̑̃C[W̏ꍇ̓G[
			throw new AWTError("Unsupported image:" + image);
		}
	}
	
 	public void sync () {
	}

	protected ButtonPeer createButton (Button b) {
		return new WCEButtonPeer(b);
	}

	protected CanvasPeer createCanvas (Canvas c) {
		return new WCECanvasPeer(c);
	}
	
	protected CheckboxPeer createCheckbox (Checkbox cb) {
		return new WCECheckboxPeer(cb);
	}
	
	protected CheckboxMenuItemPeer createCheckboxMenuItem (CheckboxMenuItem cmi) {
		return new WCECheckboxMenuItemPeer(cmi);
	}
 	
 	protected ChoicePeer createChoice (Choice c) {
		return new WCEChoicePeer(c);
	}

	protected DialogPeer createDialog (Dialog d) {
		return new WCEDialogPeer(d);
	}

	protected FileDialogPeer createFileDialog (FileDialog fd) {
		return new WCEFileDialogPeer(fd);
	}

	protected FramePeer createFrame (Frame f) {
		return new WCEFramePeer(f);
	}

	protected LabelPeer createLabel (Label label) {
		return new WCELabelPeer(label);
	}

	protected ListPeer createList (java.awt.List list) {
		return new WCEListPeer(list);
	}

	protected MenuPeer createMenu (Menu m) {
		return new WCEMenuPeer(m);
	}

	protected MenuBarPeer createMenuBar (MenuBar mb) {
		return new WCEMenuBarPeer(mb);
	}

	protected MenuItemPeer createMenuItem (MenuItem mi) {
		return new WCEMenuItemPeer(mi);
	}
	
	protected PanelPeer createPanel (Panel p) {
		return new WCEPanelPeer(p);
	}

	protected PopupMenuPeer createPopupMenu (PopupMenu target) {
		return new WCEPopupMenuPeer(target);
	}

	protected ScrollPanePeer createScrollPane (ScrollPane sp) {
		return new WCEScrollPanePeer(sp);
	}

	protected ScrollbarPeer createScrollbar (Scrollbar sb) {
		return new WCEScrollbarPeer(sb);
	}

	protected TextAreaPeer createTextArea (TextArea ta) {
		return new WCETextAreaPeer(ta);
	}

	protected TextFieldPeer createTextField (TextField tf) {
		return new WCETextFieldPeer(tf);
	}

	protected WindowPeer createWindow (Window w) {
		return new WCEWindowPeer(w);
	}

  /** 
   * @deprecated part of the older "logical font" system in earlier AWT
   * implementations. Our newer Font class uses getClasspathFontPeer.
   */

    protected FontPeer getFontPeer (String name, int style) {
	return new WCEFontPeer(name, style, 1);
    }

    public ClasspathFontPeer getClasspathFontPeer (String name, Map attrs) {
	return new WCEFontPeer(name, attrs);
    }

    protected EventQueue getSystemEventQueueImpl() {
	return queue;
    }
	
	private native void loadNativeSystemColors(int[] systemColors);
	
	protected void loadSystemColors (int[] systemColors) {
		if (this.systemColorsCache != systemColors) {
			// Ăяoint[]̓eύXȂƂOɂĂ
			// (GNU ClasspathSystemColorύXꂽ_
			//  ̎Kvj
			loadNativeSystemColors(systemColors);
			this.systemColorsCache = systemColors;
		}
	}

	public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent e) {
		throw new UnsupportedOperationException("Not implemented");
	}

	public Map mapInputMethodHighlight(InputMethodHighlight highlight) {
		throw new UnsupportedOperationException("Not implemented");
	}

  // ClasspathToolkit methods

    public GraphicsEnvironment getLocalGraphicsEnvironment() {
	return new WCEGraphicsEnvironment();
    }
	
    public Font createFont(int format, InputStream stream)
    {
	if (format != Font.TRUETYPE_FONT)
	{
	    throw new IllegalArgumentException("format=" + format);
	}
	Font result = null;
	try {
	    if (! (stream instanceof BufferedInputStream))
	    {
		stream = new BufferedInputStream(stream);
	    }
	    Map map = new HashMap();
	    map.put(TextAttribute.SIZE, new Float(1));
	    map.put(WCEFontPeer.FREE_TYPE_FACE_KEY, new FreeTypeFace(stream));
	    result = new Font(map);
	    stream.close();
	}
	catch (IOException ioe)
	{
	    ioe.printStackTrace();
	}
	catch (FontFormatException ffe)
	{
	    ffe.printStackTrace();
	}
	return result;
    }

    public Font createFont(int format, File file) throws IOException, FontFormatException
    {
	if (format != Font.TRUETYPE_FONT)
	{
	    throw new IllegalArgumentException("format=" + format);
	}
	Font result = null;
	// Create a font from file.
	Map map = new HashMap();
	map.put(TextAttribute.SIZE, new Float(1));
	map.put(WCEFontPeer.FREE_TYPE_FACE_KEY, new FreeTypeFace(file));
	result = new Font(map);
	return result;
    }

	public RobotPeer createRobot (GraphicsDevice screen) throws AWTException {
		throw new UnsupportedOperationException("Not implemented");
	}
	
	/**
	 * WindowsbZ[WMs
	 */
	public native void run();
	
	/**
	 * Windows̃bZ[W(run()Ăяoj
	 */
	private native void handleNativeMessage(int hwnd, int msg, int wparam, int lparam);
	
	/**
	 * Frame/Dialogut[eBOvł邩Ԃ
	 */
	public static int getFloatingFlags() {
		return floatingFlags;
	}
	
	/**
	 * ^bvz[h𖳌邩Ԃ
	 */
	public static boolean isTapAndHoldDisabled() {
		return tapAndHoldDisabled;
	}

  /**
   * Creates an embedded window peer, and associates it with an
   * EmbeddedWindow object.
   *
   * @param w The embedded window with which to associate a peer.
   */
	public EmbeddedWindowPeer createEmbeddedWindow(EmbeddedWindow w) {
		// EmbeddedWindowƂ͉H
		throw new UnsupportedOperationException("Not implemented");
	}

  @Override
  public boolean isModalExclusionTypeSupported
  (Dialog.ModalExclusionType modalExclusionType)
  {
    return false;
  }

  @Override
  public boolean isModalityTypeSupported(Dialog.ModalityType modalityType)
  {
    return false;
  }


	@Override
	protected DesktopPeer createDesktopPeer(Desktop target) throws HeadlessException {
		if (GraphicsEnvironment.isHeadless())
			throw new HeadlessException();
		return WCEDesktopPeer.getDesktopPeer();
	}
	
}
