#include <pthread.h>
#include <windows.h>
#include <assert.h>
#include <errno.h>

int pthread_once (pthread_once_t *once_control, void (*init_routine)(void)) {
	if (PTHREAD_ONCE_INIT == InterlockedCompareExchange(once_control, ~PTHREAD_ONCE_INIT, PTHREAD_ONCE_INIT)) {
		// P񂾂s
		init_routine();
	}
	// 0Ԃ
	return 0;
}

int pthread_key_create(pthread_key_t *key, void (*destr_function) (void *)) {
	DWORD index = TlsAlloc();
	
	if (destr_function != NULL) {	// T|[gĂȂ
		errno = EINVAL;
		return -1;
	}

	if (index == (DWORD) -1) {
		errno = EAGAIN;
		return -1;
	}
	return 0;
}

int pthread_setspecific(pthread_key_t key, const void *pointer) {
	if (! TlsSetValue(key, (LPVOID) pointer)) {
		errno = EINVAL;
		return -1;
	}
	return 0;
}

void * pthread_getspecific(pthread_key_t key) {
	return TlsGetValue(key);
}
	