#ifndef FCNTL_H_INCLUDED
#define FCNTL_H_INCLUDED

#define	O_RDONLY 0
#define	O_WRONLY 1
#define	O_RDWR	 2
#define	O_NDELAY 04	/* Non-blocking I/O */
#define	O_APPEND 010	/* append (writes guaranteed at the end) */
#define	O_SYNC	 020	/* synchronous write option */
#define	O_NONBLOCK 0200 /* Non-blocking I/O (POSIX) */
#define	O_PRIV 010000   /* Private access to file */

#define	O_CREAT	00400	/* open with file create (uses third open arg) */
#define	O_TRUNC	01000	/* open with truncation */
#define	O_EXCL	02000	/* exclusive open */
#define	O_NOCTTY 04000	/* don't allocate controlling tty (POSIX) */

extern int open(const char *, int, ...);

#endif
