package gnu.javax.sound.sampled.wce;


import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.swing.event.EventListenerList;

/**
 * LineC^tF[XNX̊NXB
 */
public abstract class WCELine implements Line {
	/**
	 * I[vĂ邩
	 */
	private boolean openFlag;
	
	/**
	 * CxgXi[
	 */
	private final EventListenerList eventListeners = new EventListenerList();
	
	/**
	 * Linȅ
	 */
	private final Line.Info lineInfo;
	
	protected WCELine(Line.Info info) {
		this.lineInfo = info;
	}
	
	public void open() throws LineUnavailableException {
		this.openFlag = true;
	}
	
	public void close() {
		this.openFlag = false;
	}
	
	public boolean isOpen() {
		return this.openFlag;
	}

	public void addLineListener(LineListener listener) {
		this.eventListeners.add(LineListener.class, listener);
	}
	
	public void removeLineListener(LineListener listener) {
		this.eventListeners.remove(LineListener.class, listener);
	}

	/**
	 * CxgLineListenerɒʒm
	 */
	void notifyLineEvent(LineEvent event) {
		Object[] listeners = this.eventListeners.getListenerList();
		for (int i = listeners.length - 2; i >= 0; i -= 2) {
			if (listeners[i] == LineEvent.class) {
				((LineListener) listeners[i + 1]).update(event);
			}
		}
     }

	/**
	 * Linȅ
	 */
	public Line.Info getLineInfo() {
		return this.lineInfo;
	}
}
