/* arguments.h
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of Mysaifu JVM

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.
*/

#ifndef ARGUMENTS_H_INCLUDED
#define ARGUMENTS_H_INCLUDED

/**
 * VXevpeB
 */
struct property {
	_TCHAR key[256];
	_TCHAR value[256];
};

/**
 * xt@C[h
 */
enum VerifyMode {
	/**
	 * xt@CȂ
	 */
	VERIFY_MODE_NONE,

	/**
	 * xt@C
	 */
	VERIFY_MODE_ALL,
};


/**
 * JVMN̈
 */
struct arguments {
	/**
	 * NXpX
	 */
	// _TCHAR classpath[256];
	// NXpXTCY͉ςƂ(Bug #12863)
	_TCHAR* classpath;
	
	/**
	 * u[gNXpX
	 */
	_TCHAR boot_classpath[256];

	union {
		/**
		 * sNX
		 */
		_TCHAR class_name[256];

		/**
		 * jart@C
		 */
		_TCHAR jar_file_name[MAX_PATH + 1];
	};

	/**
	 * őq[vTCYioCg)
	 */
	int max_heap_size;

	/**
	 * JavaX^bNTCYioCgPʁj
	 */
	int java_stack_size;

	/**
	 * lCeBuX^bNTCYioCgPʁj
	 */
	int native_stack_size;

	/**
	 * R}hC
	 */
	_TCHAR* argv;

	/**
	 * -verbose:gc IvV
	 */
	bool verbose_gc;

	/**
	 * -verbose:class
	 */
	bool verbose_class;

	/**
	 * -verbose:jni
	 */
	bool verbose_jni;

	/**
	 * -Xloggc:IvVŎw肳ꂽt@C
	 */
	_TCHAR loggc[256];

	/**
	 * assertionLɂ邩
	 */
	bool enableAssertions;

	/**
	 * NɃR\[EChEI[v邩
	 */
	bool show_console;

	/**
	 * NVM̃_CAO\ɂ
	 */
	bool hide_vm_window;

	/**
	 * Wo͂gp邩
	 */
	bool use_stdio;

	/**
	 * R\[Ot@C
	 */
	_TCHAR	logfile[MAX_PATH + 1];
	
	/**
	 * -jar IvV
	 */
	bool jar;

	/**
	 * VXevpeB
	 */
	int properties_count;

	/**
	 * VXevpeB
	 */
	property* properties;

	/**
	 * xt@CIvV
	 *
	 * 0 - xt@CȂ(-noverify)
	 * 2 - NX[_ɂă[hꂽNXxt@Ci-verifyremote)
	 * 3 - SẴNXxt@Ci-verify)
	 */
	VerifyMode verify_mode;

	/**
	 * JgfBNg
	 */
	_TCHAR current_directory[MAX_PATH];

	/**
	 * gpʂ\邩
	 */
	bool show_current_heap_usage; 
};

/**
 * ɊւԂ
 */
void init_arguments_settings();

/**
 * 쐬
 */
arguments* arguments_create();

/**
 * Ɋ蓖Ăꂽ폜
 */
void arguments_delete(arguments* args);

/**
 * w肳ꂽɁA𐶐
 */
arguments* arguments_load(const _TCHAR* params);

/**
 * w肳ꂽobt@ɁA𕶎ɕϊāAw肳ꂽt@Cɏo͂
 */
int arguments_store(arguments* args, FILE* file);

/**
 * vpeBݒ肷
 */
void arguments_put_property(arguments* args, const _TCHAR* key, const _TCHAR* value);

/**
 * ׂẴvpeBNA
 */
void arguments_clear_all_properties(arguments* args);

/**
 * vpeB̃L[Ԃ
 */
const _TCHAR* arguments_get_property_key(arguments* args, int index);

/**
 * w肳ꂽL[ɑΉvpeBlԂ
 */
const _TCHAR* arguments_get_property(arguments* args, const _TCHAR* key);

#endif