/* uio.c
   Copyright (C) 2006 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

#include <windows.h>
#include <errno.h>

/**
 * TLSCfbNXl
 */
static DWORD g_tls_index = 0xffffffff;

extern void init_stdio_handles();

/**
 * errnoϐ̎̂TLSɒǉ
 * łɑ݂ꍇɂ͉Ƀ^[
 */
static void add_errno_body() {
	if (! TlsGetValue(g_tls_index)) {
		// ܂ݒ肳ĂȂꍇ̂ݏs
		int* errno_body = (int*) malloc(sizeof(int));
		TlsSetValue(g_tls_index, errno_body);
	}
}

/**
 * errnoϐ̎̂폜
 */
static void remove_errno_body() {
	int* errno_body = (int*) TlsGetValue(g_tls_index);
	free(errno_body);
}

BOOL WINAPI DllMain(
					  HINSTANCE hinstDLL,  // DLL W[̃nh
					  DWORD fdwReason,     // ֐ĂяoR
					  LPVOID lpvReserved   // \ς
)
{
	switch (fdwReason) {
	case DLL_PROCESS_ATTACH:
		// vZXA^b`ꂽ
		// Xbh[J̈mۂ
		g_tls_index = TlsAlloc();
		if (g_tls_index == 0xffffffff) {
			// Xbh[J̈̊mۂɎs
			return FALSE;
		}

		break;
	
	case DLL_PROCESS_DETACH:
		// vZXf^b`ꂽ
		remove_errno_body();
		// Xbh[J̈J
		TlsFree(g_tls_index);
		break;

	case DLL_THREAD_ATTACH:
		// XbhA^b`ꂽ
		break;

	case DLL_THREAD_DETACH:
		// Xbhf^b`ꂽ
		remove_errno_body();
		break;
	}
	return TRUE;
}

/**
 * ϐ errno ̂̃AhXԂ֐
 */
int* WCEGetErrnoAddress() {
	add_errno_body();
	return (int*) TlsGetValue(g_tls_index);
}