﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Diagnostics;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;

namespace Musitters
{
    public partial class Form2 : Form
    {
        public Form2()
        {
            InitializeComponent();

            if (!string.IsNullOrEmpty(RegistrySettings.AccessToken))
            {
                TwitterUser tu = new TwitterUser(RegistrySettings.ConsumerKey, RegistrySettings.ConsumerSecret,
                                       RegistrySettings.AccessToken, RegistrySettings.AccessTokenSecret,
                                       RegistrySettings.UserId, RegistrySettings.ScreenName);
                this.label3.Text = tu.name + " @" + RegistrySettings.ScreenName;
                this.button3.Text = "認証解除(&A)";
            }
            if (!string.IsNullOrEmpty(RegistrySettings.MusicFolderPath))
            {
                string mfp = RegistrySettings.MusicFolderPath;
                this.textBox1.Text = mfp;

            }

            listView1.View = View.Details;
            listView1.Columns.Add("タイトル");
            listView1.Columns.Add("参加アーティスト");
            listView1.Columns.Add("アルバム");

            if (0 < RegistrySettings.ColumnsWidth.Length)
            {
                string[] columnsWidth = RegistrySettings.ColumnsWidth;
                for (int i = 0; i < columnsWidth.Count(); i++)
                {
                    listView1.Columns[i].Width = int.Parse(columnsWidth[i]);
                }
            }
            else
            {
                listView1.AutoResizeColumns(ColumnHeaderAutoResizeStyle.HeaderSize);
            }

            if (0 < RegistrySettings.MusicList.Length)
            {
                string[] m = RegistrySettings.MusicList;
                for (int i = 0; i < m.Length; i++)
                {
                    if (System.IO.File.Exists(m[i]))
                    {
                        var mf = new MusicFile(m[i]);
                        string[] row_1 = { mf.Title, mf.Artist, mf.Album };
                        listView1.Items.Add(new ListViewItem(row_1));
                    }
                }

            }

            int mfs = RegistrySettings.MusicFileSettings;
            if (mfs == 0)
            {
                radioButton1.Checked = true;
                textBox1.Enabled = true;
                button1.Enabled = true;
                button2.Enabled = false;
                button4.Enabled = false;
                listView1.Enabled = false;
            }
            else
            {
                radioButton2.Checked = true;
                textBox1.Enabled = false;
                button1.Enabled = false;
                button2.Enabled = true;
                button4.Enabled = true;
                listView1.Enabled = true;
            }

            if (99 < RegistrySettings.Level)
            {
                checkBox1.Enabled = true;
            }

            int eyu = RegistrySettings.EnableYoutubeUrl;
            checkBox1.Checked = (eyu == 0) ? false : true;
        }

        //Form1オブジェクトを保持するためのフィールド
        private static Form2 _form2Instance;

        //Form1オブジェクトを取得、設定するためのプロパティ
        public static Form2 Form2Instance
        {
            get
            {
                if (_form2Instance == null || _form2Instance.IsDisposed)
                    _form2Instance = new Form2();
                return _form2Instance;
            }
        }

        private WMPLib.WindowsMediaPlayer wmp = new WMPLib.WindowsMediaPlayer();

        private void button3_Click(object sender, EventArgs e)
        {

            if (string.IsNullOrEmpty(RegistrySettings.AccessToken))
            {
                Form3 form = new Form3();
                form.Show();
            }
            else
            {
                button3.Text = "認証する(&A)...";
                RegistrySettings.AccessToken = "";
                RegistrySettings.AccessTokenSecret = "";
                RegistrySettings.UserId = "";
                RegistrySettings.ScreenName = "";
                RegistrySettings.Level = 1;
                RegistrySettings.Save();
                Form1 form1 = Form1.Form1Instance;
                form1.wmp.controls.stop();
                form1.再生ToolStripMenuItem.Visible = true;
                form1.一時停止ToolStripMenuItem.Visible = false;
                form1.NowPlayTimes = 0;
                label3.Text = "";
            }

        }

        private void button1_Click(object sender, EventArgs e)
        {
            //FolderBrowserDialogクラスのインスタンスを作成
            FolderBrowserDialog fbd = new FolderBrowserDialog();
            fbd.SelectedPath = "shell:MusicLibrary";
            //上部に表示する説明テキストを指定する
            fbd.Description = "音楽フォルダを指定してください。";
            //ルートフォルダを指定する
            //デフォルトでDesktop
            if (!string.IsNullOrEmpty(RegistrySettings.MusicFolderPath))
            {
                fbd.SelectedPath = RegistrySettings.MusicFolderPath;
            }
            else
            {
                fbd.RootFolder = Environment.SpecialFolder.Desktop;
            }
            //最初に選択するフォルダを指定する
            //RootFolder以下にあるフォルダである必要がある
            //fbd.SelectedPath = @"C:\";
            //ユーザーが新しいフォルダを作成できるようにする
            //デフォルトでTrue
            fbd.ShowNewFolderButton = true;

            //ダイアログを表示する
            if (fbd.ShowDialog(this) == DialogResult.OK)
            {
                try
                {
                    ArrayList al = new ArrayList();
                    this.GetAllFiles(fbd.SelectedPath, "*.mp3", ref al);
                    this.GetAllFiles(fbd.SelectedPath, "*.wav", ref al);
                    this.GetAllFiles(fbd.SelectedPath, "*.wma", ref al);
                    this.GetAllFiles(fbd.SelectedPath, "*.3gp", ref al);
                    this.GetAllFiles(fbd.SelectedPath, "*.aac", ref al);

                    if (al.Count == 0)
                    {
                        MessageBox.Show("選択したフォルダに音楽ファイルが見つかりませんでした。別のフォルダを選択してください。");
                    }
                    else
                    {
                        Form1.Form1Instance.musicFileList = al;
                        //選択されたフォルダを表示する
                        RegistrySettings.MusicFolderPath = fbd.SelectedPath;
                        RegistrySettings.Save();
                        this.textBox1.Text = fbd.SelectedPath;
                        Form1.Form1Instance.再生ToolStripMenuItem.Enabled = true;
                    }

                }
                catch (UnauthorizedAccessException ex)
                {
                    MessageBox.Show("フォルダのアクセスが拒否されました。別のフォルダを選択してください。");
                }
            }

        }

        private void GetAllFiles(
            string folder, string searchPattern, ref ArrayList files)
        {
            //folderにあるファイルを取得する
            try
            {
                string[] fs =
                    System.IO.Directory.GetFiles(folder, searchPattern);
                //ArrayListに追加する
                files.AddRange(fs);
            }
            catch (DirectoryNotFoundException ex)
            {
                return;
            }

            //folderのサブフォルダを取得する
            string[] ds = System.IO.Directory.GetDirectories(folder);
            //サブフォルダにあるファイルも調べる
            foreach (string d in ds)
                GetAllFiles(d, searchPattern, ref files);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void button2_Click_1(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.InitialDirectory = "shell:MusicLibrary";
            ofd.Title = "開く音楽ファイルを選択してください";
            ofd.RestoreDirectory = true;
            ofd.CheckFileExists = true;
            ofd.CheckPathExists = true;

            if (ofd.ShowDialog() == DialogResult.OK)
            {
                var mf = new MusicFile(ofd.FileName);
                string[] row_1 = { mf.Title, mf.Artist, mf.Album };
                listView1.Items.Add(new ListViewItem(row_1));
                string[] ml = RegistrySettings.MusicList;
                if (0 < ml.Length)
                {
                    int nowMusicLength = RegistrySettings.MusicList.Length;
                    string[] musicList = new string[nowMusicLength + 1];
                    Array.Copy(RegistrySettings.MusicList, musicList, RegistrySettings.MusicList.Length);
                    musicList[nowMusicLength] = ofd.FileName;
                    RegistrySettings.MusicList = musicList;
                }
                else
                {
                    ml = new string[] { ofd.FileName };
                    RegistrySettings.MusicList = ml;
                }
                ArrayList al = new ArrayList();
                al.AddRange(RegistrySettings.MusicList);
                Form1.Form1Instance.musicFileList = al;

                RegistrySettings.Save();
            }

        }

        private void button4_Click(object sender, EventArgs e)
        {
            List<string> mList = null;
            if (0 < RegistrySettings.MusicList.Length)
            {
                string[] m = RegistrySettings.MusicList;
                mList = new List<string>(m);
            }

            int indexCnt = listView1.SelectedIndices.Count - 1;

            ArrayList al = new ArrayList();
            if (0 <= indexCnt)
            {
                for (int i = indexCnt; 0 <= i; i--)
                {
                    int si = listView1.SelectedIndices[i];
                    listView1.Items.RemoveAt(si);
                    mList.RemoveAt(si);
                }

                RegistrySettings.MusicList = mList.ToArray();
                RegistrySettings.Save();

                if (0 < RegistrySettings.MusicList.Length)
                {
                    string[] m2 = RegistrySettings.MusicList;
                    al.AddRange(m2);
                }
            }
            Form1.Form1Instance.musicFileList = al;
        }

        private void radioButton2_CheckedChanged(object sender, EventArgs e)
        {
            if (radioButton2.Checked)
            {
                button1.Enabled = false;
                textBox1.Enabled = false;
                button2.Enabled = true;
                button4.Enabled = true;
                listView1.Enabled = true;
                RegistrySettings.MusicFileSettings = 1;
                RegistrySettings.Save();
                if (0 < RegistrySettings.MusicList.Length)
                {
                    string[] m2 = RegistrySettings.MusicList;
                    ArrayList al = new ArrayList();
                    al.AddRange(m2);
                    Form1.Form1Instance.musicFileList = al;
                }
                else
                {
                    ArrayList al = new ArrayList();
                    Form1.Form1Instance.musicFileList = al;
                }
            }
        }

        private void radioButton1_CheckedChanged(object sender, EventArgs e)
        {
            if (radioButton1.Checked)
            {
                button1.Enabled = true;
                textBox1.Enabled = true;
                button2.Enabled = false;
                button4.Enabled = false;
                listView1.Enabled = false;
                RegistrySettings.MusicFileSettings = 0;
                RegistrySettings.Save();
                ArrayList al = new ArrayList();
                if (!string.IsNullOrEmpty(RegistrySettings.MusicFolderPath))
                {
                    this.GetAllFiles(RegistrySettings.MusicFolderPath, "*.mp3", ref al);
                    this.GetAllFiles(RegistrySettings.MusicFolderPath, "*.wav", ref al);
                    this.GetAllFiles(RegistrySettings.MusicFolderPath, "*.wma", ref al);
                    this.GetAllFiles(RegistrySettings.MusicFolderPath, "*.3gp", ref al);
                    this.GetAllFiles(RegistrySettings.MusicFolderPath, "*.aac", ref al);
                }
                Form1.Form1Instance.musicFileList = al;
            }
        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            RegistrySettings.EnableYoutubeUrl = (checkBox1.Checked) ? 1 : 0;
            RegistrySettings.Save();
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            ArrayList al = new ArrayList();
            this.GetAllFiles(textBox1.Text, "*.mp3", ref al);
            this.GetAllFiles(textBox1.Text, "*.wav", ref al);
            this.GetAllFiles(textBox1.Text, "*.wma", ref al);
            this.GetAllFiles(textBox1.Text, "*.3gp", ref al);
            this.GetAllFiles(textBox1.Text, "*.aac", ref al);

            if (al.Count != 0)
            {
                Form1.Form1Instance.musicFileList = al;
            }
            else
            {
                Form1.Form1Instance.musicFileList = new ArrayList();
            }

            RegistrySettings.MusicFolderPath = textBox1.Text;
            RegistrySettings.Save();
        }

        private void listView1_ColumnWidthChanged(object sender, ColumnWidthChangedEventArgs e)
        {
            string[] columnsWidth = new string[listView1.Columns.Count];
            for (int i = 0; i < columnsWidth.Count(); i++)
            {
                columnsWidth[i] = listView1.Columns[i].Width.ToString();
            }
            RegistrySettings.ColumnsWidth = columnsWidth;
            RegistrySettings.Save();
        }

    }
}
