﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Web;
using Twitter;
using WMPLib;
using System.Xml;
using Microsoft.Win32;

namespace Musitters
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
            wmp = new WindowsMediaPlayer();
            wmp.settings.volume = 10;
            wmp.settings.autoStart = false;
            wmp.PlayStateChange += new _WMPOCXEvents_PlayStateChangeEventHandler(PlayStateChange);
            Form1Instance = this;

            if (!string.IsNullOrEmpty(RegistrySettings.MusicFolderPath))
            {
                ArrayList al = new ArrayList();
                if (RegistrySettings.MusicFileSettings == 0)
                {
                    this.GetAllFiles(RegistrySettings.MusicFolderPath, "*.mp3", ref al);
                    this.GetAllFiles(RegistrySettings.MusicFolderPath, "*.wav", ref al);
                    this.GetAllFiles(RegistrySettings.MusicFolderPath, "*.wma", ref al);
                    this.GetAllFiles(RegistrySettings.MusicFolderPath, "*.3gp", ref al);
                    this.GetAllFiles(RegistrySettings.MusicFolderPath, "*.aac", ref al);
                    this.musicFileList = al;
                }
                else
                {
                    if (0 < RegistrySettings.MusicList.Length)
                    {
                        al.AddRange(RegistrySettings.MusicList);
                        this.musicFileList = al;
                    }
                }

                this.nowPlayTimes = RegistrySettings.Level;
            }
            else
            {
                Form2.Form2Instance.Show();
            }

        }

        //Form1オブジェクトを取得、設定するためのプロパティ
        public static Form1 Form1Instance { get; set; }

        public WindowsMediaPlayer wmp;
        private MusicFile mf;
        private ArrayList al = new ArrayList();
        private int nowPlayTimes = 0;
        private bool shouldPlay = false;

        public int NowPlayTimes
        {
            set { this.nowPlayTimes = value; }
            get { return this.nowPlayTimes; }
        }

        public ArrayList musicFileList
        {
            set { this.al = value; }
            get { return this.al; }
        }

        public void GetAllFiles(
            string folder, string searchPattern, ref ArrayList files)
        {
            //folderにあるファイルを取得する
            try
            {
                string[] fs =
                    System.IO.Directory.GetFiles(folder, searchPattern);
                //ArrayListに追加する
                files.AddRange(fs);

            }
            catch (DirectoryNotFoundException ex)
            {
                return;
            }

            //folderのサブフォルダを取得する
            string[] ds = System.IO.Directory.GetDirectories(folder);
            //サブフォルダにあるファイルも調べる
            foreach (string d in ds)
                GetAllFiles(d, searchPattern, ref files);
        }

        public void PlayStateChange(int newState)
        {
            if (wmp.playState == WMPPlayState.wmppsMediaEnded)
            {
                this.shouldPlay = true;
            }
        }

        private void 設定ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            var settings = Properties.Settings.Default;
            Form2.Form2Instance.Show();
        }

        //フォームのCreateParamsプロパティをオーバーライドする
        protected override CreateParams CreateParams
        {
            [System.Security.Permissions.SecurityPermission(
                System.Security.Permissions.SecurityAction.LinkDemand,
                Flags = System.Security.Permissions.SecurityPermissionFlag.UnmanagedCode)]
            get
            {
                const int WS_EX_TOOLWINDOW = 0x80;
                const long WS_POPUP = 0x80000000L;
                const int WS_VISIBLE = 0x10000000;
                const int WS_SYSMENU = 0x80000;
                const int WS_MAXIMIZEBOX = 0x10000;

                CreateParams cp = base.CreateParams;
                cp.ExStyle = WS_EX_TOOLWINDOW;
                cp.Style = unchecked((int)WS_POPUP) |
                    WS_VISIBLE | WS_SYSMENU | WS_MAXIMIZEBOX;
                cp.Width = 0;
                cp.Height = 0;

                return cp;
            }
        }

        private void 再生ToolStripMenuItem_Click(object sender, EventArgs e)
        {

            if (wmp.playState == WMPPlayState.wmppsPaused)
            {
                wmp.controls.play();
            }
            else
            {
                if (al.Count <= 0) return;
                randomMusicPlay();
            }
            this.再生ToolStripMenuItem.Visible = false;
            this.一時停止ToolStripMenuItem.Visible = true;
        }

        private void randomMusicPlay()
        {

            Random r = new Random();
            if (al.Count <= 0) return;
            int nextMusicNum = r.Next(0, al.Count);

            wmp.URL = (string)al[nextMusicNum];
            this.mf = new MusicFile((string)al[nextMusicNum]);

            string tc;
            tc = (mf.Artist != "") ? mf.Title + " / " + mf.Artist : mf.Title;

            this.nowPlayTimes += 1;

            try
            {
                if (99999 < this.nowPlayTimes)
                {
                    MessageBox.Show("おめでとうございます。このシステムの最大レベルに到達しました。");
                    tweet("おめでとうございます。このシステムの最大レベルに到達しました。 #musitters #maxlevel");
                    this.nowPlayTimes = 1;
                }

                string youtubeUrl = "";
                if (RegistrySettings.EnableYoutubeUrl == 1)
                {
                    youtubeUrl = getUrlByTheTitleAndAlbumInYoutube(mf.Title,mf.Album);
                }
                int tweetLength = (string.IsNullOrEmpty(youtubeUrl)) ? tc.Length : tc.Length + youtubeUrl.Length + 1;

                if (102 < tweetLength)
                {
                    if (string.IsNullOrEmpty(youtubeUrl))
                    {
                        tweet(tc.Substring(0, 102) + "... #NowPlaying #musitters #" + "level" + this.nowPlayTimes.ToString());
                    }
                    else
                    {
                        int tweetSubstr = 101 - youtubeUrl.Length;
                        tweet(tc.Substring(0, tweetSubstr) + "... #NowPlaying #musitters #" + "level" + this.nowPlayTimes.ToString() + " " + youtubeUrl);
                    }
                }
                else
                {
                    if (string.IsNullOrEmpty(youtubeUrl))
                    {
                        tweet(tc + " #NowPlaying #musitters #" + "level" + this.nowPlayTimes.ToString());
                    }
                    else
                    {
                        tweet(tc + " #NowPlaying #musitters #" + "level" + this.nowPlayTimes.ToString() + " " + youtubeUrl);
                    }

                }
            }
            catch (System.Net.WebException we)
            {
                this.nowPlayTimes -= 1;
                //バルーンヒントのタイトル
                notifyIcon1.BalloonTipTitle = "ツイート失敗";
                //バルーンヒントに表示するメッセージ
                notifyIcon1.BalloonTipText = tc + " - Now Playing";
                //バルーンヒントに表示するアイコン
                notifyIcon1.BalloonTipIcon = ToolTipIcon.Info;
                //バルーンヒントを表示する
                //表示する時間をミリ秒で指定する
                notifyIcon1.ShowBalloonTip(1000);
                wmp.controls.play();
                return;
            }

            if (46 < mf.Title.Length)
            {

                notifyIcon1.Text = mf.Title.Substring(0, 46) + "... - Now Playing";
            }
            else
            {
                notifyIcon1.Text = mf.Title + " - Now Playing";
            }

            //バルーンヒントのタイトル
            notifyIcon1.BalloonTipTitle = "ツイート完了 レベル" + this.nowPlayTimes + "になりました";
            //バルーンヒントに表示するメッセージ
            notifyIcon1.BalloonTipText = tc + " - Now Playing";
            //バルーンヒントに表示するアイコン
            notifyIcon1.BalloonTipIcon = ToolTipIcon.Info;
            //バルーンヒントを表示する
            //表示する時間をミリ秒で指定する
            notifyIcon1.ShowBalloonTip(1000);
            RegistrySettings.Level = this.nowPlayTimes;
            RegistrySettings.Save();
            wmp.controls.play();
        }

        private string getUrlByTheTitleAndAlbumInYoutube(string title,string album)
        {
            title = HttpUtility.UrlEncode(title);
            string url = "http://gdata.youtube.com/feeds/api/videos?q=" + title + "+" + album + "&max-results=1&v=2";
            HttpWebRequest req = (HttpWebRequest)WebRequest.Create(url);
            HttpWebResponse res = null;
            string xml = "";
            try
            {
                res = (HttpWebResponse)req.GetResponse();
                Stream st = res.GetResponseStream();
                Encoding enc = Encoding.GetEncoding("UTF-8");
                StreamReader sr = new StreamReader(st, enc);
                xml = sr.ReadToEnd();
            }
            catch (WebException ex)
            {
                return null;
            }
            finally
            {
                if (res != null) res.Close();
            }
            XmlDocument xmlDocument = new XmlDocument();
            xmlDocument.LoadXml(xml);
            XmlNodeList xnl = xmlDocument.GetElementsByTagName("yt:videoid");
            if (0 < xnl.Count)
            {
                return "http://youtu.be/" + xnl[0].InnerText;
            }
            return "";
        }

        private void tweet(string text)
        {
            Dictionary<string, string> parameters = new Dictionary<string, string>();
            Auth auth = new Auth(RegistrySettings.ConsumerKey, RegistrySettings.ConsumerSecret,
                            RegistrySettings.AccessToken, RegistrySettings.AccessTokenSecret,
                            RegistrySettings.UserId, RegistrySettings.ScreenName);
            parameters.Add("status", auth.UrlEncode(text));
            auth.Post("https://api.twitter.com/1.1/statuses/update.json", parameters);
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            if (!string.IsNullOrEmpty(RegistrySettings.AccessToken) && 0 < this.al.Count)
            {
                this.再生ToolStripMenuItem.Enabled = true;
            }
            else
            {
                this.再生ToolStripMenuItem.Enabled = false;
            }

            if (shouldPlay)
            {
                randomMusicPlay();
                if (wmp.playState == WMPPlayState.wmppsPlaying || wmp.playState == WMPPlayState.wmppsTransitioning)
                {
                    shouldPlay = false;
                }
            }
        }

        private void 終了ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            notifyIcon1.Visible = false;
            Application.Exit();
        }

        private void 一時停止ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            wmp.controls.pause();
            this.再生ToolStripMenuItem.Visible = true;
            this.一時停止ToolStripMenuItem.Visible = false;
        }

        private void notifyIcon1_MouseDown(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left)
            {
                if (!this.再生ToolStripMenuItem.Enabled) return;
                if (this.再生ToolStripMenuItem.Available)
                {
                    if (wmp.playState == WMPPlayState.wmppsPaused)
                    {
                        wmp.controls.play();
                    }
                    else
                    {
                        if (al.Count <= 0) return;
                        randomMusicPlay();
                    }
                    this.再生ToolStripMenuItem.Visible = false;
                    this.一時停止ToolStripMenuItem.Visible = true;
                }
                else
                {
                    wmp.controls.pause();
                    this.再生ToolStripMenuItem.Visible = true;
                    this.一時停止ToolStripMenuItem.Visible = false;
                }
            }
        }

    }
}
