﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using Twitter;

namespace Musitters
{
    class TwitterUser
    {

        private Auth auth;

        public TwitterUser(string consumerKey, string consumerSecret,
                string accessToken, string accessTokenSecret,
                string userId, string screenName)
        {
            this.auth = new Auth(consumerKey, consumerSecret,
                accessToken, accessTokenSecret,
                userId, screenName);
            Dictionary<string, string> parameters = new Dictionary<string, string>();
            parameters.Add("q", auth.UrlEncode(screenName));
            String s = auth.Get("http://api.twitter.com/1/users/search.xml", parameters);
            XmlDocument xd = new XmlDocument();
            xd.LoadXml(s);
            XmlElement xe = xd.DocumentElement;
            XmlNodeList xnl = xe.GetElementsByTagName("name");
            this.Name = xnl.Item(0).InnerText;
            this.ScreenName = screenName;
        }

        private string name;
        private string screenName;

        public string Name
        {
            set
            {
                this.name = value;
            }
            get
            {
                return this.name;
            }
        }

        public string ScreenName
        {
            set
            {
                this.screenName = value;
            }
            get
            {
                return this.screenName;
            }
        }

        public int Level
        {
            get
            {
                var settings = Properties.Settings.Default;
                if (settings.Level == 1)
                {

                    int level = 1;
                    bool levelFlag = true;
                    while (levelFlag)
                    {
                        Dictionary<string, string> parameters = new Dictionary<string, string>();
                        parameters.Add("q", auth.UrlEncode("musitters%20level" + level + "%20" + this.screenName));
                        String s = auth.Post("http://search.twitter.com/search.atom", parameters);
                        XmlDocument xd = new XmlDocument();
                        xd.LoadXml(s);
                        XmlElement xe = xd.DocumentElement;
                        XmlNodeList xnl = xe.GetElementsByTagName("entry");
                        if (xnl.Count == 0)
                        {
                            levelFlag = false;
                        }
                        else
                        {
                            level++;
                        }
                    }
                    return level;

                }
                return settings.Level;
            }
        }

    }
}
