#include	"multi_forward.h"
#include	"config.h"

void	pselectSet(void);
int	portSet(void);
void    lost_frame(void);
int     read_config(int argc, char **argv);
int     handler_init(void);

extern	void	handler(int sig);

time_t			start_time;
struct	timeval		time_100ms;
struct	timeval		current_time;
struct	timeval		temp_time;

int main(int argc, char** argv)
{

	int	i;
	int	ret;
	int	status_start;
	struct	area_callsign *ar_call_temp;

	time_t	atime;
	time_t	uptime;
	time_t	hole_punch;

	tzset();

        uname(&uname_buf);

	hole_punch_port = HOLE_PUNCH_PORT;
	memset (hole_punch_server, 0x00, 128);
	memcpy (hole_punch_server, HOLE_PUNCH_SERVER, sizeof(HOLE_PUNCH_SERVER));

	log_file = fopen (LOG_FILE, "a");
	if (log_file == NULL)
	{
		return 1;
	}
	time (&start_time);

	fprintf (log_file, "%24.24s D-STAR X-change (xchange) add on multi_forward V%5.5s (%s  %s) Start\n", 
						ctime(&start_time), PACKAGE_VERSION, __DATE__, __TIME__);
	fflush (log_file);

	pid_file = fopen(PID_FILE, "r");
	if (pid_file == NULL)
	{
		pid_file = fopen(PID_FILE, "w");
	}
	else
	{
		fprintf (log_file, "%24.24s Already running status.\n", ctime(&atime));
		fclose (log_file);
		return -1;
	}
	fprintf (pid_file, "%d", getpid());
	fclose (pid_file); 

	/* default value */
	fwd_port = 0;
	reload = FALSE;
	sig_term = FALSE;
	debug_sw = FALSE;
	MultiConnectTablePnt = NULL;
	ar_callsign_pnt = NULL;

	http_port = 0;

	fwd_sd = 0;

	memset (trust_server, 0x00, sizeof(trust_server));
	memcpy (trust_server, TRUST_SERVER, sizeof(TRUST_SERVER));

	if (!handler_init()) goto end;

	time (&atime);

	memset (forward_addr, 0x00, sizeof(forward_addr));
	if (!read_config (argc, (char **)argv)) goto end;
        if (debug_sw) 
	{
		fprintf (log_file, "                         %s %s %s\n",
                	uname_buf.sysname, uname_buf.release, uname_buf.version);
		fprintf (log_file, "%24.24s Word Size : %d\n", ctime(&atime), __WORDSIZE);
		fflush (log_file);
	}
	dsgwd_conf_read();

	pselectSet();	// FD & sig init
	if (!forward_init()) goto end;
	if (!portSet()) goto end;

	send_hole_punch();
	time(&hole_punch);
	hole_punch_interval = 60;
	hole_punch_port_save = multi_port;

	memset (dcs_name, 0x20, 8);
	read_dcs_config();

	Rp = malloc (sizeof (struct FifoPkt) - 1024);
        Wp = Rp;
        Rp->next = NULL;
	trust_status = NOP;

	time_100ms.tv_sec = 0;
	time_100ms.tv_usec = 100000;

	memset (forward_buff_save, 0x00, sizeof(forward_buff_save));
	multi_send_seq = 0;
	
	while (1)
	{
		memcpy (&read_set, &fd_save, sizeof(fd_set));
		memcpy (&sigset, &save_sig, sizeof(save_sig));
		ret = pselect (FD_SETSIZE, &read_set, (fd_set *)NULL, 
				(fd_set *)NULL, &timeout, &sigset);
		time (&atime);
		if (ret < 0) 
		{
                	fprintf (log_file, "%24.24s pselect error %s\n", 
				ctime(&atime), strerror(errno));
                	fflush (log_file);
			break;
		}
		else if (ret > 0)
		{
                	if (FD_ISSET (fwd_sd, &read_set))
                	{
                        	forward_resend();
                	}
			if (FD_ISSET (multi_sd, &read_set))
			{
				multi_connect();
			}
			if (FD_ISSET (http_sd, &read_set))
			{
				httpd_srv_accept();
			}
			if (http_port)
			{
				for (i = 0 ; i < FD_SETSIZE ; i++)
				{
					if ((i == fwd_sd)
						|| (i == multi_sd)
						|| (i == http_sd)) goto skip;
					if (FD_ISSET (i, &read_set)) httpd_srv_recv(i);
					skip: continue;
				}
			}

		}
		if (trust_status == NOP) multi_read();
		else if (trust_status == WAIT)
		{
			gettimeofday (&current_time, NULL);
			timeradd (&send_inquire_time, &time_100ms, &temp_time);
			if (timercmp (&current_time, &temp_time, >)) 
			{
				time(&atime);
				packet_skip();
				fprintf (log_file, "%24.24s trust server down\n", ctime(&atime));
				fflush (log_file);
			}
		}
		keep_alive_check();
		time(&atime);
		if ((atime - hole_punch) >= hole_punch_interval)
		{
			send_hole_punch();
			hole_punch = atime;;
		}
		status_check();
		if (sig_term) break;
	}

	// socket close
end:
	time(&atime);
	uptime = atime - start_time;
	fprintf (log_file, "%24.24s D-STAR X-change (xchange) add on status terminated (Up : %ldd%2ldh%2ldm%2lds)\n\n",
			ctime(&atime), 
			(uptime / 86400),
			((uptime % 86400) / 3600),
			(((uptime % 86400) % 3600) / 60),
			(((uptime % 86400) % 3600) % 60));
	fclose (log_file);
	remove (PID_FILE);
    	return 0;
}

