<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

require_once SD2ND_TRUST_PATH . '/class/AbstractFilterForm.class.php';

/**
 * Sd2nd_LearnedAbilityFilterForm
**/
class Sd2nd_LearnedAbilityFilterForm extends Sd2nd_AbstractFilterForm
{
    /**
     * getTotalItems
     * 
     * @param   int  &$total
     * 
     * @return  void
     * 
     * @protected
    **/
    function getTotalItems(&$total)
    {
        $total = $this->_mHandler->getLearnedAbilityCount($this->getCriteria());
    }

    /**
     * fetch
     * 
     * @param   void
     * 
     * @return  void
     * 
     * @public
    **/
    function fetch()
    {
        $this->mNavi->fetch();
    
        $root =& XCube_Root::getSingleton();
    
        if (($value = $root->mContext->mRequest->getRequest('eno')) !== null) {
            $this->mNavi->addExtra('eno', $value);
            $this->_mCriteria->add(new Criteria('eno', $value));
        }
    
        if (($value = $root->mContext->mRequest->getRequest('ability_name')) !== null) {
            $ext = array();
            foreach(explode(' ',mb_convert_kana($value,'as')) as $v)
            {
                if($v != null)
                {
                    $ext[] = $v;
                    $this->_mCriteria->add(new Criteria('ability_name',$v));
                }
            }
            $this->mNavi->addExtra('ability_name',implode(' ',$ext));
        }
    
        if(!$this->_mCriteria->hasChildElements())
        {
            $this->_mCriteria->add(new Criteria('ability_name','dummy'));
        }
    
        $this->_mCriteria->addSort('`c`.`eno`', 'ASC');
    }
}

?>
