<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

/**
 * @class   Sd2nd_DataConvertPrepare
**/
class Sd2nd_DataConvertPrepare extends Sd2nd_AbstractFilter
{
    const BASE_SPOT_WORLD = 3;
    const BASE_SPOT_TUNNEL = 33;
    
    /**
     * getPriority
     * 
     * @param   void
     * 
     * @return  Enum
    **/
    public function getPriority()
    {
        return XCUBE_DELEGATE_PRIORITY_2;
    }
    
    /**
     * prepare
     * 
     * @param   int $updateTime
     * 
     * @return  void
    **/
    public function prepare(/*** int ***/ $updateTime)
    {
        $class = new ReflectionClass($this);
        $methods = $class->getMethods();
        usort($methods,array('Sd2nd_AbstractProcess','compareMethodName'));
        
        foreach($methods as $method)
        {
            if($method->name == 'execute' . $updateTime)
            {
                $this->_mFunc = $method;
                break;
            }
        }
        
        if(!$this->_mFunc instanceof ReflectionMethod)
        {
            $this->_mFunc = new ReflectionMethod($this,'executeLatest');
        }
    }
    
    /**
     * executeLatest
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function executeLatest()
    {
    }
    
    /**
     * execute090415
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function execute090415()
    {
        $obj =& Sd2nd_UpdateUtils::createObject(Sd2nd_AssetManager::HANDLER_MAP_NAME);
        $obj->setVars(
            array(
                'map_id' => 3,
                'map_name' => _MD_SD2ND_MAP_NAME_TUNNEL_B1F,
                'base_spot' => 0
            )
        );
        Sd2nd_UpdateUtils::insertObject(Sd2nd_AssetManager::HANDLER_MAP_NAME,$obj);
    }
    
    /**
     * execute090214
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function execute090214()
    {
        $handler =& Sd2nd_UpdateUtils::getHandler(Sd2nd_AssetManager::HANDLER_MAP_NAME);
        $obj =& $handler->create();
        $obj->setVars(
            array(
                'map_id' => 2,
                'map_name' => _MD_SD2ND_MAP_NAME_TUNNEL,
                'base_spot' => self::BASE_SPOT_TUNNEL
            )
        );
        /// @ todo backup convert
        $handler->db->queryF('UPDATE `' . Sd2nd_UpdateUtils::getHandler(Sd2nd_AssetManager::HANDLER_MAP)->mTable . '` SET `map_id` = 1');
        $handler->db->queryF('UPDATE `' . Sd2nd_UpdateUtils::getHandler(Sd2nd_AssetManager::HANDLER_MAP_CACHE)->mTable . '` SET `map_id` = 1');
    }
    
    /**
     * execute090121
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function execute090121()
    {
        $cri = new Criteria('skill_id',456);
        Sd2nd_UpdateUtils::deleteMultiObjects(Sd2nd_AssetManager::HANDLER_SKILL,$cri);
        Sd2nd_UpdateUtils::deleteMultiObjects(Sd2nd_AssetManager::HANDLER_SKILL_ELEMENT_LINK,$cri);
    }
    
    /**
     * execute090117
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function execute090117()
    {
        $cri = new Criteria('skill_id',456);
        Sd2nd_UpdateUtils::deleteMultiObjects(Sd2nd_AssetManager::HANDLER_SKILL,$cri);
        Sd2nd_UpdateUtils::deleteMultiObjects(Sd2nd_AssetManager::HANDLER_SKILL_ELEMENT_LINK,$cri);
    }
    
    /**
     * execute081004
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function execute081004()
    {
        $cri = new CriteriaCompo();
        $cri->add(new Criteria('skill_id',807));
        Sd2nd_UpdateUtils::deleteMultiObjects(Sd2nd_AssetManager::HANDLER_SKILL,$cri);
        Sd2nd_UpdateUtils::deleteMultiObjects(Sd2nd_AssetManager::HANDLER_SKILL_ELEMENT_LINK,$cri);
    }
    
    /**
     * execute080903
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function execute080903()
    {
        $cri = new CriteriaCompo();
        $cri->add(new Criteria('ability_id',1,'>='));
        $cri->add(new Criteria('ability_id',5,'<='));
        Sd2nd_UpdateUtils::deleteMultiObjects(Sd2nd_AssetManager::HANDLER_ABILITY,$cri);
    }
    
    /**
     * execute080625
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function execute080625()
    {
        $cri = new Criteria('ability_id',1220);
        Sd2nd_UpdateUtils::deleteMultiObjects(Sd2nd_AssetManager::HANDLER_ABILITY,$cri);
    }
    
    /**
     * execute080524
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function execute080524()
    {
        $handler =& Sd2nd_UpdateUtils::getHandler(Sd2nd_AssetManager::HANDLER_MAP_NAME);
        $obj =& $handler->create();
        $obj->setVars(
            array(
                'map_id' => 1,
                'map_name' => _MD_SD2ND_MAP_NAME_WORLD,
                'base_spot' => self::BASE_SPOT_WORLD
            )
        );
    }
}

?>
