<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

/**
 * @class   Sd2nd_Show_ProfileCharParser
**/
class Sd2nd_Show_ProfileCharParser extends Sd2nd_AbstractParser
{
    protected /*** int{} ***/ $_mSexList = array();
    protected /*** string ***/ $_mPattern = null;
    
    /**
     * prepare
     * 
     * @param   int $updateTime
     * 
     * @return  void
    **/
    public function prepare(/*** int ***/ $updateTime)
    {
        parent::prepare($updateTime);
        $i = 1;
        while(defined($value = '_MD_SD2ND_LANG_SEX_' . $i))
        {
            $this->_mSexList[constant($value)] = $i++;
        }
        $this->_mPattern = sprintf("/\('.*(?P<sex>%s) ?(?:(?P<age>\d+)%s )?(?:(?P<height>\d+)%s )?(?:(?P<weight>\d+)%s )?','(?P<profile>[^']*)'\)/",implode('|',array_keys($this->_mSexList)),_MD_SD2ND_LANG_AGE_UNIT,_MD_SD2ND_LANG_HEIGHT_UNIT,_MD_SD2ND_LANG_WEIGTH_UNIT);
    }
    
    /**
     * executeLatest
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function executeLatest()
    {
        $arr = Sd2nd_UpdateUtils::parseByRegex($this->_mLine,$this->_mPattern);
        $arr['sex'] = $this->_mSexList[$arr['sex']];
        $arr['profile'] = strtr($arr['profile'],array('<br>' => "\n"));
        $this->_mExecute->mCharData[Sd2nd_AssetManager::HANDLER_CHAR]->setVars($arr);
    }
}


?>
