<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}


/**
 * @class   Sd2nd_Show_ImageCharParser
**/
class Sd2nd_Show_ImageCharParser extends Sd2nd_AbstractParser
{
    protected /*** Sd2nd_ImageHandler ***/ $_mHandler = null;
    
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        parent::__construct();
        $this->_mHandler =& Sd2nd_UpdateUtils::getHandler(Sd2nd_AssetManager::HANDLER_IMAGE);
    }
    
    /**
     * executeLatest
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function executeLatest()
    {
        $arr = Sd2nd_UpdateUtils::parseByRegex($this->_mLine,'/\((?P<image_width>\d+),(?P<image_height>\d+),"(?P<image_url>[^"]+)","(?P<image_link>[^"]*)"\);/');
        $obj =& $this->_mHandler->getByUnique($this->_mActiveId);
        if(!$obj instanceof $this->_mHandler->mClass || $obj->get('image_url') != $arr['image_url'] || $obj->get('image_width') != $arr['image_width'] || $obj->get('image_height') != $arr['image_height'] || $obj->get('image_link') != $arr['image_link'])
        {
            $this->_appendImage($arr);
        }
    }
    
    /**
     * _appendImage
     * 
     * @param   mixed{} $params
     * 
     * @return  void
    **/
    protected function _appendImage(/*** mixed{} ***/ $params)
    {
        $obj =& Sd2nd_UpdateUtils::createObject(Sd2nd_AssetManager::HANDLER_IMAGE);
        $obj->set('eno',$this->_mActiveId);
        $obj->set('image_url',$params['image_url']);
        $obj->set('image_height',$params['image_height']);
        $obj->set('image_width',$params['image_width']);
        $obj->set('image_link',$params['image_link']);
        $obj->set('update_time',$this->_mUpdateTime);
        Sd2nd_UpdateUtils::insertObject(Sd2nd_AssetManager::HANDLER_IMAGE,$obj);
    }
}


?>
