<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}


/**
 * @class   Sd2nd_SAbility_DataCharParser
**/
class Sd2nd_SAbility_DataCharParser extends Sd2nd_AbstractParser
{
    protected /*** mixed{} ***/ $_mAttrs = null;
    protected /*** XoopsDatabase ***/ $_mDB = null;
    protected /*** int{} ***/ $_mLearnedAbility = array();
    
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  voud
    **/
    public function __construct()
    {
        parent::__construct();
        
        $root =& XCube_Root::getSingleton();
        $this->_mAttrs =& $root->mContext->mAttributes;
        $this->_mDB =& $root->mController->mDB;
    }
    
    /**
     * reset
     * 
     * @param   int                     $id
     * @param   Sd2nd_AbstractExecute   &$execute
     * @param   string                  $line
     * 
     * @return  void
    **/
    public function reset(/*** int ***/ $id,Sd2nd_AbstractExecute &$execute,/*** string ***/ $line)
    {
        parent::reset($id,$execute,$line);
        
        $this->_mLearnedAbility = array();
        if(!$res = $this->_mDB->query('select `ability_id` from `' . Sd2nd_UpdateUtils::convertTableName(Sd2nd_AssetManager::HANDLER_LEARNED_ABILITY) . '` where `eno` = ' . intval($this->_mActiveId)))
        {
            throw new Sd2nd_QueryException('LearnedAbility data is not readable.');
        }
        
        while($row = $this->_mDB->fetchArray($res))
        {
            $this->_mLearnedAbility[$row['ability_id']] = $row['ability_id'];
        }
    }
    
    /**
     * executeLatest
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function executeLatest()
    {
        $arr = Sd2nd_UpdateUtils::parseByExplode($this->_mLine,4,strpos($this->_mLine,'(') + 1,-1,array('ability_id','ability_name','description','ability_cost'));
        $arr['ability_name'] = trim($arr['ability_name'],"'");
        if(!isset($this->_mAttrs['sd2nd.ability'][$arr['ability_name']]))
        {
            $this->_appendAbility($arr);
        }
        if(!isset($this->_mLearnedAbility[$arr['ability_id']]))
        {
            $this->_appendLearnedAbility($arr['ability_id']);
        }
    }
    
    /**
     * _appendAbility
     * 
     * @param   string{}    $params
     * 
     * @return  void
    **/
    protected function _appendAbility(/*** string{} ***/ $params)
    {
        $this->_mAttrs['sd2nd.ability'][$params['ability_name']] = $params['ability_id'];
        $obj =& Sd2nd_UpdateUtils::createObject(Sd2nd_AssetManager::HANDLER_ABILITY);
        $obj->set('ability_id',$params['ability_id']);
        $obj->set('ability_name',$params['ability_name']);
        $obj->set('description',strtr(trim($params['description'],"'"),array('<br>' => "\n")));
        $obj->set('ability_cost',$params['ability_cost']);
        $obj->set('regist_time',$this->_mUpdateTime);
        Sd2nd_UpdateUtils::insertObject(Sd2nd_AssetManager::HANDLER_ABILITY,$obj);
    }
    
    /**
     * _appendLearnedAbility
     * 
     * @param   int $id
     * 
     * @return  void
    **/
    protected function _appendLearnedAbility(/*** int ***/ $id)
    {
        $obj =& Sd2nd_UpdateUtils::createObject(Sd2nd_AssetManager::HANDLER_LEARNED_ABILITY);
        $obj->set('eno',$this->_mActiveId);
        $obj->set('ability_id',$id);
        $obj->set('regist_time',$this->_mUpdateTime);
        Sd2nd_UpdateUtils::insertObject(Sd2nd_AssetManager::HANDLER_LEARNED_ABILITY,$obj);
    }
}

?>
