<?php
/**
 * @file
 * @package Sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

/**
 * @class   Sd2nd_UpdateDispose
**/
class Sd2nd_UpdateDispose extends Sd2nd_AbstractFilter
{
    /**
     * @brief   int
    **/
    protected $_mUpdateTime = null;
    
    /**
     * prepare
     * 
     * @param   int $updateTime
     * 
     * @return  void
    **/
    public function prepare(/*** int ***/ $updateTime)
    {
        parent::prepare($updateTime);
        
        $this->_mUpdateTime = $updateTime;
    }
    
    /**
     * executeLatest
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_QueryException
    **/
    public function executeLatest()
    {
        $update =& Sd2nd_UpdateUtils::createObject(Sd2nd_AssetManager::HANDLER_UPDATE);
        $update->set('update_time',$this->_mUpdateTime);
        Sd2nd_UpdateUtils::insertObject(Sd2nd_AssetManager::HANDLER_UPDATE,$update);
    }
}

?>
