<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

require_once SD2ND_TRUST_PATH . '/class/updater/Sd2ndUpdateUtils.class.php';

/**
 * @class   Sd2nd_Updater
**/
class Sd2nd_Updater
{
    /**
     * @brief   string
    **/
    protected $_mZipName = null;
    
    /**
     * @brief   string{}
    **/
    protected $_mMessages = array(
        'start'   => 'process started...',
        'prepare' => 'execute prepare process...',
        'execute' => 'execute main process...',
        'dispose' => 'execute dispose process...',
        'finish'  => 'process completed.'
    );
    
    /**
     * @brief   int
    **/
    const PROGRESS_NORMAL = 100;
    
    /**
     * @brief   int
    **/
    const PROGRESS_SPECIAL = 1000;
    
    /**
     * __construct
     * 
     * @param   string  $zipName
     * 
     * @return  void
    **/
    public function __construct(/*** string ***/ $zipName)
    {
        $this->_showMessage('start');
        $this->_mZipName = $zipName;
    }
    
    /**
     * prepare
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function prepare()
    {
        $this->_showMessage('prepare');
        Sd2nd_UpdateUtils::executeFilter('prepare');
    }
    
    /**
     * execute
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function execute()
    {
        $this->_showMessage('execute');
        $zip = new ZipArchive();
        $zip->open($this->_mZipName);
        
        for($i = 0;$i < $zip->numFiles;$i++)
        {
            $arr = array();
            if(preg_match(SD2ND_EXTRACTION_PATTERN,$zip->getNameIndex($i),$arr))
            {
                $instance =& Sd2nd_UpdateUtils::getProcess('execute',ucfirst($arr['name']));
                if($instance instanceof Sd2nd_AbstractExecute)
                {
                    $instance->reset(intval($arr['id']),mb_convert_encoding($zip->getFromIndex($i),mb_internal_encoding(),SD2ND_RESULT_ENCODING));
                    try
                    {
                        $instance->execute();
                    }
                    catch(Sd2nd_Exception $e)
                    {
                        Sd2nd_UpdateUtils::displayError($e);
                        if($e->isFatal())
                        {
                            $zip->close();
                            die();
                        }
                    }
                }
                unset($instance);
            }
            
            if($i % self::PROGRESS_NORMAL == 0)
            {
                echo ($i % self::PROGRESS_SPECIAL == 0 ? '+' : '*');
            }
        }
        echo "\n";
        
        $zip->close();
    }
    
    /**
     * dispose
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function dispose()
    {
        $this->_showMessage('dispose');
        Sd2nd_UpdateUtils::executeFilter('dispose');
        $this->_showMessage('finish');
    }
    
    /**
     * _showMessage
     * 
     * @param   Enum    $key
     * 
     * @return  void
    **/
    protected function _showMessage(/*** Enum ***/ $key)
    {
        if(isset($this->_mMessages[$key]) && $this->_mMessages[$key] != null)
        {
            echo $this->_mMessages[$key],"\n";
        }
    }
}

?>
