<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

/**
 * Sd2nd_MapSpotObject
**/
class Sd2nd_MapSpotObject extends XoopsSimpleObject
{
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->initVar('spot_id', XOBJ_DTYPE_INT, '', false);
        $this->initVar('spot_name', XOBJ_DTYPE_STRING, '', false, 50);
        $this->initVar('description', XOBJ_DTYPE_TEXT, '', false);
        $this->initVar('regist_time', XOBJ_DTYPE_INT, '', false);
    }
}

/**
 * Sd2nd_MapSpotHandler
**/
class Sd2nd_MapSpotHandler extends XoopsObjectGenericHandler
{
    /**
     * @brief   string
    **/
    public $mTable = '{dirname}_map_spot';

    /**
     * @brief   string
    **/
    public $mPrimary = 'spot_id';

    /**
     * @brief   string
    **/
    public $mClass = 'Sd2nd_MapSpotObject';

    /**
     * __construct
     * 
     * @param   XoopsDatabase  &$db
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
    {
        $this->mTable = str_replace('{dirname}',$dirname,$this->mTable);
        parent::XoopsObjectGenericHandler($db);
    }
}

?>
