<?php
/**
 * @file
 * @package 
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

/**
 * @class   Sd2nd_MapCacheObject
**/
class Sd2nd_MapCacheObject extends XoopsSimpleObject
{
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->initVar('map_id', XOBJ_DTYPE_INT, 1, false);
        $this->initVar('update_time', XOBJ_DTYPE_INT, '', false);
        $this->initVar('map_range', XOBJ_DTYPE_STRING, '', false);
        $this->initVar('map_body', XOBJ_DTYPE_TEXT, '', false);
    }
}


/**
 * Sd2nd_MapCacheHandler
**/
class Sd2nd_MapCacheHandler extends XoopsObjectGenericHandler
{
    public /*** string ***/ $mTable = '{dirname}_map_cache';
    public /*** string ***/ $mPrimary = 'update_time';
    public /*** string ***/ $mClass = 'Sd2nd_MapCacheObject';
    
    /**
     * __construct
     * 
     * @param   XoopsDatabase  &$db
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
    {
        $this->mTable = str_replace('{dirname}',$dirname,$this->mTable);
        parent::XoopsObjectGenericHandler($db);
    }
    
    /**
     * getByUnique
     * 
     * @param   int $mapId
     * @param   int $updateTime
     * 
     * @return  Sd2nd_MapCacheObject
    **/
    public function getByUnique(/*** int ***/ $mapId,/*** int ***/ $updateTime)
    {
        $cri = new CriteriaCompo();
        $cri->add(new Criteria('map_id',$mapId));
        $cri->add(new Criteria('update_time',$updateTime));
        $objs = $this->getObjects($cri);
        return isset($objs[0]) ? $objs[0] : null;
    }
}

?>
