<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

/**
 * Sd2nd_LearnedCostumeObject
**/
class Sd2nd_LearnedCostumeObject extends XoopsSimpleObject
{
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->initVar('eno', XOBJ_DTYPE_INT, '', false);
        $this->initVar('costume_id', XOBJ_DTYPE_INT, '', false);
        $this->initVar('costume_lv', XOBJ_DTYPE_INT, '', false);
        $this->initVar('costume_point', XOBJ_DTYPE_INT, '', false);
        $this->initVar('regist_time', XOBJ_DTYPE_INT, '', false);
    }
}

/**
 * Sd2nd_LearnedCostumeHandler
**/
class Sd2nd_LearnedCostumeHandler extends XoopsObjectGenericHandler
{
    public /*** string ***/ $mTable = '{dirname}_learned_costume';
    public /*** string ***/ $mPrimary = 'eno';
    public /*** string ***/ $mClass = 'Sd2nd_LearnedCostumeObject';

    /**
     * __construct
     * 
     * @param   XoopsDatabase  &$db
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
    {
        $this->mTable = str_replace('{dirname}',$dirname,$this->mTable);
        parent::XoopsObjectGenericHandler($db);
    }
    
    /**
     * _update
     * 
     * @param   XoopsSimpleObject   $obj
     * 
     * @return  string
    **/
    public function _update(XoopsSimpleObject $obj)
    {
        return sprintf(
            'UPDATE `%s` SET `costume_lv` = %d,`costume_point` = %d,`regist_time` = %d WHERE `eno` = %d AND `costume_id` = %d',
            $this->mTable,$obj->get('costume_lv'),$obj->get('costume_point'),$obj->get('regist_time'),$obj->get('eno'),$obj->get('costume_id')
        );
    }
}

?>
