<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

/**
 * Sd2nd_LearnedAbilityObject
**/
class Sd2nd_LearnedAbilityObject extends XoopsSimpleObject
{
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->initVar('eno', XOBJ_DTYPE_INT, '', false);
        $this->initVar('ability_id', XOBJ_DTYPE_INT, '', false);
        $this->initVar('regist_time', XOBJ_DTYPE_INT, '', false);
    }
}

/**
 * Sd2nd_LearnedAbilityHandler
**/
class Sd2nd_LearnedAbilityHandler extends XoopsObjectGenericHandler
{
    /**
     * @brief   string
    **/
    public $mTable = '{dirname}_learned_ability';

    /**
     * @brief   string
    **/
    public $mPrimary = 'eno';

    /**
     * @brief   string
    **/
    public $mClass = 'Sd2nd_LearnedAbilityObject';

    /**
     * __construct
     * 
     * @param   XoopsDatabase  &$db
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
    {
        $this->mTable = str_replace('{dirname}',$dirname,$this->mTable);
        parent::XoopsObjectGenericHandler($db);
    }
}

?>
