<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

/**
 * Sd2nd_IconObject
**/
class Sd2nd_IconObject extends XoopsSimpleObject
{
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->initVar('icon_id', XOBJ_DTYPE_INT, '', false);
        $this->initVar('eno', XOBJ_DTYPE_INT, '', false);
        $this->initVar('slot', XOBJ_DTYPE_INT, '', false);
        $this->initVar('icon_url', XOBJ_DTYPE_STRING, '', false, 255);
        $this->initVar('icon_height', XOBJ_DTYPE_INT, '', false);
        $this->initVar('icon_width', XOBJ_DTYPE_INT, '', false);
        $this->initVar('update_time', XOBJ_DTYPE_INT, '', false);
    }
}

/**
 * Sd2nd_IconHandler
**/
class Sd2nd_IconHandler extends XoopsObjectGenericHandler
{
    /**
     * @brief   string
    **/
    public $mTable = '{dirname}_icon';

    /**
     * @brief   string
    **/
    public $mPrimary = 'icon_id';

    /**
     * @brief   string
    **/
    public $mClass = 'Sd2nd_IconObject';

    /**
     * __construct
     * 
     * @param   XoopsDatabase  &$db
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
    {
        $this->mTable = str_replace('{dirname}',$dirname,$this->mTable);
        parent::XoopsObjectGenericHandler($db);
    }

    /**
     * &getByUnique
     * 
     * @param   int $eno
     * @param   int $slot
     * 
     * @return  Sd2nd_IconObject
    **/
    public function &getByUnique(/*** int ***/ $eno,/*** int ***/ $slot)
    {
        $cri = new CriteriaCompo();
        $cri->add(new Criteria('eno',$eno));
        $cri->add(new Criteria('slot',$slot));
        $cri->setSort('update_time','desc');
        $ret =& $this->getObjects($cri);
        
        if(!is_array($ret) || count($ret) != 1)
        {
            $ret = null;
            return $ret;
        }
        
        return $ret[0];
    }
}

?>
