<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

/**
 * Sd2nd_CostumeObject
**/
class Sd2nd_CostumeObject extends XoopsSimpleObject
{
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->initVar('costume_id', XOBJ_DTYPE_INT, '', false);
        $this->initVar('costume_name', XOBJ_DTYPE_STRING, '', false, 50);
        $this->initVar('grow_life', XOBJ_DTYPE_INT, '', false);
        $this->initVar('grow_soul', XOBJ_DTYPE_INT, '', false);
        $this->initVar('grow_pow', XOBJ_DTYPE_INT, '', false);
        $this->initVar('grow_str', XOBJ_DTYPE_INT, '', false);
        $this->initVar('grow_dex', XOBJ_DTYPE_INT, '', false);
        $this->initVar('grow_speed', XOBJ_DTYPE_INT, '', false);
        $this->initVar('grow_mag', XOBJ_DTYPE_INT, '', false);
        $this->initVar('grow_reg', XOBJ_DTYPE_INT, '', false);
        $this->initVar('grow_con', XOBJ_DTYPE_INT, '', false);
        $this->initVar('modify_hp', XOBJ_DTYPE_INT, '', false);
        $this->initVar('modify_tp', XOBJ_DTYPE_INT, '', false);
        $this->initVar('modify_at', XOBJ_DTYPE_INT, '', false);
        $this->initVar('modify_df', XOBJ_DTYPE_INT, '', false);
        $this->initVar('modify_mat', XOBJ_DTYPE_INT, '', false);
        $this->initVar('modify_mdf', XOBJ_DTYPE_INT, '', false);
        $this->initVar('modify_act', XOBJ_DTYPE_INT, '', false);
        $this->initVar('move_cost', XOBJ_DTYPE_INT, '', false);
        $this->initVar('regist_time', XOBJ_DTYPE_INT, '', false);
    }
}

/**
 * Sd2nd_CostumeHandler
**/
class Sd2nd_CostumeHandler extends XoopsObjectGenericHandler
{
    /**
     * @brief   string
    **/
    public $mTable = '{dirname}_costume';

    /**
     * @brief   string
    **/
    public $mPrimary = 'costume_id';

    /**
     * @brief   string
    **/
    public $mClass = 'Sd2nd_CostumeObject';

    /**
     * __construct
     * 
     * @param   XoopsDatabase  &$db
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
    {
        $this->mTable = str_replace('{dirname}',$dirname,$this->mTable);
        parent::XoopsObjectGenericHandler($db);
    }
}

?>
