<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}


/**
 * Sd2nd_MapViewAction
**/
class Sd2nd_MapViewAction extends Sd2nd_AbstractAction
{
    protected /*** Sd2nd_UpdateHandler ***/ $_mUpdateHandler = null;
    protected /*** Sd2nd_MapCollection ***/ $_mMapCollection = null;
    protected /*** Sd2nd_MapNameHandler ***/ $_mMapNameHandler = null;
    protected /*** Sd2nd_MapNameObject ***/ $_mMapNameObject = null;
    
    /**
     * getDefaultView
     * 
     * @param   void
     * 
     * @return  Enum
    **/
    public function getDefaultView()
    {
        $this->_mUpdateHandler =& $this->mAsset->getObject('handler','update');
        $this->_mMapNameHandler =& $this->mAsset->getObject('handler','mapName');
        if(!$this->_mMapNameHandler->isValid($mapId = $this->mRoot->mContext->mRequest->getRequest('map')))
        {
            $mapId = 1;
        }
        if(intval($updateTime = $this->mRoot->mContext->mRequest->getRequest('update_time')) == null)
        {
            $updateTime = $this->_mUpdateHandler->getLatestUpdate()->get('update_time');
        }
        if($updateTime == null)
        {
            $updateTime = 999999;
        }
        
        $handler =& $this->mAsset->getObject('handler', 'map');
        $this->_mMapCollection = $handler->getCollection($updateTime,$updateTime,$mapId);
        $this->_mMapNameObject =& $this->_mMapNameHandler->get($mapId);
        
        return SD2ND_FRAME_VIEW_INDEX;
    }
    
    /**
     * executeViewIndex
     * 
     * @param   XCube_RenderTarget  &$render
     * 
     * @return  void
    **/
    public function executeViewIndex(/*** XCube_RenderTarget ***/ &$render)
    {
        $render->setTemplateName($this->mAsset->mDirname . '_map_view.html');
        
        $render->setAttribute('map',$this->_mMapCollection);
        $render->setAttribute('updateHandler',$this->_mUpdateHandler);
        $render->setAttribute('mapNameHandler',$this->_mMapNameHandler);
        $render->setAttribute('mapName',$this->_mMapNameObject);
    }
}

?>
