<?php
/**
 * @package user
 * @version $Id: UserInfoAction.class.php,v 1.2 2007/06/07 05:27:01 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

define ('USER_USERINFO_MAXHIT', 5);

/***
 * @internal
 * This action shows a information of the target user which is specified by
 * $uid. And display posts of the user with the global search service.
 * 
 * [Warning]
 * Now, the global search service can't work because the design of XCube is
 * changed.
 * 
 * @todo The global search service can't work.
 */
class User_UserInfoAction extends User_Action
{
	var $mObject = null;
	var $mSelfDelete = false;

	function prepare(&$controller, &$xoopsUser, $moduleConfig)
	{
		$this->mSelfDelete = $moduleConfig['self_delete'];
	}
	
	function isSecure()
	{
		return false;
	}

	function getDefaultView(&$controller, &$xoopsUser)
	{
		$uid = isset($_GET['uid']) ? intval($controller->mRoot->mContext->mRequest->getRequest('uid')) : 0;
		
		$handler =& xoops_gethandler('user');
		$this->mObject =& $handler->get($uid);
		
		if (!is_object($this->mObject)) {
			return USER_FRAME_VIEW_ERROR;
		}
		
		return USER_FRAME_VIEW_SUCCESS;
	}
	
	/***
	 * [Notice]
	 * Because XCube_Service class group are changed now, this member function
	 * can't get the result of user posts.
	 */
	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("user_userinfo.html");
		$render->setAttribute("thisUser", $this->mObject);
		
		//
		// set flags.
		//
		$user_ownpage = (is_object($xoopsUser) && $xoopsUser->get('uid') == $this->mObject->get('uid'));
		$render->setAttribute("user_ownpage", $user_ownpage);
		
		//
		// About 'SELF DELETE'
		//
		$render->setAttribute('self_delete', $this->mSelfDelete);
		if ($user_ownpage && $this->mSelfDelete) {
			$render->setAttribute('enableSelfDelete', true);
		}
		else {
			$render->setAttribute('enableSelfDelete', false);
		}
	}
	
	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward(XOOPS_URL . '/user.php');
	}
}

?>