<?php
/**
 * @package user
 * @version $Id: EditUserAction.class.php,v 1.3 2007/12/22 17:54:05 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/user/class/AbstractEditAction.class.php";
require_once XOOPS_MODULE_PATH . "/user/forms/EditUserForm.class.php";

define ('USER_COOKIE_KEEP_TIME', 31536000);

/***
 * @internal
 */
class User_EditUserAction extends User_AbstractEditAction
{
	function _getId()
	{
		$root =& XCube_Root::getSingleton();
		$uid = is_object($root->mContext->mXoopsUser) ? $root->mContext->mXoopsUser->get('uid') : 0;
		
		return isset($_REQUEST['uid']) ? intval($root->mContext->mRequest->getRequest('uid')) : $uid;
	}
	
	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('users', 'user');
		return $handler;
	}

	/**
	 * Because editable fields are decided by the module config, this member
	 * function hands the config to the constructor of the action form.
	 * 
	 * @see User_AbstractUserEditForm
	 */
	function _setupActionForm()
	{
		$this->mActionForm = new User_EditUserForm($this->mConfig);
		$this->mActionForm->prepare();
	}
	
	function isEnableCreate()
	{
		return false;
	}

	function isSecure()
	{
		return true;
	}
	
	/**
	 * Allow Conditions:
	 * 
	 * 1) The current user is the target user.
	 * 2) The current user is administrators.
	 */
	function hasPermission(&$controller, &$xoopsUser, $moduleConfig)
	{
		if (!is_object($this->mObject)) {
			return false;
		}

		if ($controller->mRoot->mContext->mUser->isInRole('Module.user.Admin')) {
			return true;
		}
		
		return ($this->mObject->get('uid') == $xoopsUser->get('uid'));
	}

	function _doExecute()
	{
        return $this->mObjectHandler->insert($this->mObject);
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("user_edituser.html");
		$render->setAttribute("actionForm", $this->mActionForm);
		$render->setAttribute("thisUser", $this->mObject);
		$render->setAttribute("currentUser", $xoopsUser);
		$render->setAttribute("allow_chgmail", $this->mConfig['allow_chgmail']);
		
		$handler =& xoops_gethandler('timezone');
		$timezoneArr =& $handler->getObjects();
		$render->setAttribute('timezones', $timezoneArr);
	}

	function executeViewSuccess(&$controller,&$xoopsUser,&$render)
	{
		$controller->executeForward(XOOPS_URL . '/userinfo.php?uid=' . $this->mObject->getShow('uid'));
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeRedirect(XOOPS_URL . '/', 1, _MD_USER_ERROR_DBUPDATE_FAILED);
	}
}

?>