<?php
/**
 * @version $Id: Legacy_RenderSystem.class.php,v 1.4 2008/08/26 15:58:41 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH."/modules/legacyRender/kernel/Legacy_RenderTarget.class.php";
require_once XOOPS_ROOT_PATH . "/class/template.php";

/**
 * @brief The sub-class for Legacy_RenderSystem. 
 * 
 * Because XoopsTpl class may be used without Cube's boot, this is declared.
 */
class Legacy_XoopsTpl extends XoopsTpl
{
	/**
	 * @private
	 * If variables having the following key are assigned, converts value with
	 * htmlspecialchars_decode, and set it to the context for compatibility.
	 */
	var $_mContextReserve = array();
	
	function __construct()
	{
		$this->_mContextReserve = array ('xoops_pagetitle' => 'legacy_pagetitle');
		parent::__construct();
	}
	
    function assign($tpl_var, $value = null)
    {
		if (is_array($tpl_var)){
			foreach ($tpl_var as $key => $val) {
				if ($key != '') {
					$this->assign($key, $val);
				}
			}
		}
		else {
			if ($tpl_var != '') {
				if (isset($this->_mContextReserve[$tpl_var])) {
					$root =& XCube_Root::getSingleton();
					$root->mContext->setAttribute($this->_mContextReserve[$tpl_var], htmlspecialchars_decode($value));
				}
				$this->_tpl_vars[$tpl_var] = $value;
			}
        }
	}
	
	function assign_by_ref($tpl_var, &$value)
	{
		if ($tpl_var != '') {
			if (isset($this->_mContextReserve[$tpl_var])) {
				$root =& XCube_Root::getSingleton();
				$root->mContext->setAttribute($this->_mContextReserve[$tpl_var], htmlspecialchars_decode($value));
			}
			$this->_tpl_vars[$tpl_var] =& $value;
		}
	}
	
	function &get_template_vars($name = null)
	{
		$root =& XCube_Root::getSingleton();
		if (!isset($name)) {
			foreach ($this->_mContextReserve as $t_key => $t_value) {
			    if (isset($this->_mContextReserve[$t_value])) {
				    $this->_tpl_vars[$t_key] = htmlspecialchars($root->mContext->getAttribute($this->_mContextReserve[$t_value]), ENT_QUOTES);
				}
			}
			$value =& parent::get_template_vars($name);
		}
		elseif (isset($this->_mContextReserve[$name])) {
			$value = htmlspecialchars($root->mContext->getAttribute($this->_mContextReserve[$name]), ENT_QUOTES);
		}
		else {
			$value =& parent::get_template_vars($name);
		}
		return $value;
	}
}

/**
 * Compatible render system with XOOPS 2 Themes & Templates.
 *
 * This manages theme and main render-target directly. And, this realizes
 * variable-sharing-mechanism with using smarty.
 */
class Legacy_RenderSystem extends XCube_RenderSystem
{
	var $mXoopsTpl;

	/**
	 * Temporary
	 */
	var $mThemeRenderTarget;
	
	/**
	 * Temporary
	 */
	var $mMainRenderTarget;
	
	var $_mContentsData = null;

	/**
	 * @type XCube_Delegate
	 */
	var $mSetupXoopsTpl = null;

	var $mBeginRender = null;
	
	function __construct()
	{
		parent::__construct();
		$this->mSetupXoopsTpl = new XCube_Delegate();
		$this->mSetupXoopsTpl->register('Legacy_RenderSystem.SetupXoopsTpl');

		$this->mBeginRender = new XCube_Delegate();
		$this->mBeginRender->register("Legacy_RenderSystem.BeginRender");
	}
	
	function prepare(&$controller)
	{
		parent::prepare($controller);
		
		$root =& $this->mController->mRoot;
		$context =& $root->getContext();
		$textFilter =& $root->getTextFilter();
		
		$this->mXoopsTpl = new Legacy_XoopsTpl();
		$this->mSetupXoopsTpl->call(new XCube_Ref($this->mXoopsTpl));
		
		$this->mXoopsTpl->xoops_setCaching(0);

		// If debugger request debugging to me, send debug mode signal by any methods.
		if ($controller->mDebugger->isDebugRenderSystem()) {
			$this->mXoopsTpl->xoops_setDebugging(true);
		}
		
   		$this->mXoopsTpl->assign(array('xoops_requesturi' => htmlspecialchars(xoops_getenv('xoopsRequestUri'), ENT_QUOTES),	//@todo ?????????????
							// set JavaScript/Weird, but need extra <script> tags for 2.0.x themes
							'xoops_js' => '//--></script><script type="text/javascript" src="'.XOOPS_URL.'/include/xoops.js"></script><script type="text/javascript"><!--'
						));
		$this->mXoopsTpl->assign('xoops_sitename', $textFilter->toShow($context->getAttribute('legacy_sitename')));
		$this->mXoopsTpl->assign('xoops_pagetitle', $textFilter->toShow($context->getAttribute('legacy_pagetitle')));
		$this->mXoopsTpl->assign('xoops_slogan', $textFilter->toShow($context->getAttribute('legacy_slogan')));

		// --------------------------------------
		// Meta tags
		// --------------------------------------
        $moduleHandler =& xoops_gethandler('module');
        $legacyRender =& $moduleHandler->getByDirname('legacyRender');
		
		// --------------------------------------
		// Add User
		// --------------------------------------
		$arr = null;
		if (is_object($context->mXoopsUser)) {
			$arr = array(
				'xoops_isuser' => true,
				'xoops_userid' => $context->mXoopsUser->getShow('uid'),
				'xoops_uname' => $context->mXoopsUser->getShow('uname')
			);
		}
		else {
			$arr = array(
				'xoops_isuser' => false
			);
		}
		
		$this->mXoopsTpl->assign($arr);
	}

	function setAttribute($key,$value)
	{
		$this->mRenderTarget->setAttribute($key,$value);
	}
	
	function getAttribute($key)
	{
		$this->mRenderTarget->getAttribute($key);
	}

	/**
	 * @protected
	 * Assign common variables for the compatibility with X2.
	 */
	function _commonPrepareRender()
	{
		$root =& $this->mController->mRoot;
		$context =& $root->getContext();
		$textFilter =& $root->getTextFilter();

		$themeName = $context->getThemeName();
   		$this->mXoopsTpl->assign('xoops_theme', $themeName);
   		$this->mXoopsTpl->assign('xoops_imageurl', XOOPS_THEME_URL . '/' . $themeName . '/');
   		$this->mXoopsTpl->assign('xoops_themecss', XOOPS_THEME_URL . '/' . $themeName . '/style.css');

		$this->mXoopsTpl->assign('xoops_sitename', $textFilter->toShow($context->getAttribute('legacy_sitename')));
		$this->mXoopsTpl->assign('xoops_pagetitle', $textFilter->toShow($context->getAttribute('legacy_pagetitle')));
		$this->mXoopsTpl->assign('xoops_slogan', $textFilter->toShow($context->getAttribute('legacy_slogan')));

		//
		// Assign module informations.
		//
		if($context->mModule != null) {	// The process of module
			$xoopsModule =& $context->mXoopsModule;
			$this->mXoopsTpl->assign(array('xoops_modulename' => $xoopsModule->getShow('name'),
			                               'xoops_dirname' => $xoopsModule->getShow('dirname')));
		}
		
        $this->mXoopsTpl->assign('xoops_isadmin', $context->mUser->isInRole('Site.Administrator'));
	}
	
	function renderBlock(&$target)
	{
		$this->_commonPrepareRender();
		
		//
		// Temporary
		//
		$this->mXoopsTpl->xoops_setCaching(0);

		foreach($target->getAttributes() as $key=>$value) {
			$this->mXoopsTpl->assign($key,$value);
		}

		$this->mBeginRender->call(new XCube_Ref($this->mXoopsTpl));
		$result=&$this->mXoopsTpl->fetchBlock($target->getTemplateName(),$target->getAttribute("bid"));
		$target->setResult($result);
		
		//
		// Reset
		//
		foreach($target->getAttributes() as $key=>$value) {
			$this->mXoopsTpl->clear_assign($key);
		}
	}
	
	function _render(&$target)
	{
		foreach($target->getAttributes() as $key=>$value) {
			$this->mXoopsTpl->assign($key,$value);
		}

		$this->mBeginRender->call(new XCube_Ref($this->mXoopsTpl), $target->getAttribute('legacy_buffertype'));
		$result=$this->mXoopsTpl->fetch("db:".$target->getTemplateName());
		$target->setResult($result);

		foreach ($target->getAttributes() as $key => $value) {
			$this->mXoopsTpl->clear_assign($key);
		}
	}
	
	function render(&$target)
	{
		//
		// The following lines are temporary until we will finish changing the style!
		//
		switch ($target->getAttribute('legacy_buffertype')) {
			case XCUBE_RENDER_TARGET_TYPE_BLOCK:
				$this->renderBlock($target);
				break;

			case XCUBE_RENDER_TARGET_TYPE_MAIN:
				$this->renderMain($target);
				break;

			case XCUBE_RENDER_TARGET_TYPE_THEME:
				$this->renderTheme($target);
				break;

			case XCUBE_RENDER_TARGET_TYPE_BUFFER:
			default:
				break;
		}
	}

	function renderMain(&$target)
	{
		$this->_commonPrepareRender();
		
		foreach($target->getAttributes() as $key=>$value) {
			$this->mXoopsTpl->assign($key,$value);
		}

		if ($target->getTemplateName()) {
            $contents=$this->mXoopsTpl->fetch('db:'.$target->getTemplateName());
		} else {
            $contents=$target->getAttribute("stdout_buffer");
		}
		
		$target->setResult($contents);
	}

	function renderTheme(&$target)
	{
		$this->_commonPrepareRender();

		//
		// Assign from attributes of the render-target.
		//
		foreach($target->getAttributes() as $key => $value) {
			$this->mXoopsTpl->assign($key, $value);
		}
		
		//
		// [TODO]
		// We must implement with a render-target.
		//
		// $this->_processLegacyTemplate();

		// assing
		/// @todo I must move these to somewhere.
		$assignNameMap = array(
				XOOPS_SIDEBLOCK_LEFT=>array('showflag'=>'xoops_showlblock','block'=>'xoops_lblocks'),
				XOOPS_CENTERBLOCK_LEFT=>array('showflag'=>'xoops_showcblock','block'=>'xoops_clblocks'),
				XOOPS_CENTERBLOCK_RIGHT=>array('showflag'=>'xoops_showcblock','block'=>'xoops_crblocks'),
				XOOPS_CENTERBLOCK_CENTER=>array('showflag'=>'xoops_showcblock','block'=>'xoops_ccblocks'),
				XOOPS_SIDEBLOCK_RIGHT=>array('showflag'=>'xoops_showrblock','block'=>'xoops_rblocks')
			);

		foreach($assignNameMap as $key=>$val) {
			$this->mXoopsTpl->assign($val['showflag'],$this->_getBlockShowFlag($val['showflag']));
			if(isset($this->mController->mRoot->mContext->mAttributes['legacy_BlockContents'][$key])) {
				foreach($this->mController->mRoot->mContext->mAttributes['legacy_BlockContents'][$key] as $result) {
					$this->mXoopsTpl->append($val['block'], $result);
				}
			}
		}

		$this->mBeginRender->call(new XCube_Ref($this->mXoopsTpl));
		
		//
		// Render result, and set it to the RenderBuffer of the $target.
		//
		$result=null;
		if($target->getAttribute("isFileTheme")) {
			$result=$this->mXoopsTpl->fetch($target->getTemplateName()."/theme.html");
		}
		else {
			$result=$this->mXoopsTpl->fetch("db:".$target->getTemplateName());
		}
		
		$result .= $this->mXoopsTpl->fetchDebugConsole();

		$target->setResult($result);
	}

	function _getBlockShowFlag($area) {
		switch($area) {
			case 'xoops_showrblock' :
				return (!empty($this->mController->mRoot->mContext->mAttributes['legacy_BlockShowFlags'][XOOPS_SIDEBLOCK_RIGHT])) ? 1 : 0;
				break;
			case 'xoops_showlblock' :
				return (!empty($this->mController->mRoot->mContext->mAttributes['legacy_BlockShowFlags'][XOOPS_SIDEBLOCK_LEFT])) ? 1 : 0;
				break;
			case 'xoops_showcblock' :
				return (!empty($this->mController->mRoot->mContext->mAttributes['legacy_BlockShowFlags'][XOOPS_CENTERBLOCK_LEFT])||
				        !empty($this->mController->mRoot->mContext->mAttributes['legacy_BlockShowFlags'][XOOPS_CENTERBLOCK_RIGHT])||
				        !empty($this->mController->mRoot->mContext->mAttributes['legacy_BlockShowFlags'][XOOPS_CENTERBLOCK_CENTER])) ? 1 : 0;
				break;
			default :
				return 0;
		}
	}
	//
	// There must not be the following functions here!
	//
	//
	
	function &createRenderTarget($type = LEGACY_RENDER_TARGET_TYPE_MAIN, $option = null)
	{
		$renderTarget = null;
		switch ($type) {
			case XCUBE_RENDER_TARGET_TYPE_MAIN:
				$renderTarget = new Legacy_RenderTargetMain();
				break;
				
			case LEGACY_RENDER_TARGET_TYPE_BLOCK:
				$renderTarget = new XCube_RenderTarget();
				$renderTarget->setAttribute('legacy_buffertype', LEGACY_RENDER_TARGET_TYPE_BLOCK);
				break;
				
			default:
				$renderTarget = new XCube_RenderTarget();
				break;
		}

		return $renderTarget;
	}
	
	/**
	 * @TODO This function is not cool!
	 */
	function &getThemeRenderTarget($isDialog = false)
	{
		$screenTarget = $isDialog ? new Legacy_DialogRenderTarget() : new Legacy_ThemeRenderTarget();
		return $screenTarget;
	}
}

?>
