<?php
/**
 *
 * @package Legacy
 * @version $Id: PreferenceEditAction.class.php,v 1.11 2008/09/25 15:11:54 kilica Exp $
 * @copyright Copyright 2005-2007 XOOPS Cube Project  <http://xoopscube.sourceforge.net/> 
 * @license http://xoopscube.sourceforge.net/license/GPL_V2.txt GNU GENERAL PUBLIC LICENSE Version 2
 *
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/legacy/admin/forms/PreferenceEditForm.class.php";

define("LEGACY_PEREFERENCE_ID_GENERAL", 1);

class Legacy_PreferenceEditAction extends Legacy_Action
{
	var $mPreparedFlag = false;
	
	var $mCategory = null;
	var $mModule = null;

	var $mObjects = array();
	var $mActionForm = null;
	
	var $mState = null;

	function prepare(&$controller, &$xoopsUser)
	{
		$this->mState = ($controller->mRoot->mContext->mRequest->getRequest('confmod_id') > 0) ? new Legacy_ModulePreferenceEditState($this) : new Legacy_PreferenceEditState($this);
		$this->mState->prepare($controller, $xoopsUser);
		
		if ($this->mPreparedFlag) {
			$handler =& xoops_gethandler('config');
			
			$criteria = new CriteriaCompo();
			$criteria->add(new Criteria('conf_modid', $this->mActionForm->getModuleId()));
			$criteria->add(new Criteria('conf_catid', $this->mActionForm->getCategoryId()));
			
			$this->mObjects =& $handler->getConfigs($criteria);
			$this->mActionForm->prepare($this->mObjects);
		}
	}
	
	function getDefaultView(&$controller, &$xoopsUser)
	{
		if (!$this->mPreparedFlag) {
			return LEGACY_FRAME_VIEW_ERROR;
		}
		
		return LEGACY_FRAME_VIEW_INPUT;
	}
	
	function hasPermission(&$controller, &$xoopsUser)
	{
		return $this->mState->hasPermission($controller, $xoopsUser);
	}
	
	function execute(&$controller, &$xoopsUser)
	{
		if (!$this->mPreparedFlag) {
			return LEGACY_FRAME_VIEW_ERROR;
		}
		
		if ($controller->mRoot->mContext->mRequest->getRequest('_form_control_cancel') != null) {
			return LEGACY_FRAME_VIEW_CANCEL;
		}
		
		$this->mActionForm->fetch();
		$this->mActionForm->validate();
		
		if ($this->mActionForm->hasError()) {
			return $this->getDefaultView($controller, $xoopsUser);
		}
		
		$this->mActionForm->update($this->mObjects);
		$handler =& xoops_gethandler('config');
		
		foreach (array_keys($this->mObjects) as $key) {
			if (!$handler->insertConfig($this->mObjects[$key])) {
				die("ERROR" . $this->mObjects[$key]->get('conf_name'));
			}
		}
		
		$this->mState->postFilter($this->mObjects, $this->mActionForm);
		
		return LEGACY_FRAME_VIEW_SUCCESS;
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("preference_edit.html");
		$render->setAttribute('actionForm', $this->mActionForm);
		$render->setAttribute('objectArr', $this->mObjects);
		
		$render->setAttribute('category', $this->mCategory);
		$render->setAttribute('module', $this->mModule);
		
		$formtypeArr = array();
		foreach ($this->mObjects as $object) {
			$formtypeArr[] = $object->get('conf_formtype');
		}
		$formtypeArr = array_unique($formtypeArr);
		
		//
		// Make the array of timezone object
		//
		if (in_array('timezone', $formtypeArr)) {
			$handler =& xoops_gethandler('timezone');
			$timezoneArr =& $handler->getObjects();
			$render->setAttribute('timezoneArr', $timezoneArr);
		}
		
		//
		// Make the array of group object
		//
		if (in_array('group', $formtypeArr)||in_array('group_multi', $formtypeArr)) {
			$handler =& xoops_gethandler('group');
			$groupArr =& $handler->getObjects();
			$render->setAttribute('groupArr', $groupArr);
		}

		//
		// Make the array of tplset object
		//
		if (in_array('tplset', $formtypeArr)) {
			$handler =& xoops_gethandler('tplset');
			$tplsetArr =& $handler->getObjects();
			$render->setAttribute('tplsetArr', $tplsetArr);
		}
		
		//
		// Make the array of module object
		//
		if (in_array('module', $formtypeArr)) {
			$handler =& xoops_gethandler('module');
			$criteria = new CriteriaCompo();
			$criteria->add(new Criteria('hasmain', 1));
			$criteria->add(new Criteria('isactive', 1));
			$moduleArr = $handler->getObjects($criteria);
			$render->setAttribute('moduleArr', $moduleArr);
		}
		
		//
		// Make the list of theme.
		//
		if (in_array('theme', $formtypeArr)||in_array('theme_multi', $formtypeArr)) {
			$handler =& xoops_getmodulehandler('theme');
			$themeArr =& $handler->getObjects();
			$render->setAttribute('themeArr', $themeArr);
		}
		
		//
		// Make the list of user
		//
		if (in_array('user', $formtypeArr)||in_array('user_multi', $formtypeArr)) {
			$handler =& xoops_gethandler('member');
			$userArr = $handler->getUserList();
			$render->setAttribute('userArr', $userArr);
		}
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$this->mState->executeViewSuccess($controller, $xoopsUser, $render);
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeRedirect("./index.php?action=PreferenceList", 1, _MD_LEGACY_ERROR_DBUPDATE_FAILED);
	}
	
	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
		$this->mState->executeViewCancel($controller, $xoopsUser, $render);
	}
}

class Legacy_AbstractPreferenceEditState
{
	var $_mMaster = null;

	function Legacy_AbstractPreferenceEditState(&$master)
	{
		$this->_mMaster =& $master;
	}
	
	function prepare(&$controller, &$xoopsUser)
	{
	}
	
	function hasPermission(&$controller, &$xoopsUser)
	{
	}
	
	function postFilter(&$objectArr, &$actionForm)
	{
	}
	
	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
	}
}

class Legacy_PreferenceEditState extends Legacy_AbstractPreferenceEditState
{
	function prepare(&$controller, &$xoopsUser)
	{
		parent::prepare($controller, $xoopsUser);
		
		$handler =& xoops_gethandler('configcategory');
		$this->_mMaster->mCategory =& $handler->get(intval($controller->mRoot->mContext->mRequest->getRequest('confcat_id')));
		
		if (!is_object($this->_mMaster->mCategory)) {
			return;
		}

		$this->_mMaster->mActionForm = new Legacy_PreferenceEditForm($this->_mMaster->mCategory);
		
		$this->_mMaster->mPreparedFlag = true;
	}
	
	function hasPermission(&$controller, &$xoopsUser)
	{
		$moduleHandler =& xoops_gethandler('module');
		$module =& $moduleHandler->getByDirname('legacy');
		
		$permHandler =& xoops_gethandler('groupperm');
		return $permHandler->checkRight('module_admin', $module->get('mid'), $xoopsUser->getGroups());
	}
	
	function postFilter(&$objectArr, &$actionForm)
	{
		$themeName = null;
		$allowedThemes = null;
		foreach (array_keys($objectArr) as $key) {
			$name = $objectArr[$key]->get('conf_name');
			if ($name == 'theme_set') {
				$themeName = $objectArr[$key]->getConfValueForOutput();
			}
			elseif ($name == 'theme_set_allowed') {
				$allowedThemes = $actionForm->get('theme_set_allowed');
			}
		}
		
		if ($name != null && $allowedThemes != null) {
			XCube_DelegateUtils::call('Legacy.Event.ThemeSettingChanged', $themeName, $allowedThemes);
		}
	}
	
	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=PreferenceList");
	}

	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=PreferenceList");
	}
}

class Legacy_ModulePreferenceEditState extends Legacy_AbstractPreferenceEditState
{
	function prepare(&$controller, &$xoopsUser)
	{
		parent::prepare($controller, $xoopsUser);
		
		$handler =& xoops_gethandler('module');
		$this->_mMaster->mModule =& $handler->get(intval($controller->mRoot->mContext->mRequest->getRequest('confmod_id')));

        if (!(is_object($this->_mMaster->mModule) && $this->_mMaster->mModule->get('isactive') && $this->_mMaster->mModule->get('hasconfig'))) {
			// Exception
			$controller->executeForward(XOOPS_URL . '/admin.php');
		}

		$this->_mMaster->mActionForm = new Legacy_ModulePreferenceEditForm($this->_mMaster->mModule);
		
		//
		// Load constants
		//
		$root =& XCube_Root::getSingleton();
		$root->mLanguageManager->loadModinfoMessageCatalog($this->_mMaster->mModule->get('dirname'));
		
		$this->_mMaster->mPreparedFlag = true;
	}

	function hasPermission(&$controller, &$xoopsUser)
	{
		$controller->mRoot->mRoleManager->loadRolesByModule($this->_mMaster->mModule);
		return $controller->mRoot->mContext->mUser->isInRole('Module.' . $this->_mMaster->mModule->get('dirname') . '.Admin');
	}
	
	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		//
		// TODO The following URL is a wrong for some module which hasn't admin directory.
		//
		$controller->executeForward(XOOPS_MODULE_URL . '/' . $this->_mMaster->mModule->get('dirname') . '/admin/');
	}

	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
		//
		// TODO The following URL is a wrong for some module which hasn't admin directory.
		//
		$controller->executeForward(XOOPS_MODULE_URL . '/' . $this->_mMaster->mModule->get('dirname') . '/admin/');
	}
}
?>
